/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.entity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.util.GenericUtils;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class IdentityCache {
    private final BiMap<Key, Integer> chunkMaterial = HashBiMap.create();
    private final BiMap<Key, Integer> chunkSpawner = HashBiMap.create();
    private final BiMap<Key, Integer> chunkWorth = HashBiMap.create();
    private final BiMap<Key, Integer> chunkPos = HashBiMap.create();
    private final BiMap<Key, Integer> material = HashBiMap.create();
    private final BiMap<Key, Integer> spawner = HashBiMap.create();
    private final BiMap<Key, Integer> world = HashBiMap.create();
    private final BiMap<Key, Integer> worth = HashBiMap.create();
    private final Set<String> faction = new HashSet<String>();
    private final Table<String, Integer, Integer> factionMaterial = HashBasedTable.create();
    private final Table<String, Integer, Integer> factionSpawner = HashBasedTable.create();
    private final Table<String, Integer, Integer> factionWorth = HashBasedTable.create();
    private final BiMap<Key, Integer> block = HashBiMap.create();
    private final BiMap<Key, Integer> sign = HashBiMap.create();

    public Set<String> getFactionIds() {
        return this.faction;
    }

    public boolean hasChunkMaterial(int chunkId, int materialId) {
        return this.chunkMaterial.containsKey(new Key(new Integer[]{chunkId, materialId}));
    }

    public boolean hasChunkSpawner(int chunkId, int spawnerId) {
        return this.chunkSpawner.containsKey(new Key(new Integer[]{chunkId, spawnerId}));
    }

    public boolean hasChunkWorth(int chunkId, int worthId) {
        return this.chunkWorth.containsKey(new Key(new Integer[]{chunkId, worthId}));
    }

    public boolean hasChunkPos(int worldId, int x, int z) {
        return this.chunkPos.containsKey(new Key(new Integer[]{worldId, x, z}));
    }

    public boolean hasMaterial(String name) {
        return this.material.containsKey(new Key(new String[]{name}));
    }

    public boolean hasSpawner(String name) {
        return this.spawner.containsKey(new Key(new String[]{name}));
    }

    public boolean hasWorld(String name) {
        return this.world.containsKey(new Key(new String[]{name}));
    }

    public boolean hasWorth(String name) {
        return this.worth.containsKey(new Key(new String[]{name}));
    }

    public boolean hasFaction(String factionId) {
        return this.faction.contains(factionId);
    }

    public boolean hasFactionMaterial(String factionId, int materialId) {
        return this.factionMaterial.contains((Object)factionId, (Object)materialId);
    }

    public boolean hasFactionSpawner(String factionId, int spawnerId) {
        return this.factionSpawner.contains((Object)factionId, (Object)spawnerId);
    }

    public boolean hasFactionWorth(String factionId, int worthId) {
        return this.factionWorth.contains((Object)factionId, (Object)worthId);
    }

    public boolean hasBlock(int worldId, int x, int y, int z) {
        return this.block.containsKey(new Key(new Integer[]{worldId, x, y, z}));
    }

    public boolean hasSign(int blockId) {
        return this.sign.containsKey(new Key(new Integer[]{blockId}));
    }

    public Integer getChunkMaterialId(int chunkId, int materialId) {
        return (Integer)this.chunkMaterial.get(new Key(new Integer[]{chunkId, materialId}));
    }

    public Integer getChunkSpawnerId(int chunkId, int spawnerId) {
        return (Integer)this.chunkSpawner.get(new Key(new Integer[]{chunkId, spawnerId}));
    }

    public Integer getChunkWorthId(int chunkId, int worthId) {
        return (Integer)this.chunkWorth.get(new Key(new Integer[]{chunkId, worthId}));
    }

    public Integer getChunkPosId(int worldId, int x, int z) {
        return (Integer)this.chunkPos.get(new Key(new Integer[]{worldId, x, z}));
    }

    public Integer getMaterialId(String name) {
        return (Integer)this.material.get(new Key(new String[]{name}));
    }

    public Integer getSpawnerId(String name) {
        return (Integer)this.spawner.get(new Key(new String[]{name}));
    }

    public Integer getWorldId(String name) {
        return (Integer)this.world.get(new Key(new String[]{name}));
    }

    public Integer getWorthId(String name) {
        return (Integer)this.worth.get(new Key(new String[]{name}));
    }

    public Integer getFactionMaterialId(String factionId, int materialId) {
        return (Integer)this.factionMaterial.get((Object)factionId, (Object)materialId);
    }

    public Integer getFactionSpawnerId(String factionId, int spawnerId) {
        return (Integer)this.factionSpawner.get((Object)factionId, (Object)spawnerId);
    }

    public Integer getFactionWorthId(String factionId, int worthId) {
        return (Integer)this.factionWorth.get((Object)factionId, (Object)worthId);
    }

    public Integer getBlockId(int worldId, int x, int y, int z) {
        return (Integer)this.block.get(new Key(new Integer[]{worldId, x, y, z}));
    }

    public Integer getSignId(int blockId) {
        return (Integer)this.sign.get(new Key(new Integer[]{blockId}));
    }

    public Optional<String> getWorldName(int worldId) {
        Key key = (Key)this.world.inverse().get((Object)worldId);
        return key == null ? Optional.empty() : Optional.of((String)key.getObjects()[0]);
    }

    public Optional<Material> getMaterial(int materialId) {
        Key key = (Key)this.material.inverse().get((Object)materialId);
        return key == null ? Optional.empty() : GenericUtils.parseEnum(Material.class, (String)key.getObjects()[0]);
    }

    public Optional<EntityType> getSpawner(int spawnerId) {
        Key key = (Key)this.spawner.inverse().get((Object)spawnerId);
        return key == null ? Optional.empty() : GenericUtils.parseEnum(EntityType.class, (String)key.getObjects()[0]);
    }

    public Optional<WorthType> getWorthType(int worthId) {
        Key key = (Key)this.worth.inverse().get((Object)worthId);
        return key == null ? Optional.empty() : GenericUtils.parseEnum(WorthType.class, (String)key.getObjects()[0]);
    }

    public Optional<BlockPos> getBlock(int blockId) {
        Key key = (Key)this.block.inverse().get((Object)blockId);
        int worldId = (Integer)key.getObjects()[0];
        int x = (Integer)key.getObjects()[1];
        int y = (Integer)key.getObjects()[2];
        int z = (Integer)key.getObjects()[3];
        Optional<String> worldName = this.getWorldName(worldId);
        return worldName.isPresent() ? Optional.of(BlockPos.of(worldName.get(), x, y, z)) : Optional.empty();
    }

    public void setChunkMaterialId(int chunkId, int materialId, Integer value) {
        this.chunkMaterial.put(new Key(new Integer[]{chunkId, materialId}), (Object)value);
    }

    public void setChunkSpawnerId(int chunkId, int spawnerId, Integer value) {
        this.chunkSpawner.put(new Key(new Integer[]{chunkId, spawnerId}), (Object)value);
    }

    public void setChunkWorthId(int chunkId, int worthId, Integer value) {
        this.chunkWorth.put(new Key(new Integer[]{chunkId, worthId}), (Object)value);
    }

    public void setChunkPosId(int worldId, int x, int z, Integer value) {
        this.chunkPos.put(new Key(new Integer[]{worldId, x, z}), (Object)value);
    }

    public void setMaterialId(String name, Integer value) {
        this.material.put(new Key(new String[]{name}), (Object)value);
    }

    public void setSpawnerId(String name, Integer value) {
        this.spawner.put(new Key(new String[]{name}), (Object)value);
    }

    public void setWorldId(String name, Integer value) {
        this.world.put(new Key(new String[]{name}), (Object)value);
    }

    public void setWorthId(String name, Integer value) {
        this.worth.put(new Key(new String[]{name}), (Object)value);
    }

    public void addFaction(String factionId) {
        this.faction.add(factionId);
    }

    public void removeFaction(String factionId) {
        this.faction.remove(factionId);
        this.factionMaterial.row((Object)factionId).clear();
        this.factionSpawner.row((Object)factionId).clear();
        this.factionWorth.row((Object)factionId).clear();
    }

    public void setFactionMaterialId(String factionId, int materialId, Integer value) {
        this.factionMaterial.put((Object)factionId, (Object)materialId, (Object)value);
    }

    public void setFactionSpawnerId(String factionId, int spawnerId, Integer value) {
        this.factionSpawner.put((Object)factionId, (Object)spawnerId, (Object)value);
    }

    public void setFactionWorthId(String factionId, int worthId, Integer value) {
        this.factionWorth.put((Object)factionId, (Object)worthId, (Object)value);
    }

    public void setBlockId(int worldId, int x, int y, int z, Integer value) {
        this.block.put(new Key(new Integer[]{worldId, x, y, z}), (Object)value);
    }

    public void setSignId(int blockId, Integer value) {
        this.sign.put(new Key(new Integer[]{blockId}), (Object)value);
    }

    private static class Key<T> {
        private final T[] objects;

        @SafeVarargs
        private Key(T ... objects) {
            this.objects = objects;
        }

        public T[] getObjects() {
            return this.objects;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Arrays.equals(this.objects, key.objects);
        }

        public int hashCode() {
            return Arrays.hashCode(this.objects);
        }
    }
}

