/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.entity;

import java.util.Objects;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class BlockPos {
    private final String world;
    private final int x;
    private final int y;
    private final int z;

    public static BlockPos of(Block block) {
        return new BlockPos(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    public static BlockPos of(String world, int x, int y, int z) {
        return new BlockPos(world, x, y, z);
    }

    private BlockPos(String world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Block getBlock(Server server) {
        if (server.getWorld(this.world) == null) {
            return null;
        }
        return server.getWorld(this.world).getBlockAt(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPos blockPos = (BlockPos)o;
        return this.x == blockPos.x && Double.compare(blockPos.y, this.y) == 0 && Double.compare(blockPos.z, this.z) == 0 && Objects.equals(this.world, blockPos.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.y, this.z);
    }

    public String toString() {
        return "BlockPos{world='" + this.world + '\'' + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

