/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.novucs.ftop.entity.IdentityCache;

public class WorldModel {
    private static final String INSERT = "INSERT INTO `world` (`name`) VALUES(?)";
    private final List<String> insertionQueue = new LinkedList<String>();
    private final IdentityCache identityCache;
    private final PreparedStatement insert;

    private WorldModel(IdentityCache identityCache, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.insert = insert;
    }

    public static WorldModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new WorldModel(identityCache, insert);
    }

    public void executeBatch() throws SQLException {
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (String world : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            this.identityCache.setWorldId(world, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.insert.close();
    }

    public void addBatch(Collection<String> worlds) throws SQLException {
        for (String world : worlds) {
            this.addBatch(world);
        }
    }

    public void addBatch(String world) throws SQLException {
        if (this.insertionQueue.contains(world) || this.identityCache.hasWorld(world)) {
            return;
        }
        this.insert.setString(1, world);
        this.insert.addBatch();
        this.insertionQueue.add(world);
    }
}

