/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.novucs.ftop.entity.IdentityCache;
import org.bukkit.entity.EntityType;

public class SpawnerModel {
    private static final String INSERT = "INSERT INTO `spawner` (`name`) VALUES(?)";
    private final List<EntityType> insertionQueue = new LinkedList<EntityType>();
    private final IdentityCache identityCache;
    private final PreparedStatement insert;

    private SpawnerModel(IdentityCache identityCache, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.insert = insert;
    }

    public static SpawnerModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new SpawnerModel(identityCache, insert);
    }

    public void executeBatch() throws SQLException {
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (EntityType spawner : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            this.identityCache.setSpawnerId(spawner.name(), id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.insert.close();
    }

    public void addBatch(Collection<EntityType> spawners) throws SQLException {
        for (EntityType spawner : spawners) {
            this.addBatch(spawner);
        }
    }

    public void addBatch(EntityType spawner) throws SQLException {
        if (this.insertionQueue.contains(spawner) || this.identityCache.hasSpawner(spawner.name())) {
            return;
        }
        this.insert.setString(1, spawner.name());
        this.insert.addBatch();
        this.insertionQueue.add(spawner);
    }
}

