/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.entity.IdentityCache;

public class SignModel {
    private static final String UPDATE = "UPDATE `sign` SET `rank` = ? WHERE `id` = ?";
    private static final String INSERT = "INSERT INTO `sign` (`block_id`, `rank`) VALUES(?, ?)";
    private static final String DELETE = "DELETE FROM `sign` WHERE `id` = ?";
    private final List<Integer> insertionQueue = new LinkedList<Integer>();
    private final IdentityCache identityCache;
    private final PreparedStatement update;
    private final PreparedStatement insert;
    private final PreparedStatement delete;

    private SignModel(IdentityCache identityCache, PreparedStatement update, PreparedStatement insert, PreparedStatement delete) {
        this.identityCache = identityCache;
        this.update = update;
        this.insert = insert;
        this.delete = delete;
    }

    public static SignModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement update = connection.prepareStatement(UPDATE);
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        PreparedStatement delete = connection.prepareStatement(DELETE);
        return new SignModel(identityCache, update, insert, delete);
    }

    public void executeBatch() throws SQLException {
        this.delete.executeBatch();
        this.update.executeBatch();
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Integer blockId : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            this.identityCache.setSignId(blockId, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.update.close();
        this.insert.close();
        this.delete.close();
    }

    public void addBatch(Set<Map.Entry<BlockPos, Integer>> signs) throws SQLException {
        for (Map.Entry<BlockPos, Integer> entry : signs) {
            BlockPos block = entry.getKey();
            int worldId = this.identityCache.getWorldId(block.getWorld());
            int blockId = this.identityCache.getBlockId(worldId, block.getX(), block.getY(), block.getZ());
            int rank = entry.getValue();
            this.addBatch(blockId, rank);
        }
    }

    public void addBatch(int blockId, int rank) throws SQLException {
        Integer id = this.identityCache.getSignId(blockId);
        if (id == null) {
            this.insertSign(blockId, rank);
        } else {
            this.updateSign(id, rank);
        }
    }

    private void insertSign(int blockId, int rank) throws SQLException {
        this.insert.setInt(1, blockId);
        this.insert.setInt(2, rank);
        this.insert.addBatch();
        this.insertionQueue.add(blockId);
    }

    private void updateSign(int id, int rank) throws SQLException {
        this.update.setInt(1, rank);
        this.update.setInt(2, id);
        this.update.addBatch();
    }

    public void addBatchDelete(Set<BlockPos> signs) throws SQLException {
        for (BlockPos block : signs) {
            int worldId = this.identityCache.getWorldId(block.getWorld());
            int blockId = this.identityCache.getBlockId(worldId, block.getX(), block.getY(), block.getZ());
            this.addBatchDelete(blockId);
        }
    }

    public void addBatchDelete(int blockId) throws SQLException {
        Integer signId = this.identityCache.getSignId(blockId);
        if (signId == null) {
            return;
        }
        this.delete.setInt(1, signId);
        this.delete.addBatch();
        this.identityCache.setSignId(blockId, null);
    }
}

