/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.novucs.ftop.entity.IdentityCache;
import org.bukkit.Material;

public class MaterialModel {
    private static final String INSERT = "INSERT INTO `material` (`name`) VALUES(?)";
    private final List<Material> insertionQueue = new LinkedList<Material>();
    private final IdentityCache identityCache;
    private final PreparedStatement insert;

    private MaterialModel(IdentityCache identityCache, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.insert = insert;
    }

    public static MaterialModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new MaterialModel(identityCache, insert);
    }

    public void executeBatch() throws SQLException {
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Material material : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            this.identityCache.setMaterialId(material.name(), id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.insert.close();
    }

    public void addBatch(Collection<Material> materials) throws SQLException {
        for (Material material : materials) {
            this.addBatch(material);
        }
    }

    public void addBatch(Material material) throws SQLException {
        if (this.insertionQueue.contains(material) || this.identityCache.hasMaterial(material.name())) {
            return;
        }
        this.insert.setString(1, material.name());
        this.insert.addBatch();
        this.insertionQueue.add(material);
    }
}

