/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.novucs.ftop.WorthType;
import net.novucs.ftop.entity.IdentityCache;

public class FactionWorthModel {
    private static final String UPDATE = "UPDATE `faction_worth` SET `worth` = ? WHERE `id` = ?";
    private static final String INSERT = "INSERT INTO `faction_worth` (`faction_id`, `worth_id`, `worth`) VALUES (?, ?, ?)";
    private static final String DELETE = "DELETE FROM `faction_worth` WHERE `faction_id` = ?";
    private final List<Map.Entry<String, Integer>> insertionQueue = new LinkedList<Map.Entry<String, Integer>>();
    private final IdentityCache identityCache;
    private final PreparedStatement update;
    private final PreparedStatement insert;
    private final PreparedStatement delete;

    public FactionWorthModel(IdentityCache identityCache, PreparedStatement update, PreparedStatement insert, PreparedStatement delete) {
        this.identityCache = identityCache;
        this.update = update;
        this.insert = insert;
        this.delete = delete;
    }

    public static FactionWorthModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement update = connection.prepareStatement(UPDATE);
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        PreparedStatement delete = connection.prepareStatement(DELETE);
        return new FactionWorthModel(identityCache, update, insert, delete);
    }

    public void executeBatch() throws SQLException {
        this.update.executeBatch();
        this.insert.executeBatch();
        this.delete.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Map.Entry<String, Integer> entry : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            String factionId = entry.getKey();
            int worthId = entry.getValue();
            this.identityCache.setFactionWorthId(factionId, worthId, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.delete.close();
        this.update.close();
        this.insert.close();
    }

    public void addBatch(String factionId, Map<WorthType, Double> worthTypes) throws SQLException {
        for (Map.Entry<WorthType, Double> entry : worthTypes.entrySet()) {
            WorthType worthType = entry.getKey();
            double worth = entry.getValue();
            int worthId = this.identityCache.getWorthId(worthType.name());
            this.addBatch(factionId, worthId, worth);
        }
    }

    public void addBatch(String factionId, int worthId, double worth) throws SQLException {
        Integer relationId = this.identityCache.getFactionWorthId(factionId, worthId);
        AbstractMap.SimpleImmutableEntry<String, Integer> insertionKey = new AbstractMap.SimpleImmutableEntry<String, Integer>(factionId, worthId);
        if (relationId == null) {
            if (!this.insertionQueue.contains(insertionKey)) {
                this.insertCounter(factionId, worthId, worth);
                this.insertionQueue.add(insertionKey);
            }
        } else {
            this.updateCounter(worth, relationId);
        }
    }

    private void insertCounter(String factionId, int worthId, double worth) throws SQLException {
        this.insert.setString(1, factionId);
        this.insert.setInt(2, worthId);
        this.insert.setDouble(3, worth);
        this.insert.addBatch();
    }

    private void updateCounter(double worth, Integer relationId) throws SQLException {
        this.update.setDouble(1, worth);
        this.update.setInt(2, relationId);
        this.update.addBatch();
    }

    public void addBatchDelete(Collection<String> factions) throws SQLException {
        for (String factionId : factions) {
            this.addBatchDelete(factionId);
        }
    }

    public void addBatchDelete(String factionId) throws SQLException {
        this.delete.setString(1, factionId);
        this.delete.addBatch();
    }
}

