/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.novucs.ftop.entity.IdentityCache;
import org.bukkit.entity.EntityType;

public class ChunkSpawnerModel {
    private static final String UPDATE = "UPDATE `chunk_spawner_count` SET `count` = ? WHERE `id` = ?";
    private static final String INSERT = "INSERT INTO `chunk_spawner_count` (`chunk_id`, `spawner_id`, `count`) VALUES(?, ?, ?)";
    private final List<Map.Entry<Integer, Integer>> insertionQueue = new LinkedList<Map.Entry<Integer, Integer>>();
    private final IdentityCache identityCache;
    private final PreparedStatement update;
    private final PreparedStatement insert;

    private ChunkSpawnerModel(IdentityCache identityCache, PreparedStatement update, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.update = update;
        this.insert = insert;
    }

    public static ChunkSpawnerModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement update = connection.prepareStatement(UPDATE);
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new ChunkSpawnerModel(identityCache, update, insert);
    }

    public void executeBatch() throws SQLException {
        this.update.executeBatch();
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Map.Entry<Integer, Integer> entry : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            int chunkId = entry.getKey();
            int spawnerId = entry.getValue();
            this.identityCache.setChunkSpawnerId(chunkId, spawnerId, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.update.close();
        this.insert.close();
    }

    public void addBatch(int chunkId, Map<EntityType, Integer> spawners) throws SQLException {
        for (Map.Entry<EntityType, Integer> entry : spawners.entrySet()) {
            EntityType spawner = entry.getKey();
            int count = entry.getValue();
            int spawnerId = this.identityCache.getSpawnerId(spawner.name());
            this.addBatch(chunkId, spawnerId, count);
        }
    }

    public void addBatch(int chunkId, int spawnerId, int count) throws SQLException {
        Integer relationId = this.identityCache.getChunkSpawnerId(chunkId, spawnerId);
        AbstractMap.SimpleImmutableEntry<Integer, Integer> insertionKey = new AbstractMap.SimpleImmutableEntry<Integer, Integer>(chunkId, spawnerId);
        if (relationId == null) {
            if (!this.insertionQueue.contains(insertionKey)) {
                this.insertCounter(chunkId, spawnerId, count);
                this.insertionQueue.add(insertionKey);
            }
        } else {
            this.updateCounter(count, relationId);
        }
    }

    private void insertCounter(int chunkId, int spawnerId, int count) throws SQLException {
        this.insert.setInt(1, chunkId);
        this.insert.setInt(2, spawnerId);
        this.insert.setInt(3, count);
        this.insert.addBatch();
    }

    private void updateCounter(int count, Integer relationId) throws SQLException {
        this.update.setInt(1, count);
        this.update.setInt(2, relationId);
        this.update.addBatch();
    }
}

