/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.novucs.ftop.database.ChunkMaterialModel;
import net.novucs.ftop.database.ChunkSpawnerModel;
import net.novucs.ftop.database.ChunkWorthModel;
import net.novucs.ftop.database.MaterialModel;
import net.novucs.ftop.database.SpawnerModel;
import net.novucs.ftop.database.WorldModel;
import net.novucs.ftop.database.WorthModel;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.entity.ChunkWorth;
import net.novucs.ftop.entity.IdentityCache;

public class ChunkModel {
    private static final String INSERT = "INSERT INTO `chunk` (`world_id`, `x`, `z`) VALUES(?, ?, ?)";
    private final Connection connection;
    private final IdentityCache identityCache;
    private PreparedStatement insert;

    public ChunkModel(Connection connection, IdentityCache identityCache) {
        this.connection = connection;
        this.identityCache = identityCache;
    }

    public void persist(Set<Map.Entry<ChunkPos, ChunkWorth>> chunks) throws SQLException {
        this.init();
        this.persistNames(chunks);
        this.persistPositions(chunks);
        this.persistStatistics(chunks);
        this.close();
    }

    private void init() throws SQLException {
        this.insert = this.connection.prepareStatement(INSERT, 1);
    }

    private void close() throws SQLException {
        this.insert.close();
    }

    private void persistNames(Set<Map.Entry<ChunkPos, ChunkWorth>> chunks) throws SQLException {
        MaterialModel materialModel = MaterialModel.of(this.connection, this.identityCache);
        SpawnerModel spawnerModel = SpawnerModel.of(this.connection, this.identityCache);
        WorldModel worldModel = WorldModel.of(this.connection, this.identityCache);
        WorthModel worthModel = WorthModel.of(this.connection, this.identityCache);
        for (Map.Entry<ChunkPos, ChunkWorth> entry : chunks) {
            ChunkPos position = entry.getKey();
            ChunkWorth worth = entry.getValue();
            materialModel.addBatch(worth.getMaterials().keySet());
            spawnerModel.addBatch(worth.getSpawners().keySet());
            worldModel.addBatch(position.getWorld());
            worthModel.addBatch(worth.getWorth().keySet());
        }
        materialModel.executeBatch();
        spawnerModel.executeBatch();
        worldModel.executeBatch();
        worthModel.executeBatch();
        materialModel.close();
        spawnerModel.close();
        worldModel.close();
        worthModel.close();
    }

    private void persistPositions(Set<Map.Entry<ChunkPos, ChunkWorth>> chunks) throws SQLException {
        Set<Map.Entry<ChunkPos, ChunkWorth>> createdChunks = this.insertChunkPositions(chunks);
        this.cacheChunkIds(createdChunks);
    }

    private Set<Map.Entry<ChunkPos, ChunkWorth>> insertChunkPositions(Set<Map.Entry<ChunkPos, ChunkWorth>> chunks) throws SQLException {
        HashSet<Map.Entry<ChunkPos, ChunkWorth>> createdChunks = new HashSet<Map.Entry<ChunkPos, ChunkWorth>>();
        for (Map.Entry<ChunkPos, ChunkWorth> entry : chunks) {
            ChunkPos position = entry.getKey();
            int worldId = this.identityCache.getWorldId(position.getWorld());
            if (this.identityCache.hasChunkPos(worldId, position.getX(), position.getZ())) continue;
            this.insert.setInt(1, worldId);
            this.insert.setInt(2, position.getX());
            this.insert.setInt(3, position.getZ());
            this.insert.addBatch();
            createdChunks.add(entry);
        }
        this.insert.executeBatch();
        return createdChunks;
    }

    private void cacheChunkIds(Set<Map.Entry<ChunkPos, ChunkWorth>> createdChunks) throws SQLException {
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Map.Entry<ChunkPos, ChunkWorth> entry : createdChunks) {
            ChunkPos position = entry.getKey();
            int worldId = this.identityCache.getWorldId(position.getWorld());
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            this.identityCache.setChunkPosId(worldId, position.getX(), position.getZ(), id);
        }
        resultSet.close();
    }

    private void persistStatistics(Set<Map.Entry<ChunkPos, ChunkWorth>> chunks) throws SQLException {
        ChunkMaterialModel chunkMaterialModel = ChunkMaterialModel.of(this.connection, this.identityCache);
        ChunkSpawnerModel chunkSpawnerModel = ChunkSpawnerModel.of(this.connection, this.identityCache);
        ChunkWorthModel chunkWorthModel = ChunkWorthModel.of(this.connection, this.identityCache);
        for (Map.Entry<ChunkPos, ChunkWorth> entry : chunks) {
            ChunkPos position = entry.getKey();
            ChunkWorth worth = entry.getValue();
            int worldId = this.identityCache.getWorldId(position.getWorld());
            int chunkId = this.identityCache.getChunkPosId(worldId, position.getX(), position.getZ());
            chunkMaterialModel.addBatch(chunkId, worth.getMaterials());
            chunkSpawnerModel.addBatch(chunkId, worth.getSpawners());
            chunkWorthModel.addBatch(chunkId, worth.getWorth());
        }
        chunkMaterialModel.executeBatch();
        chunkSpawnerModel.executeBatch();
        chunkWorthModel.executeBatch();
        chunkMaterialModel.close();
        chunkSpawnerModel.close();
        chunkWorthModel.close();
    }
}

