/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.novucs.ftop.entity.IdentityCache;
import org.bukkit.Material;

public class ChunkMaterialModel {
    private static final String UPDATE = "UPDATE `chunk_material_count` SET `count` = ? WHERE `id` = ?";
    private static final String INSERT = "INSERT INTO `chunk_material_count` (`chunk_id`, `material_id`, `count`) VALUES(?, ?, ?)";
    private final List<Map.Entry<Integer, Integer>> insertionQueue = new LinkedList<Map.Entry<Integer, Integer>>();
    private final IdentityCache identityCache;
    private final PreparedStatement update;
    private final PreparedStatement insert;

    private ChunkMaterialModel(IdentityCache identityCache, PreparedStatement update, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.update = update;
        this.insert = insert;
    }

    public static ChunkMaterialModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement update = connection.prepareStatement(UPDATE);
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new ChunkMaterialModel(identityCache, update, insert);
    }

    public void executeBatch() throws SQLException {
        this.update.executeBatch();
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (Map.Entry<Integer, Integer> entry : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            int chunkId = entry.getKey();
            int materialId = entry.getValue();
            this.identityCache.setChunkMaterialId(chunkId, materialId, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.update.close();
        this.insert.close();
    }

    public void addBatch(int chunkId, Map<Material, Integer> materials) throws SQLException {
        for (Map.Entry<Material, Integer> entry : materials.entrySet()) {
            Material material = entry.getKey();
            int count = entry.getValue();
            int materialId = this.identityCache.getMaterialId(material.name());
            this.addBatch(chunkId, materialId, count);
        }
    }

    public void addBatch(int chunkId, int materialId, int count) throws SQLException {
        Integer relationId = this.identityCache.getChunkMaterialId(chunkId, materialId);
        AbstractMap.SimpleImmutableEntry<Integer, Integer> insertionKey = new AbstractMap.SimpleImmutableEntry<Integer, Integer>(chunkId, materialId);
        if (relationId == null) {
            if (!this.insertionQueue.contains(insertionKey)) {
                this.insertCounter(chunkId, materialId, count);
                this.insertionQueue.add(insertionKey);
            }
        } else {
            this.updateCounter(count, relationId);
        }
    }

    private void insertCounter(int chunkId, int materialId, int count) throws SQLException {
        this.insert.setInt(1, chunkId);
        this.insert.setInt(2, materialId);
        this.insert.setInt(3, count);
        this.insert.addBatch();
    }

    private void updateCounter(int count, Integer relationId) throws SQLException {
        this.update.setInt(1, count);
        this.update.setInt(2, relationId);
        this.update.addBatch();
    }
}

