/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.entity.IdentityCache;

public class BlockModel {
    private static final String INSERT = "INSERT INTO `block` (`world_id`, `x`, `y`, `z`) VALUES(?, ?, ?, ?)";
    private final List<FormattedBlockPos> insertionQueue = new LinkedList<FormattedBlockPos>();
    private final IdentityCache identityCache;
    private final PreparedStatement insert;

    private BlockModel(IdentityCache identityCache, PreparedStatement insert) {
        this.identityCache = identityCache;
        this.insert = insert;
    }

    public static BlockModel of(Connection connection, IdentityCache identityCache) throws SQLException {
        PreparedStatement insert = connection.prepareStatement(INSERT, 1);
        return new BlockModel(identityCache, insert);
    }

    public void executeBatch() throws SQLException {
        this.insert.executeBatch();
        ResultSet resultSet = this.insert.getGeneratedKeys();
        for (FormattedBlockPos block : this.insertionQueue) {
            if (!resultSet.next()) continue;
            int id = resultSet.getInt(1);
            int worldId = block.getWorldId();
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            this.identityCache.setBlockId(worldId, x, y, z, id);
        }
        resultSet.close();
        this.insertionQueue.clear();
    }

    public void close() throws SQLException {
        this.insert.close();
    }

    public void addBatch(Collection<BlockPos> blocks) throws SQLException {
        for (BlockPos block : blocks) {
            this.addBatch(block);
        }
    }

    public void addBatch(BlockPos block) throws SQLException {
        int worldId = this.identityCache.getWorldId(block.getWorld());
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        this.addBatch(worldId, x, y, z);
    }

    public void addBatch(int worldId, int x, int y, int z) throws SQLException {
        FormattedBlockPos block = new FormattedBlockPos(worldId, x, y, z);
        if (this.identityCache.hasBlock(worldId, x, y, z) || this.insertionQueue.contains(block)) {
            return;
        }
        this.insert.setInt(1, worldId);
        this.insert.setInt(2, x);
        this.insert.setInt(3, y);
        this.insert.setInt(4, z);
        this.insert.addBatch();
        this.insertionQueue.add(block);
    }

    public class FormattedBlockPos {
        private final int worldId;
        private final int x;
        private final int y;
        private final int z;

        public FormattedBlockPos(int worldId, int x, int y, int z) {
            this.worldId = worldId;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int getWorldId() {
            return this.worldId;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormattedBlockPos block = (FormattedBlockPos)o;
            return this.worldId == block.worldId && this.x == block.x && this.y == block.y && this.z == block.z;
        }

        public int hashCode() {
            return Objects.hash(this.worldId, this.x, this.y, this.z);
        }
    }
}

