/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop.command;

import java.util.HashMap;
import java.util.List;
import net.novucs.ftop.FactionsTopPlugin;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.entity.ButtonMessage;
import net.novucs.ftop.entity.FactionWorth;
import net.novucs.ftop.shade.mkremins.fanciful.FancyMessage;
import net.novucs.ftop.util.SplaySet;
import net.novucs.ftop.util.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class TextCommand
implements CommandExecutor,
PluginService {
    private final FactionsTopPlugin plugin;

    public TextCommand(FactionsTopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.plugin.getServer().getPluginCommand("ftop").setExecutor((CommandExecutor)this);
    }

    @Override
    public void terminate() {
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("factionstop.use")) {
            sender.sendMessage(this.plugin.getSettings().getPermissionMessage());
            return true;
        }
        if (args.length == 0) {
            this.sendTop(sender, 0);
        } else {
            this.sendTop(sender, NumberUtils.toInt((String)args[0]));
        }
        return true;
    }

    private void sendTop(CommandSender sender, int page) {
        int entries = this.plugin.getSettings().getFactionsPerPage();
        SplaySet<FactionWorth> factions = this.plugin.getWorthManager().getOrderedFactions();
        int maxPage = Math.max((int)Math.ceil((double)factions.size() / (double)entries), 1);
        page = Math.max(1, Math.min(maxPage, page));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{page:back}", String.valueOf(page - 1));
        placeholders.put("{page:this}", String.valueOf(page));
        placeholders.put("{page:next}", String.valueOf(page + 1));
        placeholders.put("{page:last}", String.valueOf(maxPage));
        ButtonMessage back = this.plugin.getSettings().getBackButtonMessage();
        ButtonMessage next = this.plugin.getSettings().getNextButtonMessage();
        String backMsg = page == 1 ? back.getDisabled() : back.getEnabled();
        String backCmd = page == 1 ? null : "/ftop " + (page - 1);
        List<String> backTooltip = StringUtils.replace(back.getTooltip(), placeholders);
        String nextMsg = page == maxPage ? next.getDisabled() : next.getEnabled();
        String nextCmd = page == maxPage ? null : "/ftop " + (page + 1);
        List<String> nextTooltip = StringUtils.replace(next.getTooltip(), placeholders);
        if (!this.plugin.getSettings().getHeaderMessage().isEmpty()) {
            String headerString = StringUtils.replace(this.plugin.getSettings().getHeaderMessage(), placeholders);
            FancyMessage header = this.build(headerString, backMsg, backCmd, backTooltip, nextMsg, nextCmd, nextTooltip);
            header.send(sender);
        }
        if (factions.size() == 0) {
            sender.sendMessage(this.plugin.getSettings().getNoEntriesMessage());
            return;
        }
        int spacer = entries * --page;
        SplaySet.Iterator<FactionWorth> it = factions.iterator(spacer);
        for (int i = 0; i < entries && it.hasNext(); ++i) {
            FactionWorth worth = (FactionWorth)it.next();
            HashMap<String, String> worthPlaceholders = new HashMap<String, String>(placeholders);
            worthPlaceholders.put("{rank}", Integer.toString(spacer + i + 1));
            worthPlaceholders.put("{relcolor}", "\u00a7" + StringUtils.getRelationColor(this.plugin, sender, worth.getFactionId()).getChar());
            worthPlaceholders.put("{faction}", worth.getName());
            worthPlaceholders.put("{worth:total}", this.plugin.getSettings().getCurrencyFormat().format(worth.getTotalWorth()));
            worthPlaceholders.put("{count:total:spawner}", this.plugin.getSettings().getCountFormat().format(worth.getTotalSpawnerCount()));
            String bodyMessage = StringUtils.insertPlaceholders(this.plugin.getSettings(), worth, StringUtils.replace(this.plugin.getSettings().getBodyMessage(), worthPlaceholders));
            List<String> tooltip = StringUtils.insertPlaceholders(this.plugin.getSettings(), worth, StringUtils.replace(this.plugin.getSettings().getBodyTooltip(), worthPlaceholders));
            FancyMessage message = new FancyMessage(bodyMessage).tooltip(tooltip);
            message.send(sender);
        }
        if (!this.plugin.getSettings().getFooterMessage().isEmpty()) {
            String footerString = StringUtils.replace(this.plugin.getSettings().getFooterMessage(), placeholders);
            FancyMessage footer = this.build(footerString, backMsg, backCmd, backTooltip, nextMsg, nextCmd, nextTooltip);
            footer.send(sender);
        }
    }

    private FancyMessage build(String message, String backText, String backCmd, List<String> backTooltip, String nextText, String nextCmd, List<String> nextTooltip) {
        FancyMessage fancyMessage = new FancyMessage("");
        while (!message.isEmpty()) {
            int backIndex = message.indexOf("{button:back}");
            int nextIndex = message.indexOf("{button:next}");
            backIndex = backIndex == -1 ? Integer.MAX_VALUE : backIndex;
            int n = nextIndex = nextIndex == -1 ? Integer.MAX_VALUE : nextIndex;
            if (backIndex < nextIndex) {
                fancyMessage.then(message.substring(0, backIndex)).then(backText);
                if (backCmd != null) {
                    fancyMessage.command(backCmd).tooltip(backTooltip);
                }
                message = message.substring(backIndex + 13);
                continue;
            }
            if (nextIndex < backIndex) {
                fancyMessage.then(message.substring(0, nextIndex)).then(nextText);
                if (nextCmd != null) {
                    fancyMessage.command(nextCmd).tooltip(nextTooltip);
                }
                message = message.substring(nextIndex + 13);
                continue;
            }
            fancyMessage.then(message);
            break;
        }
        return fancyMessage;
    }
}

