/*
 * Decompiled with CFR 0.152.
 */
package net.novucs.ftop;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.novucs.ftop.PluginService;
import net.novucs.ftop.Settings;
import net.novucs.ftop.command.GuiCommand;
import net.novucs.ftop.command.RecalculateCommand;
import net.novucs.ftop.command.ReloadCommand;
import net.novucs.ftop.command.TextCommand;
import net.novucs.ftop.command.VersionCommand;
import net.novucs.ftop.entity.BlockPos;
import net.novucs.ftop.entity.ChunkPos;
import net.novucs.ftop.entity.ChunkWorth;
import net.novucs.ftop.hook.ClipPlaceholderAPIHook;
import net.novucs.ftop.hook.Craftbukkit17R4;
import net.novucs.ftop.hook.Craftbukkit18R1;
import net.novucs.ftop.hook.Craftbukkit18R2;
import net.novucs.ftop.hook.Craftbukkit18R3;
import net.novucs.ftop.hook.CraftbukkitHook;
import net.novucs.ftop.hook.EconomyHook;
import net.novucs.ftop.hook.EpicSpawnersHook;
import net.novucs.ftop.hook.EssentialsEconomyHook;
import net.novucs.ftop.hook.Factions0106;
import net.novucs.ftop.hook.Factions0108;
import net.novucs.ftop.hook.Factions0207;
import net.novucs.ftop.hook.Factions0211;
import net.novucs.ftop.hook.Factions0212;
import net.novucs.ftop.hook.FactionsHook;
import net.novucs.ftop.hook.LegacyFactions0103;
import net.novucs.ftop.hook.MVdWPlaceholderAPIHook;
import net.novucs.ftop.hook.PlaceholderHook;
import net.novucs.ftop.hook.SpawnerStackerHook;
import net.novucs.ftop.hook.VanillaSpawnerStackerHook;
import net.novucs.ftop.hook.VaultEconomyHook;
import net.novucs.ftop.listener.ChatListener;
import net.novucs.ftop.listener.CommandListener;
import net.novucs.ftop.listener.GuiListener;
import net.novucs.ftop.listener.WorthListener;
import net.novucs.ftop.manager.DatabaseManager;
import net.novucs.ftop.manager.GuiManager;
import net.novucs.ftop.manager.SignManager;
import net.novucs.ftop.manager.WorthManager;
import net.novucs.ftop.replacer.LastReplacer;
import net.novucs.ftop.replacer.PlayerReplacer;
import net.novucs.ftop.replacer.RankReplacer;
import net.novucs.ftop.task.ChunkWorthTask;
import net.novucs.ftop.task.PersistenceTask;
import net.novucs.ftop.task.RecalculateTask;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class FactionsTopPlugin
extends JavaPlugin {
    private final ChunkWorthTask chunkWorthTask = new ChunkWorthTask(this);
    private final GuiManager guiManager = new GuiManager(this);
    private final PersistenceTask persistenceTask = new PersistenceTask(this);
    private final RecalculateTask recalculateTask = new RecalculateTask(this);
    private final Settings settings = new Settings(this);
    private final SignManager signManager = new SignManager(this);
    private final WorthManager worthManager = new WorthManager(this);
    private final Set<PluginService> services = new HashSet<PluginService>(Arrays.asList(this.signManager, this.worthManager, new GuiCommand(this), new RecalculateCommand(this), new ReloadCommand(this), new TextCommand(this), new VersionCommand(this), new ChatListener(this), new CommandListener(this), new GuiListener(this), new WorthListener(this)));
    private boolean active;
    private CraftbukkitHook craftbukkitHook;
    private EconomyHook economyHook;
    private FactionsHook factionsHook;
    private Set<PlaceholderHook> placeholderHooks;
    private SpawnerStackerHook spawnerStackerHook;
    private DatabaseManager databaseManager;

    public ChunkWorthTask getChunkWorthTask() {
        return this.chunkWorthTask;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public PersistenceTask getPersistenceTask() {
        return this.persistenceTask;
    }

    public RecalculateTask getRecalculateTask() {
        return this.recalculateTask;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public WorthManager getWorthManager() {
        return this.worthManager;
    }

    public CraftbukkitHook getCraftbukkitHook() {
        return this.craftbukkitHook;
    }

    public EconomyHook getEconomyHook() {
        return this.economyHook;
    }

    public FactionsHook getFactionsHook() {
        return this.factionsHook;
    }

    public SpawnerStackerHook getSpawnerStackerHook() {
        return this.spawnerStackerHook;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public void setDatabaseManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    public void onEnable() {
        if (!this.loadFactionsHook()) {
            this.getLogger().severe("No valid version of factions was found!");
            this.getLogger().severe("Disabling FactionsTop . . .");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadCraftbukkitHook();
        this.loadSpawnerStackerHook();
        if (this.loadEconomyHook()) {
            this.services.add(this.economyHook);
        }
        this.setupSlf4j();
        this.services.add(this.factionsHook);
        this.loadSettings();
        boolean newDatabase = this.loadDatabase();
        this.chunkWorthTask.start();
        this.persistenceTask.start();
        if (newDatabase && !this.recalculateTask.isRunning()) {
            this.getLogger().info("----- IMPORTANT -----");
            this.getLogger().info("Detected a fresh database");
            this.getLogger().info("Starting chunk resynchronization");
            this.getLogger().info("To cancel, type: /ftoprec cancel");
            this.getLogger().info("----- IMPORTANT -----");
            this.recalculateTask.initialize();
        }
    }

    public void onDisable() {
        this.getLogger().info("Preparing shutdown...");
        this.guiManager.closeInventories();
        if (this.recalculateTask.isRunning()) {
            this.recalculateTask.terminate();
        }
        this.getLogger().info("Shutting down chunk worth task...");
        this.chunkWorthTask.interrupt();
        try {
            this.chunkWorthTask.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getLogger().info("Saving everything to database...");
        this.persistenceTask.interrupt();
        try {
            this.persistenceTask.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getLogger().info("Terminating plugin services...");
        this.databaseManager.close();
        this.services.forEach(PluginService::terminate);
        this.active = false;
    }

    private boolean loadDatabase() {
        Multimap<Integer, BlockPos> loadedSigns;
        Map<ChunkPos, ChunkWorth> loadedChunks;
        boolean usingH2 = this.settings.getHikariConfig().getJdbcUrl().startsWith("jdbc:h2");
        if (usingH2) {
            this.setupH2();
        }
        try {
            this.databaseManager = DatabaseManager.create(this.settings.getHikariConfig());
            DatabaseManager.DataDump dataDump = this.databaseManager.load();
            loadedChunks = dataDump.getChunks();
            loadedSigns = dataDump.getSigns();
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize the database");
            this.getLogger().log(Level.SEVERE, "Are the database credentials in the config correct?");
            this.getLogger().log(Level.SEVERE, "Stack trace: ", e);
            this.getLogger().log(Level.SEVERE, "Disabling FactionsTop . . .");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        this.worthManager.loadChunks(loadedChunks);
        this.getServer().getScheduler().runTask((Plugin)this, this.worthManager::updateAllFactions);
        this.signManager.setSigns(loadedSigns);
        return loadedChunks.isEmpty();
    }

    private void setupSlf4j() {
        try {
            this.loadLibrary("https://repo.maven.apache.org/maven2/org/slf4j/slf4j-api/1.7.9/slf4j-api-1.7.9.jar");
            this.loadLibrary("https://repo.maven.apache.org/maven2/org/slf4j/slf4j-nop/1.7.9/slf4j-nop-1.7.9.jar");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupH2() {
        try {
            Class.forName("org.h2.Driver");
            this.getLogger().info("H2 successfully loaded via classpath.");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                this.loadLibrary("https://repo.maven.apache.org/maven2/com/h2database/h2/1.4.192/h2-1.4.192.jar");
                this.getLogger().info("H2 forcefully loaded, a reboot may be required.");
            }
            catch (Exception e) {
                this.getLogger().severe("H2 was unable to be loaded.");
                this.getLogger().log(Level.SEVERE, "The errors are as follows:", e);
                this.getLogger().severe("Disabling FactionsTop . . .");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
            }
            return;
        }
    }

    private void loadLibrary(String url) throws Exception {
        String fileName = url.substring(url.lastIndexOf(47) + 1);
        String pathName = "lib" + File.separator + fileName;
        File library = new File(pathName);
        if (!library.exists()) {
            this.getLogger().info("Downloading " + fileName + " dependency . . .");
            library.getParentFile().mkdirs();
            library.createNewFile();
            URL repo = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(repo.openStream());
            FileOutputStream fos = new FileOutputStream(pathName);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            this.getLogger().info(fileName + " successfully downloaded!");
        }
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ClassLoader.getSystemClassLoader(), library.toURI().toURL());
    }

    private void loadCraftbukkitHook() {
        String version = this.getServer().getClass().getPackage().getName().split("\\.")[3];
        this.craftbukkitHook = version.compareTo("v1_7_R4") <= 0 && version.split("_")[1].length() == 1 ? new Craftbukkit17R4() : (version.equals("v1_8_R1") ? new Craftbukkit18R1() : (version.equals("v1_8_R2") ? new Craftbukkit18R2() : new Craftbukkit18R3()));
    }

    private void loadSpawnerStackerHook() {
        Plugin epicSpawnersPlugin = this.getServer().getPluginManager().getPlugin("EpicSpawners");
        this.spawnerStackerHook = epicSpawnersPlugin != null ? new EpicSpawnersHook((Plugin)this, this.craftbukkitHook) : new VanillaSpawnerStackerHook(this.craftbukkitHook);
        this.spawnerStackerHook.initialize();
    }

    private boolean loadEconomyHook() {
        Plugin essentials = this.getServer().getPluginManager().getPlugin("Essentials");
        if (essentials != null) {
            this.economyHook = new EssentialsEconomyHook((Plugin)this, this.factionsHook);
            this.getLogger().info("Essentials found, using as economy backend.");
            return true;
        }
        Plugin vault = this.getServer().getPluginManager().getPlugin("Vault");
        if (vault != null) {
            this.economyHook = new VaultEconomyHook((Plugin)this, this.worthManager.getFactionIds());
            this.getLogger().info("Vault found, using as economy backend.");
            return true;
        }
        return false;
    }

    private boolean loadFactionsHook() {
        String version;
        Plugin factions = this.getServer().getPluginManager().getPlugin("Factions");
        if (factions == null) {
            factions = this.getServer().getPluginManager().getPlugin("LegacyFactions");
            if (factions == null) {
                return false;
            }
            this.factionsHook = new LegacyFactions0103((Plugin)this);
            return true;
        }
        String[] components = factions.getDescription().getVersion().split("\\.");
        switch (version = components.length < 2 ? "" : components[0] + "." + components[1]) {
            case "1.6": {
                this.factionsHook = new Factions0106((Plugin)this);
                return true;
            }
            case "1.8": {
                this.factionsHook = new Factions0108((Plugin)this);
                return true;
            }
            case "2.7": 
            case "2.8": 
            case "2.9": 
            case "2.10": {
                this.factionsHook = new Factions0207((Plugin)this);
                return true;
            }
            case "2.11": {
                this.factionsHook = new Factions0211((Plugin)this);
                return true;
            }
        }
        this.factionsHook = new Factions0212((Plugin)this);
        return true;
    }

    private void loadPlaceholderHook() {
        Plugin clipPlaceholderApi;
        this.placeholderHooks = new HashSet<PlaceholderHook>();
        PlayerReplacer playerReplacer = new PlayerReplacer(this);
        RankReplacer rankReplacer = new RankReplacer(this);
        LastReplacer lastReplacer = new LastReplacer(this);
        Plugin mvdwPlaceholderApi = this.getServer().getPluginManager().getPlugin("MVdWPlaceholderAPI");
        if (mvdwPlaceholderApi != null && mvdwPlaceholderApi.isEnabled()) {
            MVdWPlaceholderAPIHook placeholderHook = new MVdWPlaceholderAPIHook((Plugin)this, playerReplacer, rankReplacer, lastReplacer);
            boolean updated = placeholderHook.initialize(this.getSettings().getPlaceholdersEnabledRanks());
            this.placeholderHooks.add(placeholderHook);
            if (updated) {
                this.getLogger().info("MVdWPlaceholderAPI found, added placeholders.");
            }
        }
        if ((clipPlaceholderApi = this.getServer().getPluginManager().getPlugin("PlaceholderAPI")) != null && clipPlaceholderApi.isEnabled()) {
            ClipPlaceholderAPIHook placeholderHook = new ClipPlaceholderAPIHook((Plugin)this, playerReplacer, rankReplacer, lastReplacer);
            boolean updated = placeholderHook.initialize(this.getSettings().getPlaceholdersEnabledRanks());
            this.placeholderHooks.add(placeholderHook);
            if (updated) {
                this.getLogger().info("PlaceholderAPI found, added placeholders.");
            }
        }
    }

    public void loadSettings() {
        this.guiManager.closeInventories();
        try {
            this.settings.load();
            if (!this.active) {
                this.services.forEach(PluginService::initialize);
            }
            this.active = true;
            this.loadPlaceholderHook();
            return;
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().severe("Unable to load settings from config.yml");
            this.getLogger().severe("The configuration you have provided has invalid syntax.");
            this.getLogger().severe("Please correct your errors, then loadSettings the plugin.");
            this.getLogger().log(Level.SEVERE, "The errors are as follows:", e);
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load settings from config.yml");
            this.getLogger().severe("An I/O exception has occurred.");
            this.getLogger().log(Level.SEVERE, "The errors are as follows:", e);
        }
        this.services.forEach(PluginService::terminate);
        this.active = false;
    }
}

