/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tab;

import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemRemove;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import net.md_5.bungee.tab.TabList;

public class ServerUnique
extends TabList {
    private final Collection<UUID> uuids = new HashSet<UUID>();

    public ServerUnique(ProxiedPlayer player) {
        super(player);
    }

    @Override
    public void onUpdate(PlayerListItem playerListItem) {
        for (PlayerListItem.Item item : playerListItem.getItems()) {
            if (playerListItem.getAction() == PlayerListItem.Action.ADD_PLAYER) {
                this.uuids.add(item.getUuid());
                continue;
            }
            if (playerListItem.getAction() != PlayerListItem.Action.REMOVE_PLAYER) continue;
            this.uuids.remove(item.getUuid());
        }
        this.player.unsafe().sendPacket((DefinedPacket)playerListItem);
    }

    @Override
    public void onUpdate(PlayerListItemRemove playerListItem) {
        for (UUID uuid : playerListItem.getUuids()) {
            this.uuids.remove(uuid);
        }
        this.player.unsafe().sendPacket((DefinedPacket)playerListItem);
    }

    @Override
    public void onUpdate(PlayerListItemUpdate playerListItem) {
        for (PlayerListItem.Item item : playerListItem.getItems()) {
            for (PlayerListItemUpdate.Action action : playerListItem.getActions()) {
                if (action != PlayerListItemUpdate.Action.ADD_PLAYER) continue;
                this.uuids.add(item.getUuid());
            }
        }
        this.player.unsafe().sendPacket((DefinedPacket)playerListItem);
    }

    @Override
    public void onPingChange(int ping) {
    }

    @Override
    public void onServerChange() {
        if (this.player.getPendingConnection().getVersion() >= 761) {
            PlayerListItemRemove packet = new PlayerListItemRemove();
            packet.setUuids((UUID[])this.uuids.stream().toArray(UUID[]::new));
            this.player.unsafe().sendPacket((DefinedPacket)packet);
        } else {
            PlayerListItem packet = new PlayerListItem();
            packet.setAction(PlayerListItem.Action.REMOVE_PLAYER);
            PlayerListItem.Item[] items = new PlayerListItem.Item[this.uuids.size()];
            int i = 0;
            for (UUID uuid : this.uuids) {
                int n = i++;
                PlayerListItem.Item item = new PlayerListItem.Item();
                items[n] = item;
                PlayerListItem.Item item2 = item;
                item2.setUuid(uuid);
            }
            packet.setItems(items);
            this.player.unsafe().sendPacket((DefinedPacket)packet);
        }
        this.uuids.clear();
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void onDisconnect() {
    }
}

