/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.http;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.http.HttpInitializer;
import net.md_5.bungee.netty.PipelineUtils;

public class HttpClient {
    public static final int TIMEOUT = 5000;
    private static final Cache<String, InetAddress> addressCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public static void get(String url, EventLoop eventLoop, final Callback<String> callback) {
        InetAddress inetHost;
        Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkNotNull((Object)eventLoop, (Object)"eventLoop");
        Preconditions.checkNotNull(callback, (Object)"callBack");
        final URI uri = URI.create(url);
        Preconditions.checkNotNull((Object)uri.getScheme(), (Object)"scheme");
        Preconditions.checkNotNull((Object)uri.getHost(), (Object)"host");
        boolean ssl = uri.getScheme().equals("https");
        int port = uri.getPort();
        if (port == -1) {
            switch (uri.getScheme()) {
                case "http": {
                    port = 80;
                    break;
                }
                case "https": {
                    port = 443;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown scheme " + uri.getScheme());
                }
            }
        }
        if ((inetHost = (InetAddress)addressCache.getIfPresent((Object)uri.getHost())) == null) {
            try {
                inetHost = InetAddress.getByName(uri.getHost());
            }
            catch (UnknownHostException ex) {
                callback.done(null, (Throwable)ex);
                return;
            }
            addressCache.put((Object)uri.getHost(), (Object)inetHost);
        }
        ChannelFutureListener future = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    String path = uri.getRawPath() + (uri.getRawQuery() == null ? "" : "?" + uri.getRawQuery());
                    DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
                    request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
                    future.channel().writeAndFlush((Object)request);
                } else {
                    addressCache.invalidate((Object)uri.getHost());
                    callback.done(null, future.cause());
                }
            }
        };
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel(null))).group((EventLoopGroup)eventLoop)).handler((ChannelHandler)new HttpInitializer(callback, ssl, uri.getHost(), port))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).remoteAddress(inetHost, port).connect().addListener((GenericFutureListener)future);
    }

    private HttpClient() {
    }
}

