/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.entitymap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

class EntityMap_1_13
extends EntityMap {
    static final EntityMap_1_13 INSTANCE = new EntityMap_1_13();

    EntityMap_1_13() {
        this.addRewrite(0, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(1, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(3, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(4, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(5, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(6, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(8, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(28, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(39, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(40, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(41, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(42, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(51, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(54, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(57, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(60, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(63, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(64, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(65, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(66, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(70, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(79, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(80, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(82, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(83, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(13, ProtocolConstants.Direction.TO_SERVER, true);
        this.addRewrite(25, ProtocolConstants.Direction.TO_SERVER, true);
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public void rewriteClientbound(ByteBuf packet, int oldId, int newId, int protocolVersion) {
        super.rewriteClientbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt((ByteBuf)packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        int jumpIndex = packet.readerIndex();
        switch (packetId) {
            case 64: {
                EntityMap_1_13.rewriteInt(packet, oldId, newId, readerIndex + packetIdLength + 4);
                break;
            }
            case 79: {
                DefinedPacket.readVarInt((ByteBuf)packet);
                EntityMap_1_13.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
                break;
            }
            case 70: {
                DefinedPacket.readVarInt((ByteBuf)packet);
                jumpIndex = packet.readerIndex();
            }
            case 53: {
                int count = DefinedPacket.readVarInt((ByteBuf)packet);
                int[] ids = new int[count];
                for (int i = 0; i < count; ++i) {
                    ids[i] = DefinedPacket.readVarInt((ByteBuf)packet);
                }
                packet.readerIndex(jumpIndex);
                packet.writerIndex(jumpIndex);
                DefinedPacket.writeVarInt((int)count, (ByteBuf)packet);
                for (int id : ids) {
                    if (id == oldId) {
                        id = newId;
                    } else if (id == newId) {
                        id = oldId;
                    }
                    DefinedPacket.writeVarInt((int)id, (ByteBuf)packet);
                }
                break;
            }
            case 0: {
                DefinedPacket.readVarInt((ByteBuf)packet);
                DefinedPacket.readUUID((ByteBuf)packet);
                short type = packet.readUnsignedByte();
                if (type != 60 && type != 90 && type != 91) break;
                if (type == 60 || type == 91) {
                    ++oldId;
                    ++newId;
                }
                packet.skipBytes(26);
                int position = packet.readerIndex();
                int readId = packet.readInt();
                if (readId == oldId) {
                    packet.setInt(position, newId);
                    break;
                }
                if (readId != newId) break;
                packet.setInt(position, oldId);
                break;
            }
            case 5: {
                DefinedPacket.readVarInt((ByteBuf)packet);
                int idLength = packet.readerIndex() - readerIndex - packetIdLength;
                UUID uuid = DefinedPacket.readUUID((ByteBuf)packet);
                UserConnection player = BungeeCord.getInstance().getPlayerByOfflineUUID(uuid);
                if (player == null) break;
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength + idLength);
                DefinedPacket.writeUUID((UUID)player.getRewriteId(), (ByteBuf)packet);
                packet.writerIndex(previous);
                break;
            }
            case 47: {
                short event = packet.readUnsignedByte();
                if (event == 1) {
                    DefinedPacket.readVarInt((ByteBuf)packet);
                    EntityMap_1_13.rewriteInt(packet, oldId, newId, packet.readerIndex());
                    break;
                }
                if (event != 2) break;
                int position = packet.readerIndex();
                EntityMap_1_13.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
                packet.readerIndex(position);
                DefinedPacket.readVarInt((ByteBuf)packet);
                EntityMap_1_13.rewriteInt(packet, oldId, newId, packet.readerIndex());
                break;
            }
            case 63: {
                DefinedPacket.readVarInt((ByteBuf)packet);
                EntityMap_1_13.rewriteMetaVarInt(packet, oldId + 1, newId + 1, 6, protocolVersion);
                EntityMap_1_13.rewriteMetaVarInt(packet, oldId, newId, 7, protocolVersion);
                EntityMap_1_13.rewriteMetaVarInt(packet, oldId, newId, 13, protocolVersion);
            }
        }
        packet.readerIndex(readerIndex);
    }

    @Override
    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        super.rewriteServerbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt((ByteBuf)packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == 40) {
            UUID uuid = DefinedPacket.readUUID((ByteBuf)packet);
            ProxiedPlayer player = BungeeCord.getInstance().getPlayer(uuid);
            if (player != null) {
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength);
                DefinedPacket.writeUUID((UUID)((UserConnection)player).getRewriteId(), (ByteBuf)packet);
                packet.writerIndex(previous);
            }
        }
        packet.readerIndex(readerIndex);
    }
}

