/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import io.netty.channel.ChannelHandler;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerHandshakeEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.http.HttpClient;
import net.md_5.bungee.jni.cipher.BungeeCipher;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.cipher.CipherDecoder;
import net.md_5.bungee.netty.cipher.CipherEncoder;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.CookieRequest;
import net.md_5.bungee.protocol.packet.CookieResponse;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.LegacyHandshake;
import net.md_5.bungee.protocol.packet.LegacyPing;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.util.AllowedCharacters;
import net.md_5.bungee.util.BufUtil;
import net.md_5.bungee.util.QuietException;

public class InitialHandler
extends PacketHandler
implements PendingConnection {
    private final BungeeCord bungee;
    private ChannelWrapper ch;
    private final ListenerInfo listener;
    private Handshake handshake;
    private LoginRequest loginRequest;
    private EncryptionRequest request;
    private PluginMessage brandMessage;
    private final Set<String> registeredChannels = new HashSet<String>();
    private State thisState = State.HANDSHAKE;
    private final Queue<CookieFuture> requestedCookies = new LinkedList<CookieFuture>();
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        public void sendPacket(DefinedPacket packet) {
            InitialHandler.this.ch.write(packet);
        }
    };
    private boolean onlineMode;
    private InetSocketAddress virtualHost;
    private String name;
    private UUID uniqueId;
    private UUID offlineId;
    private UUID rewriteId;
    private LoginResult loginProfile;
    private boolean legacy;
    private String extraDataInHandshake;
    private boolean transferred;
    private UserConnection userCon;

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return !this.ch.isClosing();
    }

    private boolean canSendKickMessage() {
        return this.thisState == State.USERNAME || this.thisState == State.ENCRYPT || this.thisState == State.FINISHING;
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
    }

    @Override
    public void exception(Throwable t) throws Exception {
        if (this.canSendKickMessage()) {
            this.disconnect(ChatColor.RED + Util.exception((Throwable)t));
        } else {
            this.ch.close();
        }
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        if (packet.packet == null) {
            throw new QuietException("Unexpected packet received during login process! " + BufUtil.dump(packet.buf, 16));
        }
    }

    public void handle(PluginMessage pluginMessage) throws Exception {
        this.relayMessage(pluginMessage);
    }

    public void handle(LegacyHandshake legacyHandshake) throws Exception {
        this.legacy = true;
        this.ch.close(this.bungee.getTranslation("outdated_client", this.bungee.getGameVersion()));
    }

    public void handle(LegacyPing ping) throws Exception {
        this.legacy = true;
        final boolean v1_5 = ping.isV1_5();
        ServerInfo forced = AbstractReconnectHandler.getForcedHost((PendingConnection)this);
        String motd = forced != null ? forced.getMotd() : this.listener.getMotd();
        final int protocol = this.bungee.getProtocolVersion();
        Callback<ServerPing> pingBack = new Callback<ServerPing>(){

            public void done(ServerPing result, Throwable error) {
                if (error != null) {
                    result = InitialHandler.this.getPingInfo(InitialHandler.this.bungee.getTranslation("ping_cannot_connect", new Object[0]), protocol);
                    InitialHandler.this.bungee.getLogger().log(Level.WARNING, "Error pinging remote server", error);
                }
                Callback<ProxyPingEvent> callback = new Callback<ProxyPingEvent>(){

                    public void done(ProxyPingEvent result, Throwable error) {
                        if (InitialHandler.this.ch.isClosing()) {
                            return;
                        }
                        ServerPing legacy = result.getResponse();
                        String kickMessage = v1_5 ? ChatColor.DARK_BLUE + "\u0000" + 127 + '\u0000' + legacy.getVersion().getName() + '\u0000' + InitialHandler.getFirstLine(legacy.getDescription()) + '\u0000' + (legacy.getPlayers() != null ? Integer.valueOf(legacy.getPlayers().getOnline()) : "-1") + '\u0000' + (legacy.getPlayers() != null ? Integer.valueOf(legacy.getPlayers().getMax()) : "-1") : ChatColor.stripColor((String)InitialHandler.getFirstLine(legacy.getDescription())) + '\u00a7' + (legacy.getPlayers() != null ? Integer.valueOf(legacy.getPlayers().getOnline()) : "-1") + '\u00a7' + (legacy.getPlayers() != null ? Integer.valueOf(legacy.getPlayers().getMax()) : "-1");
                        InitialHandler.this.ch.close(kickMessage);
                    }
                };
                InitialHandler.this.bungee.getPluginManager().callEvent((Event)new ProxyPingEvent((PendingConnection)InitialHandler.this, result, (Callback)callback));
            }
        };
        if (forced != null && this.listener.isPingPassthrough()) {
            ((BungeeServerInfo)forced).ping(pingBack, this.bungee.getProtocolVersion());
        } else {
            pingBack.done((Object)this.getPingInfo(motd, protocol), null);
        }
    }

    private static String getFirstLine(String str) {
        int pos = str.indexOf(10);
        return pos == -1 ? str : str.substring(0, pos);
    }

    private ServerPing getPingInfo(String motd, int protocol) {
        return new ServerPing(new ServerPing.Protocol(this.bungee.getName() + " " + this.bungee.getGameVersion(), protocol), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.getOnlineCount(), null), motd, BungeeCord.getInstance().config.getFaviconObject());
    }

    public void handle(StatusRequest statusRequest) throws Exception {
        Preconditions.checkState((this.thisState == State.STATUS ? 1 : 0) != 0, (Object)"Not expecting STATUS");
        ServerInfo forced = AbstractReconnectHandler.getForcedHost((PendingConnection)this);
        String motd = forced != null ? forced.getMotd() : this.listener.getMotd();
        final int protocol = ProtocolConstants.SUPPORTED_VERSION_IDS.contains(this.handshake.getProtocolVersion()) ? this.handshake.getProtocolVersion() : this.bungee.getProtocolVersion();
        Callback<ServerPing> pingBack = new Callback<ServerPing>(){

            public void done(ServerPing result, Throwable error) {
                if (error != null) {
                    result = InitialHandler.this.getPingInfo(InitialHandler.this.bungee.getTranslation("ping_cannot_connect", new Object[0]), protocol);
                    InitialHandler.this.bungee.getLogger().log(Level.WARNING, "Error pinging remote server", error);
                }
                Callback<ProxyPingEvent> callback = new Callback<ProxyPingEvent>(){

                    public void done(ProxyPingEvent pingResult, Throwable error) {
                        Gson gson = BungeeCord.getInstance().gson;
                        InitialHandler.this.unsafe.sendPacket((DefinedPacket)new StatusResponse(gson.toJson((Object)pingResult.getResponse())));
                        if (InitialHandler.this.bungee.getConnectionThrottle() != null) {
                            InitialHandler.this.bungee.getConnectionThrottle().unthrottle(InitialHandler.this.getSocketAddress());
                        }
                    }
                };
                InitialHandler.this.bungee.getPluginManager().callEvent((Event)new ProxyPingEvent((PendingConnection)InitialHandler.this, result, (Callback)callback));
            }
        };
        if (forced != null && this.listener.isPingPassthrough()) {
            ((BungeeServerInfo)forced).ping(pingBack, this.handshake.getProtocolVersion());
        } else {
            pingBack.done((Object)this.getPingInfo(motd, protocol), null);
        }
        this.thisState = State.PING;
    }

    public void handle(PingPacket ping) throws Exception {
        Preconditions.checkState((this.thisState == State.PING ? 1 : 0) != 0, (Object)"Not expecting PING");
        this.unsafe.sendPacket((DefinedPacket)ping);
        this.disconnect("");
    }

    public void handle(Handshake handshake) throws Exception {
        Preconditions.checkState((this.thisState == State.HANDSHAKE ? 1 : 0) != 0, (Object)"Not expecting HANDSHAKE");
        this.handshake = handshake;
        this.ch.setVersion(handshake.getProtocolVersion());
        this.ch.getHandle().pipeline().remove("legacy-kick");
        if (handshake.getHost().contains("\u0000")) {
            String[] split = handshake.getHost().split("\u0000", 2);
            handshake.setHost(split[0]);
            this.extraDataInHandshake = "\u0000" + split[1];
        }
        if (handshake.getHost().endsWith(".")) {
            handshake.setHost(handshake.getHost().substring(0, handshake.getHost().length() - 1));
        }
        this.virtualHost = InetSocketAddress.createUnresolved(handshake.getHost(), handshake.getPort());
        this.bungee.getPluginManager().callEvent((Event)new PlayerHandshakeEvent((PendingConnection)this, handshake));
        if (this.ch.isClosing()) {
            return;
        }
        switch (handshake.getRequestedProtocol()) {
            case 1: {
                if (this.bungee.getConfig().isLogPings()) {
                    this.bungee.getLogger().log(Level.INFO, "{0} has pinged", (Object)this);
                }
                this.thisState = State.STATUS;
                this.ch.setProtocol(Protocol.STATUS);
                break;
            }
            case 2: 
            case 3: {
                this.transferred = handshake.getRequestedProtocol() == 3;
                this.bungee.getLogger().log(Level.INFO, "{0} has connected", (Object)this);
                this.thisState = State.USERNAME;
                this.ch.setProtocol(Protocol.LOGIN);
                if (!ProtocolConstants.SUPPORTED_VERSION_IDS.contains(handshake.getProtocolVersion())) {
                    if (handshake.getProtocolVersion() > this.bungee.getProtocolVersion()) {
                        this.disconnect(this.bungee.getTranslation("outdated_server", this.bungee.getGameVersion()));
                    } else {
                        this.disconnect(this.bungee.getTranslation("outdated_client", this.bungee.getGameVersion()));
                    }
                    return;
                }
                if (!this.transferred || !this.bungee.config.isRejectTransfers()) break;
                this.disconnect(this.bungee.getTranslation("reject_transfer", new Object[0]));
                return;
            }
            default: {
                throw new QuietException("Cannot request protocol " + handshake.getRequestedProtocol());
            }
        }
    }

    public void handle(LoginRequest loginRequest) throws Exception {
        Preconditions.checkState((this.thisState == State.USERNAME ? 1 : 0) != 0, (Object)"Not expecting USERNAME");
        if (!AllowedCharacters.isValidName(loginRequest.getData(), this.onlineMode)) {
            this.disconnect(this.bungee.getTranslation("name_invalid", new Object[0]));
            return;
        }
        if (BungeeCord.getInstance().config.isEnforceSecureProfile() && this.getVersion() < 761) {
            PlayerPublicKey publicKey = loginRequest.getPublicKey();
            if (publicKey == null) {
                this.disconnect(this.bungee.getTranslation("secure_profile_required", new Object[0]));
                return;
            }
            if (Instant.ofEpochMilli(publicKey.getExpiry()).isBefore(Instant.now())) {
                this.disconnect(this.bungee.getTranslation("secure_profile_expired", new Object[0]));
                return;
            }
            if (this.getVersion() < 760 && !EncryptionUtil.check(publicKey, null)) {
                this.disconnect(this.bungee.getTranslation("secure_profile_invalid", new Object[0]));
                return;
            }
        }
        this.loginRequest = loginRequest;
        int limit = BungeeCord.getInstance().config.getPlayerLimit();
        if (limit > 0 && this.bungee.getOnlineCount() >= limit) {
            this.disconnect(this.bungee.getTranslation("proxy_full", new Object[0]));
            return;
        }
        if (!this.isOnlineMode() && this.bungee.getPlayer(this.getUniqueId()) != null) {
            this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            return;
        }
        Callback<PreLoginEvent> callback = new Callback<PreLoginEvent>(){

            public void done(PreLoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    BaseComponent reason = result.getReason();
                    InitialHandler.this.disconnect(reason != null ? reason : TextComponent.fromLegacy((String)InitialHandler.this.bungee.getTranslation("kick_message", new Object[0])));
                    return;
                }
                if (InitialHandler.this.ch.isClosing()) {
                    return;
                }
                if (InitialHandler.this.onlineMode) {
                    InitialHandler.this.thisState = State.ENCRYPT;
                    InitialHandler.this.unsafe().sendPacket((DefinedPacket)(InitialHandler.this.request = EncryptionUtil.encryptRequest()));
                } else {
                    InitialHandler.this.thisState = State.FINISHING;
                    InitialHandler.this.finish();
                }
            }
        };
        this.bungee.getPluginManager().callEvent((Event)new PreLoginEvent((PendingConnection)this, (Callback)callback));
    }

    public void handle(EncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState((this.thisState == State.ENCRYPT ? 1 : 0) != 0, (Object)"Not expecting ENCRYPT");
        Preconditions.checkState((boolean)EncryptionUtil.check(this.loginRequest.getPublicKey(), encryptResponse, this.request), (Object)"Invalid verification");
        SecretKey sharedKey = EncryptionUtil.getSecret(encryptResponse, this.request);
        BungeeCipher decrypt = EncryptionUtil.getCipher(false, sharedKey);
        this.ch.addBefore("frame-decoder", "decrypt", (ChannelHandler)new CipherDecoder(decrypt));
        BungeeCipher encrypt = EncryptionUtil.getCipher(true, sharedKey);
        this.ch.addBefore("frame-prepender", "encrypt", (ChannelHandler)new CipherEncoder(encrypt));
        String encName = URLEncoder.encode(this.getName(), "UTF-8");
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        for (byte[] bit : new byte[][]{this.request.getServerId().getBytes("ISO_8859_1"), sharedKey.getEncoded(), EncryptionUtil.keys.getPublic().getEncoded()}) {
            sha.update(bit);
        }
        String encodedHash = URLEncoder.encode(new BigInteger(sha.digest()).toString(16), "UTF-8");
        String preventProxy = BungeeCord.getInstance().config.isPreventProxyConnections() && this.getSocketAddress() instanceof InetSocketAddress ? "&ip=" + URLEncoder.encode(this.getAddress().getAddress().getHostAddress(), "UTF-8") : "";
        String authURL = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=" + encName + "&serverId=" + encodedHash + preventProxy;
        Callback<String> handler = new Callback<String>(){

            public void done(String result, Throwable error) {
                if (error == null) {
                    LoginResult obj = (LoginResult)BungeeCord.getInstance().gson.fromJson(result, LoginResult.class);
                    if (obj != null && obj.getId() != null) {
                        InitialHandler.this.loginProfile = obj;
                        InitialHandler.this.name = obj.getName();
                        InitialHandler.this.uniqueId = Util.getUUID((String)obj.getId());
                        InitialHandler.this.finish();
                        return;
                    }
                    InitialHandler.this.disconnect(InitialHandler.this.bungee.getTranslation("offline_mode_player", new Object[0]));
                } else {
                    InitialHandler.this.disconnect(InitialHandler.this.bungee.getTranslation("mojang_fail", new Object[0]));
                    InitialHandler.this.bungee.getLogger().log(Level.SEVERE, "Error authenticating " + InitialHandler.this.getName() + " with minecraft.net", error);
                }
            }
        };
        this.thisState = State.FINISHING;
        HttpClient.get(authURL, this.ch.getHandle().eventLoop(), handler);
    }

    private void finish() {
        ProxiedPlayer oldName;
        this.offlineId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(StandardCharsets.UTF_8));
        if (this.uniqueId == null) {
            this.uniqueId = this.offlineId;
        }
        UUID uUID = this.rewriteId = this.bungee.config.isIpForward() ? this.uniqueId : this.offlineId;
        if (BungeeCord.getInstance().config.isEnforceSecureProfile() && this.getVersion() >= 760 && this.getVersion() < 761) {
            boolean secure = false;
            try {
                secure = EncryptionUtil.check(this.loginRequest.getPublicKey(), this.uniqueId);
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (!secure) {
                this.disconnect(this.bungee.getTranslation("secure_profile_invalid", new Object[0]));
                return;
            }
        }
        if (this.isOnlineMode()) {
            ProxiedPlayer oldID;
            oldName = this.bungee.getPlayer(this.getName());
            if (oldName != null) {
                this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            }
            if ((oldID = this.bungee.getPlayer(this.getUniqueId())) != null) {
                this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            }
        } else {
            oldName = this.bungee.getPlayer(this.getName());
            if (oldName != null) {
                this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
                return;
            }
        }
        Callback<LoginEvent> complete = new Callback<LoginEvent>(){

            public void done(LoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    BaseComponent reason = result.getReason();
                    InitialHandler.this.disconnect(reason != null ? reason : TextComponent.fromLegacy((String)InitialHandler.this.bungee.getTranslation("kick_message", new Object[0])));
                    return;
                }
                if (InitialHandler.this.ch.isClosing()) {
                    return;
                }
                InitialHandler.this.ch.getHandle().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!InitialHandler.this.ch.isClosing()) {
                            InitialHandler.this.userCon = new UserConnection(InitialHandler.this.bungee, InitialHandler.this.ch, InitialHandler.this.getName(), InitialHandler.this);
                            InitialHandler.this.userCon.setCompressionThreshold(BungeeCord.getInstance().config.getCompressionThreshold());
                            if (InitialHandler.this.getVersion() < 764) {
                                InitialHandler.this.unsafe.sendPacket((DefinedPacket)new LoginSuccess(InitialHandler.this.getRewriteId(), InitialHandler.this.getName(), InitialHandler.this.loginProfile == null ? null : InitialHandler.this.loginProfile.getProperties()));
                                InitialHandler.this.ch.setProtocol(Protocol.GAME);
                            }
                            InitialHandler.this.finish2();
                        }
                    }
                });
            }
        };
        this.bungee.getPluginManager().callEvent((Event)new LoginEvent((PendingConnection)this, (Callback)complete));
    }

    private void finish2() {
        if (!this.userCon.init()) {
            this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            return;
        }
        ((HandlerBoss)this.ch.getHandle().pipeline().get(HandlerBoss.class)).setHandler(new UpstreamBridge(this.bungee, this.userCon));
        ServerInfo initialServer = this.bungee.getReconnectHandler() != null ? this.bungee.getReconnectHandler().getServer((ProxiedPlayer)this.userCon) : AbstractReconnectHandler.getForcedHost((PendingConnection)this);
        if (initialServer == null) {
            initialServer = this.bungee.getServerInfo(this.listener.getDefaultServer());
        }
        Callback<PostLoginEvent> complete = new Callback<PostLoginEvent>(){

            public void done(PostLoginEvent result, Throwable error) {
                if (InitialHandler.this.ch.isClosing()) {
                    return;
                }
                InitialHandler.this.userCon.connect(result.getTarget(), null, true, ServerConnectEvent.Reason.JOIN_PROXY);
            }
        };
        this.bungee.getPluginManager().callEvent((Event)new PostLoginEvent((ProxiedPlayer)this.userCon, initialServer, (Callback)complete));
    }

    public void handle(LoginPayloadResponse response) throws Exception {
        this.disconnect("Unexpected custom LoginPayloadResponse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(CookieResponse cookieResponse) {
        CookieFuture future;
        Queue<CookieFuture> queue = this.requestedCookies;
        synchronized (queue) {
            future = this.requestedCookies.peek();
            if (future != null) {
                if (future.cookie.equals(cookieResponse.getCookie())) {
                    Preconditions.checkState((future == this.requestedCookies.poll() ? 1 : 0) != 0, (Object)"requestedCookies queue mismatch");
                } else {
                    future = null;
                }
            }
        }
        if (future != null) {
            future.getFuture().complete(cookieResponse.getData());
            throw CancelSendSignal.INSTANCE;
        }
    }

    public void disconnect(String reason) {
        if (this.canSendKickMessage()) {
            this.disconnect(TextComponent.fromLegacy((String)reason));
        } else {
            this.ch.close();
        }
    }

    public void disconnect(BaseComponent ... reason) {
        this.disconnect(TextComponent.fromArray((BaseComponent[])reason));
    }

    public void disconnect(BaseComponent reason) {
        if (this.canSendKickMessage()) {
            this.ch.delayedClose(new Kick(reason));
        } else {
            this.ch.close();
        }
    }

    public String getName() {
        return this.name != null ? this.name : (this.loginRequest == null ? null : this.loginRequest.getData());
    }

    public int getVersion() {
        return this.handshake == null ? -1 : this.handshake.getProtocolVersion();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.getSocketAddress();
    }

    public SocketAddress getSocketAddress() {
        return this.ch.getRemoteAddress();
    }

    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    public void setOnlineMode(boolean onlineMode) {
        Preconditions.checkState((this.thisState == State.USERNAME ? 1 : 0) != 0, (Object)"Can only set online mode status whilst state is username");
        this.onlineMode = onlineMode;
    }

    public void setUniqueId(UUID uuid) {
        Preconditions.checkState((this.thisState == State.USERNAME ? 1 : 0) != 0, (Object)"Can only set uuid while state is username");
        Preconditions.checkState((!this.onlineMode ? 1 : 0) != 0, (Object)"Can only set uuid when online mode is false");
        this.uniqueId = uuid;
    }

    public String getUUID() {
        return this.uniqueId.toString().replace("-", "");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        String currentName = this.getName();
        if (currentName != null) {
            sb.append(currentName);
            sb.append(',');
        }
        sb.append(this.getSocketAddress());
        sb.append("] <-> InitialHandler");
        return sb.toString();
    }

    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    public void relayMessage(PluginMessage input) throws Exception {
        if (input.getTag().equals("REGISTER") || input.getTag().equals("minecraft:register")) {
            String content = new String(input.getData(), StandardCharsets.UTF_8);
            for (String id : content.split("\u0000")) {
                Preconditions.checkState((this.registeredChannels.size() < 128 ? 1 : 0) != 0, (Object)"Too many registered channels");
                Preconditions.checkArgument((id.length() < 128 ? 1 : 0) != 0, (Object)"Channel name too long");
                this.registeredChannels.add(id);
            }
        } else if (input.getTag().equals("UNREGISTER") || input.getTag().equals("minecraft:unregister")) {
            String content = new String(input.getData(), StandardCharsets.UTF_8);
            for (String id : content.split("\u0000")) {
                this.registeredChannels.remove(id);
            }
        } else if (input.getTag().equals("MC|Brand") || input.getTag().equals("minecraft:brand")) {
            this.brandMessage = input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<byte[]> retrieveCookie(String cookie) {
        Preconditions.checkState((this.getVersion() >= 766 ? 1 : 0) != 0, (Object)"Cookies are only supported in 1.20.5 and above");
        Preconditions.checkState((this.loginRequest != null ? 1 : 0) != 0, (Object)"Cannot retrieve cookies for status or legacy connections");
        if (cookie.indexOf(58) == -1) {
            cookie = "minecraft:" + cookie;
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        Queue<CookieFuture> queue = this.requestedCookies;
        synchronized (queue) {
            this.requestedCookies.add(new CookieFuture(cookie, future));
        }
        this.unsafe.sendPacket((DefinedPacket)new CookieRequest(cookie));
        return future;
    }

    public InitialHandler(BungeeCord bungee, ListenerInfo listener) {
        this.onlineMode = BungeeCord.getInstance().config.isOnlineMode();
        this.extraDataInHandshake = "";
        this.bungee = bungee;
        this.listener = listener;
    }

    public ListenerInfo getListener() {
        return this.listener;
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public LoginRequest getLoginRequest() {
        return this.loginRequest;
    }

    public PluginMessage getBrandMessage() {
        return this.brandMessage;
    }

    public Set<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public InetSocketAddress getVirtualHost() {
        return this.virtualHost;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public UUID getOfflineId() {
        return this.offlineId;
    }

    public UUID getRewriteId() {
        return this.rewriteId;
    }

    public LoginResult getLoginProfile() {
        return this.loginProfile;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public String getExtraDataInHandshake() {
        return this.extraDataInHandshake;
    }

    public boolean isTransferred() {
        return this.transferred;
    }

    private static enum State {
        HANDSHAKE,
        STATUS,
        PING,
        USERNAME,
        ENCRYPT,
        FINISHING;

    }

    public static class CookieFuture {
        private String cookie;
        private CompletableFuture<byte[]> future;

        public String getCookie() {
            return this.cookie;
        }

        public CompletableFuture<byte[]> getFuture() {
            return this.future;
        }

        public void setCookie(String cookie) {
            this.cookie = cookie;
        }

        public void setFuture(CompletableFuture<byte[]> future) {
            this.future = future;
        }

        public String toString() {
            return "InitialHandler.CookieFuture(cookie=" + this.getCookie() + ", future=" + this.getFuture() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CookieFuture)) {
                return false;
            }
            CookieFuture other = (CookieFuture)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cookie = this.getCookie();
            String other$cookie = other.getCookie();
            if (this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie)) {
                return false;
            }
            CompletableFuture<byte[]> this$future = this.getFuture();
            CompletableFuture<byte[]> other$future = other.getFuture();
            return !(this$future == null ? other$future != null : !this$future.equals(other$future));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CookieFuture;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cookie = this.getCookie();
            result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
            CompletableFuture<byte[]> $future = this.getFuture();
            result = result * 59 + ($future == null ? 43 : $future.hashCode());
            return result;
        }

        public CookieFuture(String cookie, CompletableFuture<byte[]> future) {
            this.cookie = cookie;
            this.future = future;
        }
    }
}

