/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.EnumSet;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.PlayerPublicKey;
import net.md_5.bungee.protocol.packet.PlayerListItem;

public class PlayerListItemUpdate
extends DefinedPacket {
    private EnumSet<Action> actions;
    private PlayerListItem.Item[] items;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.actions = PlayerListItemUpdate.readEnumSet(Action.class, buf);
        this.items = new PlayerListItem.Item[DefinedPacket.readVarInt(buf)];
        for (int i = 0; i < this.items.length; ++i) {
            PlayerListItem.Item item = this.items[i] = new PlayerListItem.Item();
            item.setUuid(DefinedPacket.readUUID(buf));
            for (Action action : this.actions) {
                switch (action.ordinal()) {
                    case 0: {
                        item.username = DefinedPacket.readString(buf);
                        item.properties = DefinedPacket.readProperties(buf);
                        break;
                    }
                    case 1: {
                        if (!buf.readBoolean()) break;
                        item.chatSessionId = PlayerListItemUpdate.readUUID(buf);
                        item.publicKey = new PlayerPublicKey(buf.readLong(), PlayerListItemUpdate.readArray(buf, 512), PlayerListItemUpdate.readArray(buf, 4096));
                        break;
                    }
                    case 2: {
                        item.gamemode = DefinedPacket.readVarInt(buf);
                        break;
                    }
                    case 3: {
                        item.listed = buf.readBoolean();
                        break;
                    }
                    case 4: {
                        item.ping = DefinedPacket.readVarInt(buf);
                        break;
                    }
                    case 5: {
                        if (!buf.readBoolean()) break;
                        item.displayName = DefinedPacket.readBaseComponent(buf, protocolVersion);
                        break;
                    }
                    case 6: {
                        item.listOrder = DefinedPacket.readVarInt(buf);
                        break;
                    }
                    case 7: {
                        item.showHat = buf.readBoolean();
                    }
                }
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        DefinedPacket.writeEnumSet(this.actions, Action.class, buf);
        DefinedPacket.writeVarInt(this.items.length, buf);
        for (PlayerListItem.Item item : this.items) {
            DefinedPacket.writeUUID(item.uuid, buf);
            for (Action action : this.actions) {
                switch (action.ordinal()) {
                    case 0: {
                        DefinedPacket.writeString(item.username, buf);
                        DefinedPacket.writeProperties(item.properties, buf);
                        break;
                    }
                    case 1: {
                        buf.writeBoolean(item.chatSessionId != null);
                        if (item.chatSessionId == null) break;
                        PlayerListItemUpdate.writeUUID(item.chatSessionId, buf);
                        buf.writeLong(item.publicKey.getExpiry());
                        PlayerListItemUpdate.writeArray(item.publicKey.getKey(), buf);
                        PlayerListItemUpdate.writeArray(item.publicKey.getSignature(), buf);
                        break;
                    }
                    case 2: {
                        DefinedPacket.writeVarInt(item.gamemode, buf);
                        break;
                    }
                    case 3: {
                        buf.writeBoolean(item.listed.booleanValue());
                        break;
                    }
                    case 4: {
                        DefinedPacket.writeVarInt(item.ping, buf);
                        break;
                    }
                    case 5: {
                        buf.writeBoolean(item.displayName != null);
                        if (item.displayName == null) break;
                        DefinedPacket.writeBaseComponent(item.displayName, buf, protocolVersion);
                        break;
                    }
                    case 6: {
                        DefinedPacket.writeVarInt(item.listOrder, buf);
                        break;
                    }
                    case 7: {
                        buf.writeBoolean(item.showHat.booleanValue());
                    }
                }
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public EnumSet<Action> getActions() {
        return this.actions;
    }

    @Generated
    public PlayerListItem.Item[] getItems() {
        return this.items;
    }

    @Generated
    public void setActions(EnumSet<Action> actions) {
        this.actions = actions;
    }

    @Generated
    public void setItems(PlayerListItem.Item[] items) {
        this.items = items;
    }

    @Override
    @Generated
    public String toString() {
        return "PlayerListItemUpdate(actions=" + this.getActions() + ", items=" + Arrays.deepToString(this.getItems()) + ")";
    }

    @Generated
    public PlayerListItemUpdate() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListItemUpdate)) {
            return false;
        }
        PlayerListItemUpdate other = (PlayerListItemUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnumSet<Action> this$actions = this.getActions();
        EnumSet<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        return Arrays.deepEquals(this.getItems(), other.getItems());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PlayerListItemUpdate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumSet<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        return result;
    }

    public static enum Action {
        ADD_PLAYER,
        INITIALIZE_CHAT,
        UPDATE_GAMEMODE,
        UPDATE_LISTED,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        UPDATE_LIST_ORDER,
        UPDATE_HAT;

    }
}

