/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Title
extends DefinedPacket {
    private Action action;
    private BaseComponent text;
    private int fadeIn;
    private int stay;
    private int fadeOut;

    public Title(Action action) {
        this.action = action;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 755) {
            this.text = Title.readBaseComponent(buf, protocolVersion);
            return;
        }
        int index = Title.readVarInt(buf);
        if (protocolVersion <= 210 && index >= 2) {
            ++index;
        }
        this.action = Action.values()[index];
        switch (this.action.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                this.text = Title.readBaseComponent(buf, protocolVersion);
                break;
            }
            case 3: {
                this.fadeIn = buf.readInt();
                this.stay = buf.readInt();
                this.fadeOut = buf.readInt();
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 755) {
            Title.writeBaseComponent(this.text, buf, protocolVersion);
            return;
        }
        int index = this.action.ordinal();
        if (protocolVersion <= 210 && index >= 2) {
            --index;
        }
        Title.writeVarInt(index, buf);
        switch (this.action.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                Title.writeBaseComponent(this.text, buf, protocolVersion);
                break;
            }
            case 3: {
                buf.writeInt(this.fadeIn);
                buf.writeInt(this.stay);
                buf.writeInt(this.fadeOut);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public BaseComponent getText() {
        return this.text;
    }

    @Generated
    public int getFadeIn() {
        return this.fadeIn;
    }

    @Generated
    public int getStay() {
        return this.stay;
    }

    @Generated
    public int getFadeOut() {
        return this.fadeOut;
    }

    @Generated
    public void setAction(Action action) {
        this.action = action;
    }

    @Generated
    public void setText(BaseComponent text) {
        this.text = text;
    }

    @Generated
    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    @Generated
    public void setStay(int stay) {
        this.stay = stay;
    }

    @Generated
    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    @Override
    @Generated
    public String toString() {
        return "Title(action=" + (Object)((Object)this.getAction()) + ", text=" + this.getText() + ", fadeIn=" + this.getFadeIn() + ", stay=" + this.getStay() + ", fadeOut=" + this.getFadeOut() + ")";
    }

    @Generated
    public Title() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Title)) {
            return false;
        }
        Title other = (Title)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFadeIn() != other.getFadeIn()) {
            return false;
        }
        if (this.getStay() != other.getStay()) {
            return false;
        }
        if (this.getFadeOut() != other.getFadeOut()) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        BaseComponent this$text = this.getText();
        BaseComponent other$text = other.getText();
        return !(this$text == null ? other$text != null : !((Object)this$text).equals(other$text));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Title;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFadeIn();
        result = result * 59 + this.getStay();
        result = result * 59 + this.getFadeOut();
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        BaseComponent $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        return result;
    }

    public static enum Action {
        TITLE,
        SUBTITLE,
        ACTIONBAR,
        TIMES,
        CLEAR,
        RESET;

    }
}

