/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.writer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import lombok.Generated;
import org.objectweb.asm.Type;

public class LogWriter
implements Closeable {
    private final PrintWriter out;

    public LogWriter(File file) throws FileNotFoundException {
        this.out = new PrintWriter(file);
    }

    public void addClassMap(String oldName, String newName) {
        this.writeLn(LogWriter.type(Type.getObjectType((String)oldName)) + " -> " + LogWriter.type(Type.getObjectType((String)newName)));
    }

    public void addFieldMap(String oldDesc, String oldName, String newName) {
        this.writeLn("    " + LogWriter.type(Type.getType((String)oldDesc)) + " " + oldName + " -> " + newName);
    }

    public void addMethodMap(int startLine, int endLine, String oldDesc, String oldName, String newName) {
        String lines = "";
        if (startLine != Integer.MAX_VALUE && endLine != Integer.MIN_VALUE) {
            lines = startLine + ":" + endLine + ":";
        }
        this.writeLn("    " + lines + LogWriter.method(oldDesc, oldName) + " -> " + newName);
    }

    private static String method(String desc, String name) {
        Type type = Type.getMethodType((String)desc);
        Type ret = type.getReturnType();
        Type[] args = type.getArgumentTypes();
        return LogWriter.type(ret) + " " + name + "(" + LogWriter.type(args) + ")";
    }

    private static String type(Type ... type) {
        return Joiner.on((char)',').join(Iterables.transform(Arrays.asList(type), (Function)new Function<Type, String>(){

            public String apply(Type input) {
                return LogWriter.type(input);
            }
        }));
    }

    private static String type(Type type) {
        return type.getClassName();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void writeLn(String s) {
        this.out.println(s);
    }

    @Generated
    public PrintWriter getOut() {
        return this.out;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogWriter)) {
            return false;
        }
        LogWriter other = (LogWriter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PrintWriter this$out = this.getOut();
        PrintWriter other$out = other.getOut();
        return !(this$out == null ? other$out != null : !this$out.equals(other$out));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogWriter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PrintWriter $out = this.getOut();
        result = result * 59 + ($out == null ? 43 : $out.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogWriter(out=" + this.getOut() + ")";
    }
}

