/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.base.Preconditions;
import lombok.Generated;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.UnsortedRemappingMethodAdapter;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.writer.LogWriter;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.FieldRemapper;
import org.objectweb.asm.commons.Remapper;

public class RemappingClassAdapter
extends ClassRemapper {
    protected final CustomRemapper remapper;
    protected ClassRepo repo;
    protected LogWriter logWriter;

    public RemappingClassAdapter(ClassVisitor cv, CustomRemapper remapper, ClassRepo repo) {
        super(cv, (Remapper)remapper);
        Preconditions.checkArgument((cv != null ? 1 : 0) != 0, (Object)"cv");
        this.repo = repo;
        this.remapper = remapper;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        String newName = this.remapper.mapType(name);
        this.cv.visit(version, access, newName, this.remapper.mapSignature(signature, false), this.remapper.mapType(superName), interfaces == null ? null : this.remapper.mapTypes(interfaces));
        if (this.logWriter != null) {
            this.logWriter.addClassMap(this.className, newName);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String newName = this.remapper.mapMethodName(this.className, name, desc, access);
        String newDesc = this.remapper.mapMethodDesc(desc);
        MethodVisitor mv = this.cv.visitMethod(access, newName, newDesc, this.remapper.mapSignature(signature, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return mv == null ? null : this.createMethodRemapper(mv, desc, name, newName);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String newName = this.remapper.mapFieldName(this.className, name, desc, access);
        FieldVisitor fv = this.cv.visitField(access, newName, this.remapper.mapDesc(desc), this.remapper.mapSignature(signature, true), this.remapper.mapValue(value));
        if (this.logWriter != null) {
            this.logWriter.addFieldMap(desc, name, newName);
        }
        return fv == null ? null : this.createFieldRemapper(fv);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String newName = this.remapper.mapType(name);
        this.cv.visitInnerClass(newName, outerName == null ? null : this.remapper.mapType(outerName), innerName == null ? null : newName.substring(newName.lastIndexOf(newName.contains("$") ? 36 : 47) + 1), access);
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fv) {
        return new FieldRemapper(fv, this.remapper){

            public void visitAttribute(Attribute attr) {
                if (SpecialSource.kill_lvt && attr.type.equals("LocalVariableTable")) {
                    return;
                }
                if (SpecialSource.kill_generics && attr.type.equals("LocalVariableTypeTable")) {
                    return;
                }
                super.visitAttribute(attr);
            }
        };
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor mv, final String oldDesc, final String oldName, final String newName) {
        return new UnsortedRemappingMethodAdapter(mv, this.remapper, this.repo){
            private int startLine;
            private int endLine;
            {
                super(mv, remapper, classRepo);
                this.startLine = Integer.MAX_VALUE;
                this.endLine = Integer.MIN_VALUE;
            }

            public void visitAttribute(Attribute attr) {
                if (SpecialSource.kill_lvt && attr.type.equals("LocalVariableTable")) {
                    return;
                }
                if (SpecialSource.kill_generics && attr.type.equals("LocalVariableTypeTable")) {
                    return;
                }
                super.visitAttribute(attr);
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                if (!SpecialSource.kill_lvt) {
                    super.visitLocalVariable(name, desc, signature, start, end, index);
                }
            }

            public void visitLineNumber(int line, Label start) {
                this.startLine = Math.min(this.startLine, line);
                this.endLine = Math.max(this.endLine, line);
                super.visitLineNumber(line, start);
            }

            public void visitEnd() {
                if (RemappingClassAdapter.this.logWriter != null) {
                    RemappingClassAdapter.this.logWriter.addMethodMap(this.startLine, this.endLine, oldDesc, oldName, newName);
                }
                super.visitEnd();
            }
        };
    }

    public void visitSource(String source, String debug) {
        if (!SpecialSource.kill_source) {
            super.visitSource(source, debug);
        }
    }

    public void visitAttribute(Attribute attr) {
        if (SpecialSource.kill_generics && attr.type.equals("Signature")) {
            return;
        }
        super.visitAttribute(attr);
    }

    @Generated
    public void setLogWriter(LogWriter logWriter) {
        this.logWriter = logWriter;
    }
}

