/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import net.kyori.adventure.serializer.configurate4.KeySerializer;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.text.object.SpriteObjectContents;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class ComponentTypeSerializer
implements TypeSerializer<Component> {
    static final TypeToken<List<Component>> LIST_TYPE = new TypeToken<List<Component>>(){};
    static final TypeToken<List<PlayerHeadObjectContents.ProfileProperty>> PROPERTY_LIST_TYPE = new TypeToken<List<PlayerHeadObjectContents.ProfileProperty>>(){};
    @Nullable
    private final ComponentSerializer<Component, ? extends Component, String> stringSerial;
    private final boolean preferString;

    ComponentTypeSerializer(@Nullable ComponentSerializer<Component, ? extends Component, String> stringSerial, boolean preferString) {
        this.stringSerial = stringSerial;
        this.preferString = preferString;
    }

    @NotNull
    public Component deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        return this.deserialize0(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private BuildableComponent<?, ?> deserialize0(@NotNull ConfigurationNode value) throws SerializationException {
        Style style;
        TextComponent.Builder component;
        Map children;
        if (!value.isList() && !value.isMap()) {
            String str = value.getString();
            if (str != null) {
                if (this.stringSerial == null) return Component.text((String)str);
                Component ret = this.stringSerial.deserialize((Object)str);
                if (ret instanceof BuildableComponent) return (BuildableComponent)ret;
                throw new SerializationException("Result " + ret + " is not builable");
            }
        } else {
            if (value.isList()) {
                ComponentBuilder parent = null;
                for (ConfigurationNode childElement : value.childrenList()) {
                    BuildableComponent<?, ?> child = this.deserialize0(childElement);
                    if (parent == null) {
                        parent = child.toBuilder();
                        continue;
                    }
                    parent.append(child);
                }
                if (parent != null) return parent.build();
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
            if (!value.isMap()) {
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
        }
        if ((children = value.childrenMap()).containsKey("text")) {
            component = Component.text().content(((ConfigurationNode)children.get("text")).getString());
        } else if (children.containsKey("translate")) {
            TranslatableComponent.Builder builder = Component.translatable().key(((ConfigurationNode)children.get("translate")).getString());
            if (children.containsKey("with")) {
                ConfigurationNode with = (ConfigurationNode)children.get("with");
                if (!with.isList()) {
                    throw new SerializationException("Expected with to be a list");
                }
                List args = with.getList(TranslationArgument.class);
                builder.arguments(args);
            }
            if (children.containsKey("fallback")) {
                builder.fallback(((ConfigurationNode)children.get("fallback")).getString());
            }
            component = builder;
        } else if (children.containsKey("score")) {
            ConfigurationNode score = (ConfigurationNode)children.get("score");
            ConfigurationNode name = score.node(new Object[]{"name"});
            ConfigurationNode objective = score.node(new Object[]{"objective"});
            if (name.virtual() || objective.virtual()) {
                throw new SerializationException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(name.getString()).objective(objective.getString());
            ConfigurationNode scoreValue = score.node(new Object[]{"value"});
            component = !scoreValue.virtual() ? builder.value(scoreValue.getString()) : builder;
        } else if (children.containsKey("selector")) {
            component = Component.selector().pattern(((ConfigurationNode)children.get("selector")).getString());
        } else if (children.containsKey("keybind")) {
            component = Component.keybind().keybind(((ConfigurationNode)children.get("keybind")).getString());
        } else if (children.containsKey("nbt")) {
            boolean interpret;
            String nbt = ((ConfigurationNode)children.get("nbt")).getString();
            boolean bl = interpret = children.containsKey("interpret") && ((ConfigurationNode)children.get("interpret")).getBoolean();
            if (children.containsKey("block")) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)((ConfigurationNode)children.get("block")).get(BlockNBTPosSerializer.INSTANCE.type());
                component = ComponentTypeSerializer.nbt(Component.blockNBT(), nbt, interpret).pos(pos);
            } else if (children.containsKey("entity")) {
                component = ComponentTypeSerializer.nbt(Component.entityNBT(), nbt, interpret).selector(((ConfigurationNode)children.get("entity")).getString());
            } else {
                if (!children.containsKey("storage")) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                component = ComponentTypeSerializer.nbt(Component.storageNBT(), nbt, interpret).storage((Key)((ConfigurationNode)children.get("storage")).get(KeySerializer.INSTANCE.type()));
            }
        } else if (children.containsKey("sprite")) {
            component = Component.object().contents((ObjectContents)ObjectContents.sprite((Key)(children.containsKey("atlas") ? (Key)((ConfigurationNode)children.get("atlas")).get(KeySerializer.INSTANCE.type()) : SpriteObjectContents.DEFAULT_ATLAS), (Key)((Key)((ConfigurationNode)children.get("sprite")).get(KeySerializer.INSTANCE.type()))));
        } else {
            ConfigurationNode player;
            if (!children.containsKey("player")) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            PlayerHeadObjectContents.Builder playerHeadContents = ObjectContents.playerHead();
            if (children.containsKey("hat")) {
                playerHeadContents.hat(((ConfigurationNode)children.get("hat")).getBoolean());
            }
            if ((player = (ConfigurationNode)children.get("player")).isMap()) {
                Map playerProfile = player.childrenMap();
                if (playerProfile.containsKey("name")) {
                    playerHeadContents.name(((ConfigurationNode)playerProfile.get("name")).getString());
                }
                if (playerProfile.containsKey("id")) {
                    playerHeadContents.id((UUID)((ConfigurationNode)playerProfile.get("id")).get(UUID.class));
                }
                if (playerProfile.containsKey("properties")) {
                    ConfigurationNode properties = (ConfigurationNode)playerProfile.get("properties");
                    if (properties.isList()) {
                        playerHeadContents.profileProperties((Collection)properties.get(PROPERTY_LIST_TYPE));
                    } else if (properties.isMap()) {
                        Map propertyMap = properties.childrenMap();
                        for (Map.Entry entry : propertyMap.entrySet()) {
                            for (ConfigurationNode propertyValue : ((ConfigurationNode)entry.getValue()).childrenList()) {
                                playerHeadContents.profileProperty(PlayerHeadObjectContents.property((String)entry.getKey().toString(), (String)propertyValue.getString()));
                            }
                        }
                    }
                }
                if (playerProfile.containsKey("texture")) {
                    playerHeadContents.texture((Key)((ConfigurationNode)playerProfile.get("texture")).get(KeySerializer.INSTANCE.type()));
                }
            } else {
                if (player.isList()) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                playerHeadContents.name(player.getString());
            }
            component = Component.object().contents((ObjectContents)playerHeadContents.build());
        }
        if (children.containsKey("extra")) {
            ConfigurationNode extra = (ConfigurationNode)children.get("extra");
            for (ConfigurationNode child : extra.childrenList()) {
                component.append(this.deserialize0(child));
            }
        }
        if ((style = (Style)value.get(Style.class, (Object)Style.empty())).isEmpty()) return component.build();
        component.style(style);
        return component.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(@NotNull Type type, @Nullable Component src, @NotNull ConfigurationNode value) throws SerializationException {
        value.set(null);
        if (src == null) {
            return;
        }
        if (this.stringSerial != null && this.preferString) {
            try {
                value.set(this.stringSerial.serialize(src));
                return;
            }
            catch (Exception ex) {
                throw new SerializationException((Throwable)ex);
            }
        }
        if (src instanceof TextComponent) {
            value.node(new Object[]{"text"}).set((Object)((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            value.node(new Object[]{"translate"}).set((Object)tc.key());
            if (!tc.arguments().isEmpty()) {
                ConfigurationNode with = value.node(new Object[]{"with"});
                for (TranslationArgument arg : tc.arguments()) {
                    with.appendListNode().set(TranslationArgument.class, (Object)arg);
                }
            }
            value.node(new Object[]{"fallback"}).set((Object)tc.fallback());
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            ConfigurationNode score = value.node(new Object[]{"score"});
            score.node(new Object[]{"name"}).set((Object)sc.name());
            score.node(new Object[]{"objective"}).set((Object)sc.objective());
            @Nullable String scoreValue = sc.value();
            if (scoreValue != null) {
                score.node(new Object[]{"value"}).set((Object)scoreValue);
            }
        } else if (src instanceof SelectorComponent) {
            value.node(new Object[]{"selector"}).set((Object)((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            value.node(new Object[]{"keybind"}).set((Object)((KeybindComponent)src).keybind());
        } else if (src instanceof NBTComponent) {
            NBTComponent nc = (NBTComponent)src;
            value.node(new Object[]{"nbt"}).set((Object)nc.nbtPath());
            value.node(new Object[]{"interpret"}).set((Object)nc.interpret());
            if (src instanceof BlockNBTComponent) {
                value.node(new Object[]{"block"}).set(BlockNBTPosSerializer.INSTANCE.type(), (Object)((BlockNBTComponent)nc).pos());
            } else if (src instanceof EntityNBTComponent) {
                value.node(new Object[]{"entity"}).set((Object)((EntityNBTComponent)nc).selector());
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                value.node(new Object[]{"storage"}).set(KeySerializer.INSTANCE.type(), (Object)((StorageNBTComponent)nc).storage());
            }
        } else {
            if (!(src instanceof ObjectComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
            ObjectComponent objectComponent = (ObjectComponent)src;
            ObjectContents contents = objectComponent.contents();
            if (contents instanceof SpriteObjectContents) {
                SpriteObjectContents spriteContents = (SpriteObjectContents)contents;
                if (!spriteContents.atlas().equals(SpriteObjectContents.DEFAULT_ATLAS)) {
                    value.node(new Object[]{"atlas"}).set(KeySerializer.INSTANCE.type(), (Object)spriteContents.atlas());
                }
                value.node(new Object[]{"sprite"}).set(KeySerializer.INSTANCE.type(), (Object)spriteContents.sprite());
            } else {
                if (!(contents instanceof PlayerHeadObjectContents)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                PlayerHeadObjectContents playerHeadContents = (PlayerHeadObjectContents)contents;
                value.node(new Object[]{"hat"}).set((Object)playerHeadContents.hat());
                String playerName = playerHeadContents.name();
                UUID playerId = playerHeadContents.id();
                List properties = playerHeadContents.profileProperties();
                Key texture = playerHeadContents.texture();
                ConfigurationNode player = value.node(new Object[]{"player"});
                if (playerId == null && properties.isEmpty() && texture == null) {
                    if (playerName != null) {
                        player.set((Object)playerName);
                    } else {
                        player.set(Collections.emptyMap());
                    }
                } else {
                    if (playerName != null) {
                        player.node(new Object[]{"name"}).set((Object)playerName);
                    }
                    if (playerId != null) {
                        player.node(new Object[]{"id"}).set((Object)playerId);
                    }
                    if (!properties.isEmpty()) {
                        player.node(new Object[]{"properties"}).set(PROPERTY_LIST_TYPE, (Object)properties);
                    }
                    if (texture != null) {
                        player.node(new Object[]{"texture"}).set(KeySerializer.INSTANCE.type(), (Object)texture);
                    }
                }
            }
        }
        List children = src.children();
        if (!children.isEmpty()) {
            value.node(new Object[]{"extra"}).set(LIST_TYPE, (Object)children);
        }
        if (!src.hasStyling()) return;
        value.set(Style.class, (Object)src.style());
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return (B)builder.nbtPath(nbt).interpret(interpret);
    }

    private static SerializationException notSureHowToDeserialize(ConfigurationNode element) {
        return new SerializationException("Don't know how to turn " + element + " into a Component");
    }

    private static SerializationException notSureHowToSerialize(Component component) {
        return new SerializationException("Don't know how to serialize " + component + " as a Component");
    }
}

