/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ARGBLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class StyleSerializer
implements TypeSerializer<Style> {
    static final StyleSerializer INSTANCE = new StyleSerializer();
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    static final String FONT = "font";
    static final String COLOR = "color";
    static final String SHADOW_COLOR = "shadow_color";
    static final String INSERTION = "insertion";
    static final String CLICK_EVENT = "clickEvent";
    static final String CLICK_EVENT_ACTION = "action";
    static final String CLICK_EVENT_VALUE = "value";
    static final String HOVER_EVENT = "hoverEvent";
    static final String HOVER_EVENT_ACTION = "action";
    static final TypeToken<HoverEvent.Action<?>> HOVER_EVENT_ACTION_TYPE = new TypeToken<HoverEvent.Action<?>>(){};
    static final String HOVER_EVENT_CONTENTS = "contents";
    @Deprecated
    static final String HOVER_EVENT_VALUE = "value";

    private StyleSerializer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Style deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        ConfigurationNode hoverEvent;
        ConfigurationNode clickEvent;
        ShadowColor shadowColor;
        TextColor color;
        if (value.virtual()) {
            return Style.empty();
        }
        Style.Builder builder = Style.style();
        @Nullable Key font = (Key)value.node(new Object[]{FONT}).get(Key.class);
        if (font != null) {
            builder.font(font);
        }
        if ((color = (TextColor)value.node(new Object[]{COLOR}).get(TextColor.class)) != null) {
            builder.color(color);
        }
        if ((shadowColor = (ShadowColor)value.node(new Object[]{SHADOW_COLOR}).get(ShadowColor.class)) != null) {
            builder.shadowColor((ARGBLike)shadowColor);
        }
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state = (TextDecoration.State)value.node(new Object[]{StyleSerializer.nonNull((String)TextDecoration.NAMES.key((Object)decoration), "decoration")}).get(TextDecoration.State.class);
            if (state == null) continue;
            builder.decoration(decoration, state);
        }
        @Nullable String insertion = value.node(new Object[]{INSERTION}).getString();
        if (insertion != null) {
            builder.insertion(insertion);
        }
        if (!(clickEvent = value.node(new Object[]{CLICK_EVENT})).virtual()) {
            ClickEvent.Action action = StyleSerializer.nonNull((ClickEvent.Action)clickEvent.node(new Object[]{"action"}).get(ClickEvent.Action.class), "click event action");
            builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)action, (String)StyleSerializer.nonNull(clickEvent.node(new Object[]{"value"}).getString(), "click event value")));
        }
        if ((hoverEvent = value.node(new Object[]{HOVER_EVENT})).virtual()) return builder.build();
        HoverEvent.Action action = (HoverEvent.Action)hoverEvent.node(new Object[]{"action"}).get(HOVER_EVENT_ACTION_TYPE);
        ConfigurationNode contents = hoverEvent.node(new Object[]{HOVER_EVENT_CONTENTS});
        if (contents.virtual()) {
            Component legacyValue = (Component)hoverEvent.node(new Object[]{"value"}).get(Component.class);
            if (legacyValue == null) {
                throw new SerializationException("No modern contents or legacy value present for hover event");
            }
            if (action != HoverEvent.Action.SHOW_TEXT) throw new SerializationException("Unable to deserialize legacy hover event of type " + action);
            builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)legacyValue));
            return builder.build();
        } else if (action == HoverEvent.Action.SHOW_TEXT) {
            builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)StyleSerializer.nonNull((Component)contents.get(Component.class), "hover event text contents")));
            return builder.build();
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            builder.hoverEvent((HoverEventSource)HoverEvent.showEntity((HoverEvent.ShowEntity)StyleSerializer.nonNull((HoverEvent.ShowEntity)contents.get(HoverEvent.ShowEntity.class), "hover event show entity contents")));
            return builder.build();
        } else {
            if (action != HoverEvent.Action.SHOW_ITEM) throw new SerializationException("Unsupported hover event action " + action);
            builder.hoverEvent((HoverEventSource)HoverEvent.showItem((HoverEvent.ShowItem)StyleSerializer.nonNull((HoverEvent.ShowItem)contents.get(HoverEvent.ShowItem.class), "hover event show item contents")));
        }
        return builder.build();
    }

    public void serialize(@NotNull Type type, @Nullable Style obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            obj = Style.empty();
        }
        value.node(new Object[]{FONT}).set(Key.class, (Object)obj.font());
        value.node(new Object[]{COLOR}).set(TextColor.class, (Object)obj.color());
        value.node(new Object[]{SHADOW_COLOR}).set(ShadowColor.class, (Object)obj.shadowColor());
        for (TextDecoration decoration : DECORATIONS) {
            ConfigurationNode decorationNode = value.node(new Object[]{StyleSerializer.nonNull((String)TextDecoration.NAMES.key((Object)decoration), "decoration")});
            TextDecoration.State state = obj.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) {
                decorationNode.set(null);
                continue;
            }
            decorationNode.set((Object)(state == TextDecoration.State.TRUE ? 1 : 0));
        }
        value.node(new Object[]{INSERTION}).set((Object)obj.insertion());
        ConfigurationNode clickNode = value.node(new Object[]{CLICK_EVENT});
        ClickEvent clickEvent = obj.clickEvent();
        if (clickEvent == null) {
            clickNode.set(null);
        } else {
            clickNode.node(new Object[]{"action"}).set(ClickEvent.Action.class, (Object)clickEvent.action());
            clickNode.node(new Object[]{"value"}).set((Object)clickEvent.value());
        }
        ConfigurationNode hoverNode = value.node(new Object[]{HOVER_EVENT});
        if (obj.hoverEvent() == null) {
            hoverNode.set(null);
        } else {
            HoverEvent event = obj.hoverEvent();
            hoverNode.node(new Object[]{"action"}).set(HOVER_EVENT_ACTION_TYPE, (Object)event.action());
            ConfigurationNode contentsNode = hoverNode.node(new Object[]{HOVER_EVENT_CONTENTS});
            if (event.action() == HoverEvent.Action.SHOW_TEXT) {
                contentsNode.set(Component.class, (Object)((Component)event.value()));
            } else if (event.action() == HoverEvent.Action.SHOW_ENTITY) {
                contentsNode.set(HoverEvent.ShowEntity.class, (Object)((HoverEvent.ShowEntity)event.value()));
            } else if (event.action() == HoverEvent.Action.SHOW_ITEM) {
                contentsNode.set(HoverEvent.ShowItem.class, (Object)((HoverEvent.ShowItem)event.value()));
            }
        }
    }

    @NotNull
    private static <T> T nonNull(@Nullable T value, @NotNull String type) throws SerializationException {
        if (value == null) {
            throw new SerializationException(type + " was null in an unexpected location");
        }
        return value;
    }

    public Style emptyValue(Type specificType, ConfigurationOptions options) {
        return Style.empty();
    }
}

