/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

final class DurationSerializer
extends ScalarSerializer<Duration> {
    static final DurationSerializer INSTANCE = new DurationSerializer();

    private DurationSerializer() {
        super(Duration.class);
    }

    public Duration deserialize(@NotNull Type type, @NotNull Object obj) throws SerializationException {
        if (obj instanceof CharSequence) {
            String value = obj.toString();
            if (!value.startsWith("P") && !value.startsWith("p")) {
                value = "P" + value;
            }
            try {
                return Duration.parse(value);
            }
            catch (DateTimeParseException ex) {
                throw new SerializationException((Throwable)ex);
            }
        }
        throw new SerializationException("Value was not of appropriate type");
    }

    public Object serialize(@NotNull Duration item, @NotNull Predicate<Class<?>> typeSupported) {
        return item.toString();
    }
}

