/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.spongeapi;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.platform.facet.Facet;
import net.kyori.adventure.platform.facet.FacetBase;
import net.kyori.adventure.platform.facet.FacetComponentFlattener;
import net.kyori.adventure.platform.facet.FacetPointers;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.spongeapi.SpongeComponentSerializer;
import net.kyori.adventure.util.Index;
import net.kyori.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.Locatable;

class SpongeFacet<V>
extends FacetBase<V> {
    protected SpongeFacet(@Nullable Class<? extends V> viewerClass) {
        super(viewerClass);
    }

    @Nullable
    public <K, S extends CatalogType> S sponge(@NotNull Class<S> spongeType, @NotNull K value, @NotNull Index<String, K> elements) {
        return (S)Sponge.getRegistry().getType(spongeType, (String)elements.key(Objects.requireNonNull(value, "value"))).orElseGet(() -> {
            Knob.logUnsupported((Object)((Object)this), (Object)value);
            return null;
        });
    }

    @Nullable
    public <S extends CatalogType> S sponge(@NotNull Class<S> spongeType, @NotNull Key identifier) {
        return (S)Sponge.getRegistry().getType(spongeType, Objects.requireNonNull(identifier, "Identifier must be non-null").asString()).orElseGet(() -> {
            Knob.logUnsupported((Object)((Object)this), (Object)identifier);
            return null;
        });
    }

    static final class Translator
    extends SpongeFacet<Game>
    implements FacetComponentFlattener.Translator<Game> {
        Translator() {
            super(Game.class);
        }

        @NotNull
        public String valueOrDefault(@NotNull Game game, @NotNull String key) {
            Optional tr = game.getRegistry().getTranslationById(key);
            return tr.isPresent() ? ((Translation)tr.get()).get() : key;
        }
    }

    static final class IdentifiablePointers
    extends SpongeFacet<Identifiable>
    implements Facet.Pointers<Identifiable> {
        IdentifiablePointers() {
            super(Identifiable.class);
        }

        public void contributePointers(Identifiable viewer, Pointers.Builder builder) {
            builder.withDynamic(Identity.UUID, () -> ((Identifiable)viewer).getUniqueId());
        }
    }

    static final class PlayerPointers
    extends SpongeFacet<Player>
    implements Facet.Pointers<Player> {
        PlayerPointers() {
            super(Player.class);
        }

        public void contributePointers(Player viewer, Pointers.Builder builder) {
            builder.withStatic(FacetPointers.TYPE, (Object)FacetPointers.Type.PLAYER);
        }
    }

    static final class LocatablePointers
    extends SpongeFacet<Locatable>
    implements Facet.Pointers<Locatable> {
        LocatablePointers() {
            super(Locatable.class);
        }

        public void contributePointers(Locatable viewer, Pointers.Builder builder) {
            builder.withDynamic(FacetPointers.WORLD, () -> Key.key((String)viewer.getWorld().getName()));
        }
    }

    static final class CommandSourcePointers
    extends SpongeFacet<CommandSource>
    implements Facet.Pointers<CommandSource> {
        CommandSourcePointers() {
            super(CommandSource.class);
        }

        public void contributePointers(CommandSource viewer, Pointers.Builder builder) {
            builder.withStatic(Identity.NAME, (Object)viewer.getName());
            builder.withDynamic(Identity.LOCALE, () -> ((CommandSource)viewer).getLocale());
        }
    }

    static final class ConsoleSourcePointers
    extends SpongeFacet<ConsoleSource>
    implements Facet.Pointers<ConsoleSource> {
        ConsoleSourcePointers() {
            super(ConsoleSource.class);
        }

        public void contributePointers(ConsoleSource viewer, Pointers.Builder builder) {
            builder.withStatic(FacetPointers.TYPE, (Object)FacetPointers.Type.CONSOLE);
        }
    }

    static final class SubjectPointers
    extends SpongeFacet<Subject>
    implements Facet.Pointers<Subject> {
        SubjectPointers() {
            super(Subject.class);
        }

        public void contributePointers(Subject viewer, Pointers.Builder builder) {
            builder.withStatic(PermissionChecker.POINTER, perm -> {
                Tristate sponge = viewer.getPermissionValue(viewer.getActiveContexts(), perm);
                if (sponge == Tristate.UNDEFINED) {
                    return TriState.NOT_SET;
                }
                return TriState.byBoolean((boolean)sponge.asBoolean());
            });
        }
    }

    static class TabList
    extends Message<Player>
    implements Facet.TabList<Player, Text> {
        TabList() {
            super(Player.class);
        }

        public void send(Player viewer, @Nullable Text header, @Nullable Text footer) {
            if (header != null && footer != null) {
                viewer.getTabList().setHeaderAndFooter(header, footer);
            } else if (header != null) {
                viewer.getTabList().setHeader(header);
            } else if (footer != null) {
                viewer.getTabList().setFooter(footer);
            }
        }
    }

    static class BossBar
    extends Message<Player>
    implements Facet.BossBar<Player> {
        private final ServerBossBar bar = ServerBossBar.builder().name(Text.of()).color(BossBarColors.PINK).overlay(BossBarOverlays.PROGRESS).visible(false).build();

        protected BossBar(@NotNull Collection<Player> viewers) {
            super(Player.class);
            this.bar.addPlayers(viewers);
        }

        public void bossBarInitialized(@NotNull net.kyori.adventure.bossbar.BossBar bar) {
            super.bossBarInitialized(bar);
            this.bar.setVisible(true);
        }

        public void bossBarNameChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, @NotNull Component oldName, @NotNull Component newName) {
            if (!this.bar.getPlayers().isEmpty()) {
                this.bar.setName(this.createMessage((Player)this.bar.getPlayers().iterator().next(), newName));
            }
        }

        public void bossBarProgressChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, float oldPercent, float newPercent) {
            this.bar.setPercent(newPercent);
        }

        public void bossBarColorChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Color newColor) {
            BossBarColor color = this.sponge(BossBarColor.class, newColor, BossBar.Color.NAMES);
            if (color != null) {
                this.bar.setColor(color);
            }
        }

        public void bossBarOverlayChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Overlay newOverlay) {
            BossBarOverlay overlay = this.sponge(BossBarOverlay.class, newOverlay, BossBar.Overlay.NAMES);
            if (overlay != null) {
                this.bar.setOverlay(overlay);
            }
        }

        public void bossBarFlagsChanged(@NotNull net.kyori.adventure.bossbar.BossBar bar, @NotNull Set<BossBar.Flag> removedFlags, @NotNull Set<BossBar.Flag> addedFlags) {
            Boolean bossMusic;
            Boolean darkenScreen;
            Boolean fog = this.hasFlag(BossBar.Flag.CREATE_WORLD_FOG, removedFlags, addedFlags);
            if (fog != null) {
                this.bar.setCreateFog(fog.booleanValue());
            }
            if ((darkenScreen = this.hasFlag(BossBar.Flag.DARKEN_SCREEN, removedFlags, addedFlags)) != null) {
                this.bar.setDarkenSky(darkenScreen.booleanValue());
            }
            if ((bossMusic = this.hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC, removedFlags, addedFlags)) != null) {
                this.bar.setPlayEndBossMusic(bossMusic.booleanValue());
            }
        }

        @Nullable
        private Boolean hasFlag(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull BossBar.Flag flag, @NotNull Set<BossBar.Flag> removedFlags, @NotNull Set<BossBar.Flag> addedFlags) {
            if (addedFlags.contains(flag)) {
                return true;
            }
            if (removedFlags.contains(flag)) {
                return false;
            }
            return null;
        }

        public void addViewer(@NotNull Player viewer) {
            this.bar.addPlayer(viewer);
        }

        public void removeViewer(@NotNull Player viewer) {
            this.bar.removePlayer(viewer);
        }

        public boolean isEmpty() {
            return !this.bar.isVisible() || this.bar.getPlayers().isEmpty();
        }

        public void close() {
            this.bar.removePlayers(this.bar.getPlayers());
        }
    }

    static class BossBarBuilder
    extends SpongeFacet<Player>
    implements Facet.BossBar.Builder<Player, BossBar> {
        protected BossBarBuilder() {
            super(Player.class);
        }

        public @NotNull BossBar createBossBar(@NotNull Collection<Player> viewers) {
            return new BossBar(viewers);
        }
    }

    static class Book
    extends Message<Viewer>
    implements Facet.Book<Viewer, Text, BookView> {
        protected Book() {
            super(Viewer.class);
        }

        @NotNull
        public BookView createBook(@NotNull String title, @NotNull String author, @NotNull Iterable<Text> pages) {
            return BookView.builder().title((Text)Text.of((String)title)).author((Text)Text.of((String)author)).addPages((Collection)Lists.newArrayList(pages)).build();
        }

        public void openBook(@NotNull Viewer viewer, @NotNull BookView book) {
            viewer.sendBookView(book);
        }
    }

    static class Sound
    extends Position
    implements Facet.Sound<Viewer, Vector3d> {
        Sound() {
        }

        public void playSound(@NotNull Viewer viewer, @NotNull net.kyori.adventure.sound.Sound sound, @NotNull Vector3d vector) {
            SoundType type = this.type(sound.name());
            SoundCategory category = this.category(sound.source());
            if (type != null && category != null) {
                viewer.playSound(type, category, vector, (double)sound.volume(), (double)sound.pitch());
            } else if (type != null) {
                viewer.playSound(type, vector, (double)sound.volume(), (double)sound.pitch());
            }
        }

        public void stopSound(@NotNull Viewer viewer, @NotNull SoundStop stop) {
            SoundType type = this.type(stop.sound());
            SoundCategory category = this.category(stop.source());
            if (type != null && category != null) {
                viewer.stopSounds(type, category);
            } else if (type != null) {
                viewer.stopSounds(type);
            } else if (category != null) {
                viewer.stopSounds(category);
            } else {
                viewer.stopSounds();
            }
        }

        @Nullable
        public SoundType type(@Nullable Key sound) {
            return sound == null ? null : this.sponge(SoundType.class, sound);
        }

        @Nullable
        public SoundCategory category(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable Sound.Source source) {
            return source == null ? null : this.sponge(SoundCategory.class, source, Sound.Source.NAMES);
        }
    }

    static class Position
    extends SpongeFacet<Viewer>
    implements Facet.Position<Viewer, Vector3d> {
        protected Position() {
            super(Viewer.class);
        }

        public boolean isApplicable(@NotNull Viewer viewer) {
            return super.isApplicable((Object)viewer) && viewer instanceof Locatable;
        }

        @Nullable
        public Vector3d createPosition(@NotNull Viewer viewer) {
            if (viewer instanceof Locatable) {
                return ((Locatable)viewer).getLocation().getPosition();
            }
            return null;
        }

        @NotNull
        public Vector3d createPosition(double x, double y, double z) {
            return new Vector3d(x, y, z);
        }
    }

    static class Title
    extends Message<Viewer>
    implements Facet.Title<Viewer, Text, Title.Builder, org.spongepowered.api.text.title.Title> {
        protected Title() {
            super(Viewer.class);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Title.Builder createTitleCollection() {
            return org.spongepowered.api.text.title.Title.builder();
        }

        public void contributeTitle(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Title.Builder coll, @NotNull Text title) {
            coll.title(title);
        }

        public void contributeSubtitle(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Title.Builder coll, @NotNull Text subtitle) {
            coll.subtitle(subtitle);
        }

        public void contributeTimes(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Title.Builder coll, int inTicks, int stayTicks, int outTicks) {
            if (inTicks > -1) {
                coll.fadeIn(Integer.valueOf(inTicks));
            }
            if (stayTicks > -1) {
                coll.stay(Integer.valueOf(stayTicks));
            }
            if (outTicks > -1) {
                coll.fadeOut(Integer.valueOf(outTicks));
            }
        }

        @Nullable
        public org.spongepowered.api.text.title.Title completeTitle(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Title.Builder coll) {
            return coll.build();
        }

        public void showTitle(@NotNull Viewer viewer, @NotNull org.spongepowered.api.text.title.Title title) {
            viewer.sendTitle(title);
        }

        public void clearTitle(@NotNull Viewer viewer) {
            viewer.clearTitle();
        }

        public void resetTitle(@NotNull Viewer viewer) {
            viewer.resetTitle();
        }
    }

    static class ActionBar
    extends Message<ChatTypeMessageReceiver>
    implements Facet.ActionBar<ChatTypeMessageReceiver, Text> {
        protected ActionBar() {
            super(ChatTypeMessageReceiver.class);
        }

        public void sendMessage(@NotNull ChatTypeMessageReceiver viewer, @NotNull Text message) {
            viewer.sendMessage(ChatTypes.ACTION_BAR, message);
        }
    }

    static class ChatWithType
    extends Message<ChatTypeMessageReceiver>
    implements Facet.Chat<ChatTypeMessageReceiver, Text> {
        protected ChatWithType() {
            super(ChatTypeMessageReceiver.class);
        }

        @Nullable
        private ChatType type(@NotNull MessageType type) {
            if (type == MessageType.CHAT) {
                return ChatTypes.CHAT;
            }
            if (type == MessageType.SYSTEM) {
                return ChatTypes.SYSTEM;
            }
            Knob.logUnsupported((Object)((Object)this), (Object)type);
            return null;
        }

        public void sendMessage(@NotNull ChatTypeMessageReceiver viewer, @NotNull Identity source, @NotNull Text message, @NotNull Object type) {
            ChatType chat;
            ChatType chatType = chat = type instanceof MessageType ? this.type((MessageType)type) : ChatTypes.SYSTEM;
            if (chat != null) {
                viewer.sendMessage(chat, message);
            }
        }
    }

    static class Chat
    extends Message<MessageReceiver>
    implements Facet.Chat<MessageReceiver, Text> {
        protected Chat() {
            super(MessageReceiver.class);
        }

        public void sendMessage(@NotNull MessageReceiver viewer, @NotNull Identity source, @NotNull Text message, @NotNull Object type) {
            viewer.sendMessage(message);
        }
    }

    static class Message<V>
    extends SpongeFacet<V>
    implements Facet.Message<V, Text> {
        protected Message(@Nullable Class<? extends V> viewerClass) {
            super(viewerClass);
        }

        @NotNull
        public Text createMessage(@NotNull V viewer, @NotNull Component message) {
            return SpongeComponentSerializer.get().serialize(message);
        }
    }
}

