/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.spongeapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.facet.Facet;
import net.kyori.adventure.platform.facet.FacetAudienceProvider;
import net.kyori.adventure.platform.facet.FacetComponentFlattener;
import net.kyori.adventure.platform.facet.Knob;
import net.kyori.adventure.platform.spongeapi.SpongeAudience;
import net.kyori.adventure.platform.spongeapi.SpongeAudiences;
import net.kyori.adventure.platform.spongeapi.SpongeFacet;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.translation.GlobalTranslator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameState;
import org.spongepowered.api.block.tileentity.CommandBlock;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.command.source.RconSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.World;

@Singleton
final class SpongeAudiencesImpl
extends FacetAudienceProvider<MessageReceiver, SpongeAudience>
implements SpongeAudiences {
    private static final Map<String, SpongeAudiences> INSTANCES;
    private static final Collection<FacetComponentFlattener.Translator<Game>> TRANSLATORS;
    private final PluginContainer plugin;
    private final Game game;
    private final EventManager eventManager;
    private final EventListener eventListener;
    private final ComponentFlattener flattener;

    static SpongeAudiences instanceFor(@NotNull PluginContainer plugin, @NotNull Game game) {
        return SpongeAudiencesImpl.builder(Objects.requireNonNull(plugin, "plugin"), Objects.requireNonNull(game, "game")).build();
    }

    static Builder builder(@NotNull PluginContainer plugin, @NotNull Game game) {
        return new Builder(plugin, game);
    }

    @Inject
    SpongeAudiencesImpl(@NotNull PluginContainer plugin, @NotNull Game game) {
        this(plugin, game, (ComponentRenderer<Pointered>)GlobalTranslator.renderer().mapContext(ptr -> (Locale)ptr.getOrDefault(Identity.LOCALE, (Object)FacetAudienceProvider.DEFAULT_LOCALE)));
    }

    SpongeAudiencesImpl(@NotNull PluginContainer plugin, @NotNull Game game, @NotNull ComponentRenderer<Pointered> componentRenderer) {
        super(componentRenderer);
        this.plugin = plugin;
        this.game = game;
        this.eventManager = game.getEventManager();
        this.eventListener = new EventListener();
        this.eventManager.registerListeners((Object)plugin, (Object)this.eventListener);
        this.flattener = FacetComponentFlattener.get((Object)game, TRANSLATORS);
        if (game.isServerAvailable() && game.getState().compareTo((Enum)GameState.POST_INITIALIZATION) > 0) {
            this.addViewer(game.getServer().getConsole());
            for (Player player : game.getServer().getOnlinePlayers()) {
                this.addViewer(player);
            }
        }
    }

    @Override
    @NotNull
    public Audience receiver(@NotNull MessageReceiver receiver) {
        if (receiver instanceof Player) {
            return this.player((Player)receiver);
        }
        if (receiver instanceof ConsoleSource || receiver instanceof RconSource && ((RconSource)receiver).getLoggedIn()) {
            return this.console();
        }
        if (receiver instanceof World) {
            return this.world(Key.key((String)((World)receiver).getName()));
        }
        if (receiver instanceof ProxySource) {
            return this.receiver((MessageReceiver)((ProxySource)receiver).getOriginalSource());
        }
        if (receiver instanceof CommandBlock) {
            return Audience.empty();
        }
        return new SpongeAudience(this, Collections.singletonList(receiver));
    }

    @Override
    @NotNull
    public Audience player(@NotNull Player player) {
        return this.player(player.getUniqueId());
    }

    @NotNull
    protected SpongeAudience createAudience(@NotNull Collection<MessageReceiver> viewers) {
        return new SpongeAudience(this, viewers);
    }

    @NotNull
    public ComponentFlattener flattener() {
        return this.flattener;
    }

    public void close() {
        INSTANCES.remove(this.plugin.getId());
        this.eventManager.unregisterListeners((Object)this.eventListener);
        super.close();
    }

    static {
        Logger logger = LoggerFactory.getLogger(SpongeAudiences.class);
        Knob.OUT = arg_0 -> ((Logger)logger).debug(arg_0);
        Knob.ERR = (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1);
        INSTANCES = Collections.synchronizedMap(new HashMap(4));
        TRANSLATORS = Facet.of((Supplier[])new Supplier[]{SpongeFacet.Translator::new});
    }

    public final class EventListener {
        @Listener(order=Order.FIRST)
        public void onLogin(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ClientConnectionEvent.Join event) {
            SpongeAudiencesImpl.this.addViewer(event.getTargetEntity());
        }

        @Listener(order=Order.LAST)
        public void onDisconnect(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ClientConnectionEvent.Disconnect event) {
            SpongeAudiencesImpl.this.removeViewer(event.getTargetEntity());
        }

        @Listener
        public void onStart(@NotNull GameStartingServerEvent event) {
            SpongeAudiencesImpl.this.addViewer(SpongeAudiencesImpl.this.game.getServer().getConsole());
        }

        @Listener
        public void onStop(@NotNull GameStoppedServerEvent event) {
            SpongeAudiencesImpl.this.removeViewer(SpongeAudiencesImpl.this.game.getServer().getConsole());
        }
    }

    static final class Builder
    implements SpongeAudiences.Builder {
        @NotNull
        private final PluginContainer plugin;
        @NotNull
        private final Game game;
        private ComponentRenderer<Pointered> componentRenderer;

        Builder(@NotNull PluginContainer plugin, @NotNull Game game) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.game = Objects.requireNonNull(game, "game");
            this.componentRenderer(ptr -> (Locale)ptr.getOrDefault(Identity.LOCALE, (Object)DEFAULT_LOCALE), (ComponentRenderer)GlobalTranslator.renderer());
        }

        @NotNull
        public Builder componentRenderer(@NotNull ComponentRenderer<Pointered> componentRenderer) {
            this.componentRenderer = Objects.requireNonNull(componentRenderer, "component renderer");
            return this;
        }

        public @NotNull SpongeAudiences.Builder partition(@NotNull Function<Pointered, ?> partitionFunction) {
            Objects.requireNonNull(partitionFunction, "partitionFunction");
            return this;
        }

        @NotNull
        public SpongeAudiences build() {
            return INSTANCES.computeIfAbsent(this.plugin.getId(), id -> new SpongeAudiencesImpl(this.plugin, this.game, this.componentRenderer));
        }
    }
}

