/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.cpprograms.minecraft.General.CommandSet;
import net.cpprograms.minecraft.General.PluginBase;
import net.cpprograms.minecraft.TravelPortals.MinecraftFontWidthCalculator;
import net.cpprograms.minecraft.TravelPortals.TravelPortals;
import net.cpprograms.minecraft.TravelPortals.WarpLocation;
import net.cpprograms.minecraft.TravelPortals.storage.StorageType;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class PortalCommandSet
extends CommandSet {
    TravelPortals plugin;

    @Override
    public void setPlugin(PluginBase plugin) {
        this.plugin = (TravelPortals)plugin;
    }

    @Override
    public boolean noParams(CommandSender sender) {
        sender.sendMessage(ChatColor.DARK_RED + "Incorrect usage; try /portal help for help with portals.");
        return true;
    }

    @Override
    public boolean noSuchMethod(CommandSender sender, String method, String[] args) {
        return this.noParams(sender);
    }

    @Override
    public boolean internalError(CommandSender sender, String method, String[] args, Exception e) {
        sender.sendMessage(ChatColor.DARK_RED + "An internal error occurred while handling this command.");
        if (!(sender instanceof ConsoleCommandSender)) {
            this.plugin.logInfo("An error occurred while handling the command " + method + " from " + sender.getName());
        }
        this.plugin.logDebug("Arguments passed in were: " + Arrays.toString(args));
        if (this.plugin.isDebugging()) {
            e.printStackTrace();
        }
        this.plugin.logInfo("If you see this continually, please report this bug after turning on debug mode.");
        return true;
    }

    @Override
    public boolean help(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.help")) {
                return this.noPermissionForAction(sender);
            }
            player.sendMessage(ChatColor.DARK_AQUA + "-- TravelPortals Help --");
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.portal.create")) {
                player.sendMessage(ChatColor.BLUE + "Create a portal by surrounding a 2x1 area with " + this.plugin.strBlocktype);
                player.sendMessage(ChatColor.BLUE + "and a " + this.plugin.strDoortype + ", then putting a" + this.plugin.strTorchtype + " at the bottom.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.name")) {
                player.sendMessage(ChatColor.DARK_GREEN + "/portal name [name]" + ChatColor.GREEN + " sets the name of this portal.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.warp")) {
                player.sendMessage(ChatColor.DARK_GREEN + "/portal warp [name]" + ChatColor.GREEN + " sets the portal name to warp to.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.privacy")) {
                player.sendMessage(ChatColor.DARK_GREEN + "/portal privacy [name] public|hidden|private" + ChatColor.GREEN + " sets the portal's privacy level.");
            } else if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.hide")) {
                player.sendMessage(ChatColor.DARK_GREEN + "/portal hide [name]" + ChatColor.GREEN + " hides (or unhides) a portal from the list.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.info")) {
                player.sendMessage(ChatColor.DARK_GREEN + "/portal info" + ChatColor.GREEN + " shows information about named or nearby portal.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.claim")) {
                player.sendMessage(ChatColor.DARK_GREEN + "/portal claim" + ChatColor.GREEN + " claims (or gives up ownership of) a portal.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.deactivate", player.isOp())) {
                player.sendMessage(ChatColor.DARK_RED + "/portal deactivate [name]" + ChatColor.RED + " deactivates a portal entirely.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.renameworld", player.isOp())) {
                player.sendMessage(ChatColor.RED + "If you rename a world, use " + ChatColor.DARK_RED + "/portal renameworld [oldname] [newname]" + ChatColor.RED + " to redirect existing portals");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.fixworld", player.isOp())) {
                sender.sendMessage(ChatColor.RED + "You can set any portals without worlds with " + ChatColor.DARK_RED + "/portal fixworld [world]");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.deleteworld", player.isOp())) {
                player.sendMessage(ChatColor.RED + "If you delete a world, use " + ChatColor.DARK_RED + "/portal deleteworld [name]" + ChatColor.RED + " to delete all portals pointing to it.");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.export", player.isOp())) {
                player.sendMessage(ChatColor.RED + "You can export to travelportals.txt with " + ChatColor.DARK_RED + "/portal export");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.reimport", player.isOp())) {
                player.sendMessage(ChatColor.RED + "You can import portals with " + ChatColor.DARK_RED + "/portal reimport [file name]");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.reload", player.isOp())) {
                player.sendMessage(ChatColor.RED + "If you want to reload the plugin config use " + ChatColor.DARK_RED + "/portal reload");
            }
            if (this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.list")) {
                player.sendMessage(ChatColor.GRAY + "To get a list of existing portals, use the command " + ChatColor.WHITE + "/portal list.");
            }
        } else {
            sender.sendMessage(ChatColor.DARK_AQUA + "-- TravelPortals Help --");
            sender.sendMessage(ChatColor.GRAY + "Note: Most commands aren't accessible from the command line.");
            sender.sendMessage(ChatColor.DARK_GREEN + "portal info" + ChatColor.GREEN + " shows information about named or nearby portal.");
            sender.sendMessage(ChatColor.DARK_GREEN + "portal hide" + ChatColor.GREEN + " hides or unhides a named portal.");
            sender.sendMessage(ChatColor.DARK_RED + "portal deactivate [name]" + ChatColor.RED + " deactivates a portal entirely.");
            sender.sendMessage(ChatColor.DARK_RED + "portal export" + ChatColor.RED + " exports all known portals to travelportals.txt");
            sender.sendMessage(ChatColor.DARK_RED + "portal reimport [file name]" + ChatColor.RED + " imports a list of portals from a txt file");
            sender.sendMessage(ChatColor.RED + "If you rename a world, use " + ChatColor.DARK_RED + "/portal renameworld [oldname] [newname]" + ChatColor.RED + " to replace it");
            sender.sendMessage(ChatColor.RED + "You can set any portals without worlds with " + ChatColor.DARK_RED + "/portal fixworld world");
            sender.sendMessage(ChatColor.RED + "If you delete a world, use " + ChatColor.DARK_RED + "/portal deleteworld [name]" + ChatColor.RED + " to delete all portals pointing to it.");
            sender.sendMessage(ChatColor.RED + "If you want to reload the plugin config use " + ChatColor.DARK_RED + "/portal reload");
            sender.sendMessage(ChatColor.GRAY + "To get a list of existing portals, use the command " + ChatColor.WHITE + "/portal list.");
        }
        return true;
    }

    public boolean reload(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.reload", sender.isOp())) {
            return this.noPermissionForAction(sender);
        }
        this.plugin.getPortalStorage().save();
        this.plugin.reloadConfig();
        if (this.plugin.load()) {
            sender.sendMessage(ChatColor.DARK_GREEN + "Reloaded the config!");
        } else {
            sender.sendMessage(ChatColor.DARK_RED + "Failed to reload the config!");
        }
        return true;
    }

    public boolean list(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.command.list")) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        String ownerName = null;
        int pn = 1;
        if (args.length >= 1) {
            try {
                pn = Integer.parseInt(args[args.length - 1]);
                if (args.length >= 2) {
                    ownerName = args[0];
                }
            }
            catch (NumberFormatException e) {
                ownerName = args[0];
            }
        }
        if (pn < 1) {
            pn = 1;
        }
        boolean showAll = this.plugin.permissions.hasPermission(sender, "travelportals.command.list.all");
        String finalOwner = this.plugin.permissions.hasPermission(sender, "travelportals.command.list.others") ? ownerName : null;
        UUID ownerId = sender instanceof Player && finalOwner == null ? ((Player)sender).getUniqueId() : null;
        List allp = this.plugin.getPortalStorage().getPortals().values().stream().filter(w -> w.hasName() && (finalOwner == null || finalOwner.equalsIgnoreCase(w.getOwnerName())) && (showAll && w.getPrivacy() == WarpLocation.Privacy.PUBLIC || w.canAccess(sender) || this.plugin.permissions.hasPermission(sender, "travelportals.admin.portal.see", sender.isOp()))).sorted((p1, p2) -> {
            if (ownerId != null && ownerId.equals(p1.getOwnerId()) != ownerId.equals(p2.getOwnerId())) {
                if (ownerId.equals(p1.getOwnerId())) {
                    return -1;
                }
                return 1;
            }
            if (finalOwner != null && finalOwner.equalsIgnoreCase(p1.getOwnerName()) != finalOwner.equalsIgnoreCase(p2.getOwnerName())) {
                if (finalOwner.equalsIgnoreCase(p1.getOwnerName())) {
                    return -1;
                }
                return 1;
            }
            return p1.getName().compareToIgnoreCase(p2.getName());
        }).collect(Collectors.toList());
        if (allp.isEmpty()) {
            sender.sendMessage(ChatColor.DARK_RED + "There are no visible portals to list!");
            return true;
        }
        sender.sendMessage(ChatColor.DARK_GREEN + "TravelPortals" + (finalOwner != null ? " by " + finalOwner : "") + " (Page " + pn + "/" + (int)Math.ceil((double)allp.size() / 8.0) + ")");
        sender.sendMessage(ChatColor.DARK_AQUA + "---------------------------------------------------");
        for (int i = (pn - 1) * 8; i < pn * 8 && i < allp.size(); ++i) {
            WarpLocation w2 = (WarpLocation)allp.get(i);
            String cl = w2.getPrivacy().getColor() + w2.getName();
            int maxWidth = (int)((double)(sender instanceof Player ? MinecraftFontWidthCalculator.getMaxStringWidth() : 51) / 2.2);
            int left = maxWidth - (sender instanceof Player ? MinecraftFontWidthCalculator.getStringWidth(cl) : cl.length());
            cl = left > 0 ? cl + (sender instanceof Player ? this.whitespace(left) : String.join((CharSequence)"", Collections.nCopies(left, " "))) : (sender instanceof Player ? this.substring(cl, maxWidth) : cl.substring(0, maxWidth));
            String destination = "(no destination)";
            if (!w2.getDestination().isEmpty()) {
                WarpLocation dest = this.plugin.getPortalStorage().getPortal(w2.getDestination());
                destination = dest != null ? (dest.getPrivacy() != WarpLocation.Privacy.PUBLIC ? (dest.canSee(sender) ? w2.getPrivacy().getColor() + dest.getName() : w2.getPrivacy().getColor() + "(???)") : dest.getName()) : ChatColor.RED + w2.getDestination();
            }
            cl = cl + ChatColor.WHITE + " --> " + ChatColor.DARK_AQUA + this.substring(destination, maxWidth);
            sender.sendMessage(ChatColor.DARK_AQUA + cl);
        }
        return true;
    }

    public boolean name(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.command.name")) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.DARK_RED + "You have to include a name for the location!");
        } else if (this.plugin.getPortalStorage().getPortal(args[0]) != null) {
            sender.sendMessage(ChatColor.DARK_RED + "There is already a portal named " + args[0] + ". Please pick another name.");
        } else {
            int nameIndex = args.length - 1;
            WarpLocation portal = null;
            if (nameIndex > 0) {
                portal = this.plugin.getPortalStorage().getPortal(args[0]);
            } else if (sender instanceof Player) {
                portal = this.getPortal((Player)sender);
            }
            if (portal == null) {
                sender.sendMessage(ChatColor.DARK_RED + "No portal found! (You must be within one block of the portal.)");
            } else {
                if (this.plugin.usepermissions && sender instanceof Player && !portal.isOwner((Player)sender) && !this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.name")) {
                    sender.sendMessage(ChatColor.DARK_RED + "You do not own this portal, and cannot change its name.");
                    return true;
                }
                if (portal.getName().equals(args[nameIndex])) {
                    sender.sendMessage(ChatColor.DARK_RED + "The portal was already named " + args[nameIndex] + "!");
                } else {
                    this.plugin.getPortalStorage().namePortal(portal, args[nameIndex]);
                    sender.sendMessage(ChatColor.DARK_GREEN + "This portal is now known as " + args[nameIndex] + ".");
                }
            }
        }
        return true;
    }

    public boolean warp(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.command.warp")) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.DARK_RED + "You have to include a destination!");
            return true;
        }
        int nameIndex = args.length - 1;
        WarpLocation portal = null;
        if (nameIndex > 0) {
            portal = this.plugin.getPortalStorage().getPortal(args[0]);
        } else if (sender instanceof Player) {
            portal = this.getPortal((Player)sender);
        }
        if (portal == null) {
            sender.sendMessage(ChatColor.DARK_RED + "No portal found! (You must be within one block of a portal.)");
        } else {
            if (this.plugin.usepermissions && !portal.canAccess(sender) && !this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.warp")) {
                sender.sendMessage(ChatColor.DARK_RED + "You do not own this portal, and cannot change its destination.");
                return true;
            }
            if (portal.getName().equals(args[nameIndex])) {
                sender.sendMessage(ChatColor.DARK_RED + "You cannot set a portal to warp to itself!");
            } else {
                WarpLocation destination = this.plugin.getPortalStorage().getPortal(args[nameIndex]);
                if (destination != null) {
                    if (destination.getPrivacy() == WarpLocation.Privacy.PRIVATE && !destination.canAccess(sender) && !this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.warp")) {
                        sender.sendMessage(ChatColor.RED + "The portal with the name " + destination.getName() + " is private. You cannot link to it.");
                        return true;
                    }
                    if (!(this.plugin.crossWorldPortals || destination.getWorld().isEmpty() || portal.getWorld().equals(destination.getWorld()) || this.plugin.permissions.hasPermission(sender, "travelportals.command.warp.crossworld", false))) {
                        sender.sendMessage(ChatColor.DARK_RED + "You cannot create portals between worlds.");
                        return true;
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "A portal with the name " + args[nameIndex] + " does not exist. Linking anyways.");
                }
                portal.setDestination(args[nameIndex]);
                this.plugin.getPortalStorage().save(portal);
                sender.sendMessage(ChatColor.DARK_GREEN + "This portal now points to " + args[nameIndex] + ".");
            }
        }
        return true;
    }

    public boolean hide(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.command.hide")) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        int nameIndex = args.length - 1;
        WarpLocation portal = null;
        if (nameIndex > 0) {
            portal = this.plugin.getPortalStorage().getPortal(args[0]);
        } else if (sender instanceof Player) {
            portal = this.getPortal((Player)sender);
        }
        if (portal == null) {
            sender.sendMessage(ChatColor.DARK_RED + "No portal found!");
        } else {
            if (sender instanceof Player && this.plugin.usepermissions && !portal.canAccess(sender) && !this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.hide")) {
                sender.sendMessage(ChatColor.DARK_RED + "You do not own this portal, and thus you cannot hide it.");
                return true;
            }
            if (portal.getPrivacy() == WarpLocation.Privacy.PUBLIC) {
                portal.setPrivacy(WarpLocation.Privacy.HIDDEN);
                sender.sendMessage(ChatColor.DARK_AQUA + "Warp " + portal.getName() + " has been hidden.");
            } else if (portal.getPrivacy() == WarpLocation.Privacy.HIDDEN) {
                portal.setPrivacy(WarpLocation.Privacy.PUBLIC);
                sender.sendMessage(ChatColor.DARK_AQUA + "Warp " + portal.getName() + " has been unhidden.");
            } else {
                sender.sendMessage(ChatColor.DARK_AQUA + "Warp " + portal.getName() + " is neither hidden nor public. Use /portal privacy public|hidden|private to set the privacy level!");
            }
        }
        return true;
    }

    public boolean privacy(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.command.privacy")) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.RED + "You have to include a privacy option for the portal! Available options: " + Arrays.toString((Object[])WarpLocation.Privacy.values()));
            return true;
        }
        int nameIndex = args.length - 1;
        WarpLocation portal = null;
        if (nameIndex > 0) {
            portal = this.plugin.getPortalStorage().getPortal(args[0]);
        } else if (sender instanceof Player) {
            portal = this.getPortal((Player)sender);
        }
        if (portal == null) {
            sender.sendMessage(ChatColor.DARK_RED + "No portal found!");
        } else {
            if (sender instanceof Player && this.plugin.usepermissions && !portal.canAccess(sender) && !this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.privacy")) {
                sender.sendMessage(ChatColor.DARK_RED + "You do not own this portal, and thus you cannot change its privacy settings.");
                return true;
            }
            try {
                WarpLocation.Privacy privacy = WarpLocation.Privacy.valueOf(args[nameIndex].toUpperCase());
                if (!this.plugin.permissions.hasPermission(sender, "travelportals.command.privacy." + privacy.name().toLowerCase())) {
                    sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use the privacy option " + privacy.name().toLowerCase());
                    return true;
                }
                if (portal.getPrivacy() != privacy) {
                    sender.sendMessage(ChatColor.DARK_AQUA + "Privacy of warp " + portal.getName() + " was set to " + privacy.getColor() + privacy.name().toLowerCase() + ChatColor.DARK_AQUA + " (was " + portal.getPrivacy().name().toLowerCase() + ")");
                    portal.setPrivacy(privacy);
                } else {
                    sender.sendMessage(ChatColor.RED + "Warp " + portal.getName() + " was already set to " + privacy.getColor() + privacy.name().toLowerCase());
                }
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(ChatColor.RED + "Invalid input. Valid privacy options are " + Arrays.toString((Object[])WarpLocation.Privacy.values()));
            }
        }
        return true;
    }

    public boolean export(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.export", sender.isOp())) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        this.plugin.dumpPortalList();
        sender.sendMessage(ChatColor.DARK_AQUA + "Portal list dumped to travelportals.txt.");
        return true;
    }

    public boolean reimport(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.reimport", sender.isOp())) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.DARK_RED + "You must provide a file to import from");
            return true;
        }
        File file = new File(this.plugin.getDataFolder(), args[0]);
        if (!file.exists()) {
            sender.sendMessage(ChatColor.DARK_RED + "File " + args[0] + " not found!");
            return true;
        }
        if (args.length != 2 || !args[1].equals("confirm")) {
            sender.sendMessage(ChatColor.DARK_RED + "This will COMPLETELY ERASE your existing portals!");
            sender.sendMessage(ChatColor.DARK_RED + "If you are sure, type /portal reimport " + args[0] + " confirm");
            return true;
        }
        this.plugin.importPortalList(file);
        sender.sendMessage(ChatColor.DARK_AQUA + "Portals imported successfully. " + this.plugin.getPortalStorage().getPortals().size() + " warps imported");
        return true;
    }

    public boolean deactivate(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.deactivate", sender.isOp())) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.DARK_RED + "You must provide the name of the portal.");
            return true;
        }
        WarpLocation portal = null;
        if (args.length > 0) {
            portal = this.plugin.getPortalStorage().getPortal(args[0]);
        } else if (sender instanceof Player) {
            portal = this.getPortal((Player)sender);
        }
        if (portal == null) {
            sender.sendMessage(ChatColor.DARK_RED + "No portal found.");
            return true;
        }
        this.plugin.getPortalStorage().removePortal(portal);
        this.plugin.getPortalStorage().save(portal);
        sender.sendMessage(ChatColor.DARK_GREEN + "You have successfully removed the portal named \"" + args[0] + "\"");
        return true;
    }

    public boolean info(CommandSender sender, String[] args) {
        WarpLocation destination;
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.command.info")) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        WarpLocation portal = null;
        if (args.length > 0) {
            portal = this.plugin.getPortalStorage().getPortal(args[0]);
        } else if (sender instanceof Player) {
            portal = this.getPortal((Player)sender);
        }
        if (portal == null) {
            sender.sendMessage(ChatColor.DARK_RED + "No portal found.");
            return true;
        }
        String name = portal.getName();
        String dest = portal.getDestination();
        String owner = portal.getOwnerName();
        String world = portal.getWorld();
        if (world == null || world.isEmpty()) {
            world = "(Unknown)";
        }
        if (name.isEmpty()) {
            name = "has no name";
        } else {
            name = "is named " + name;
            if (portal.getPrivacy() != WarpLocation.Privacy.PUBLIC) {
                name = portal.canAccess(sender) ? name + portal.getPrivacy().getColor() + " (" + portal.getPrivacy().name().toLowerCase() + ")" : "is " + portal.getPrivacy().getColor() + portal.getPrivacy().name().toLowerCase();
            }
        }
        WarpLocation warpLocation = destination = dest.isEmpty() ? null : this.plugin.getPortalStorage().getPortal(dest);
        if (destination == null && !dest.isEmpty()) {
            dest = "warps to " + ChatColor.RED + dest + ChatColor.DARK_AQUA + " in world " + ChatColor.RED + world;
        } else if (dest.isEmpty()) {
            dest = "has no destination";
        } else {
            dest = "warps to " + dest + ChatColor.DARK_AQUA + " in world " + destination.getWorld();
            if (destination.getPrivacy() != WarpLocation.Privacy.PUBLIC) {
                name = destination.canAccess(sender) ? name + destination.getPrivacy().getColor() + " (" + destination.getPrivacy().name().toLowerCase() + ")" : "warps to a " + destination.getPrivacy().getColor() + destination.getPrivacy().name().toLowerCase() + ChatColor.DARK_AQUA + " portal";
            }
        }
        owner = owner.isEmpty() ? "This portal does not have an owner. If is yours, claim it with /portal claim." : "It is owned by " + owner + ".";
        sender.sendMessage(ChatColor.DARK_AQUA + "This portal " + name + ChatColor.DARK_AQUA + " and " + dest + ChatColor.DARK_AQUA + ".");
        sender.sendMessage(ChatColor.DARK_AQUA + owner);
        if (this.plugin.permissions.hasPermission(sender, "travelportals.command.info.details", sender.isOp())) {
            sender.sendMessage(ChatColor.DARK_AQUA + "Owner UUID: " + ChatColor.YELLOW + portal.getOwnerId());
            sender.sendMessage(ChatColor.DARK_AQUA + "Portal location: " + ChatColor.YELLOW + portal.getIdentifierString());
            float rotation = 0.0f;
            if (portal.getDoorPosition() > 0) {
                rotation = portal.getDoorPosition() == 1 ? 270.0f : (portal.getDoorPosition() == 2 ? 0.0f : (portal.getDoorPosition() == 3 ? 90.0f : 180.0f));
            }
            sender.sendMessage(ChatColor.DARK_AQUA + "Portal direction: " + ChatColor.YELLOW + portal.getDoorPosition() + "/" + rotation);
            sender.sendMessage(ChatColor.DARK_AQUA + "Destination location: " + ChatColor.YELLOW + (destination != null ? destination.getIdentifierString() : "none"));
        }
        return true;
    }

    public boolean claim(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return this.notAccessibleFromConsole(sender);
        }
        Player player = (Player)sender;
        if (!this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.command.claim")) {
            sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
            return true;
        }
        WarpLocation portal = this.getPortal(player);
        if (portal == null) {
            player.sendMessage(ChatColor.DARK_RED + "No portal found! (You must be near the portal to claim it)");
            return true;
        }
        if (!portal.hasOwner() || this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.claim", player.isOp())) {
            if (args.length > 0) {
                Player newOwner = this.plugin.getServer().getPlayer(args[0]);
                if (newOwner != null) {
                    portal.setOwner(newOwner);
                } else {
                    portal.setOwner(args[0]);
                }
            } else {
                portal.setOwner(player);
            }
            this.plugin.getPortalStorage().save(portal);
            player.sendMessage(ChatColor.DARK_GREEN + "You have successfully claimed this portal" + (args.length > 0 ? " for " + args[0] : "") + "!");
            return true;
        }
        if (!portal.isOwner(player) && !this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.admin.command.claim", player.isOp())) {
            player.sendMessage(ChatColor.DARK_RED + "This portal is already owned by " + portal.getOwnerName() + "!");
            return true;
        }
        portal.setOwner("");
        player.sendMessage(ChatColor.DARK_GREEN + "This portal no longer has an owner.");
        return true;
    }

    public boolean renameworld(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.renameworld", sender.isOp())) {
            return this.noPermissionForAction(sender);
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.DARK_RED + "You need to include the name of the old world and the name of the new world.");
            return true;
        }
        this.plugin.getPortalStorage().renameWorld(args[0], args[1]);
        sender.sendMessage(ChatColor.DARK_GREEN + "The world \"" + args[0] + "\" has been renamed to \"" + args[1] + "\".");
        return true;
    }

    public boolean deleteworld(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.renameworld", sender.isOp())) {
            return this.noPermissionForAction(sender);
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.DARK_RED + "You need to include the name of the deleted world.");
            return true;
        }
        if (args.length < 2 || !args[1].equals("confirm")) {
            sender.sendMessage(ChatColor.DARK_RED + "This will irreversibly delete all portals linked to \"" + args[0] + "\"!");
            sender.sendMessage(ChatColor.DARK_GREEN + "Are you sure you want to do this?");
            sender.sendMessage(ChatColor.DARK_GREEN + "Type " + ChatColor.DARK_RED + "/portal deleteworld " + args[0] + " confirm " + ChatColor.DARK_GREEN + " to delete.");
            return true;
        }
        this.plugin.getPortalStorage().deleteWorld(args[0]);
        sender.sendMessage(ChatColor.DARK_GREEN + "All portals linked to \"" + args[0] + "\" have been deleted.");
        return true;
    }

    public boolean fixworld(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.fixworld", sender.isOp())) {
            return this.noPermissionForAction(sender);
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.DARK_RED + "You need to include the name of a default world to use.");
            return true;
        }
        this.plugin.getPortalStorage().renameWorld("", args[0]);
        sender.sendMessage(ChatColor.DARK_GREEN + "All portals without a saved world now point to world \"" + args[0] + "\"");
        return true;
    }

    public boolean convert(CommandSender sender, String[] args) {
        if (!this.plugin.permissions.hasPermission(sender, "travelportals.admin.command.convert", sender.isOp())) {
            return this.noPermissionForAction(sender);
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.DARK_RED + "Missing arguments. Correct usage: " + ChatColor.RED + "/portal convert from|to " + StorageType.stringValues());
            return true;
        }
        try {
            StorageType input = StorageType.valueOf(args[1].toUpperCase());
            boolean success = false;
            if ("from".equalsIgnoreCase(args[0])) {
                success = this.plugin.convertStorage(this.plugin.createStorage(input), this.plugin.getPortalStorage());
            } else if ("to".equalsIgnoreCase(args[0])) {
                success = this.plugin.convertStorage(this.plugin.getPortalStorage(), this.plugin.createStorage(input));
            } else {
                sender.sendMessage(ChatColor.DARK_RED + "Please either insert " + ChatColor.RED + "from" + ChatColor.DARK_RED + " or " + ChatColor.RED + "to" + ChatColor.DARK_RED + " as a conversion direction!");
                return true;
            }
            if (success) {
                sender.sendMessage(ChatColor.DARK_GREEN + "Converted storage " + args[0].toLowerCase() + " " + (Object)((Object)input) + "!");
            } else {
                sender.sendMessage(ChatColor.DARK_RED + "Error while trying to convert storage " + args[0].toLowerCase() + " " + (Object)((Object)input) + "! Take a look at the console/logs for more info.");
            }
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + args[1] + ChatColor.DARK_RED + " is not a valid storage type. Valid types are " + ChatColor.RED + StorageType.stringValues());
        }
        return true;
    }

    private String substring(String name, int left) {
        while (MinecraftFontWidthCalculator.getStringWidth(name) > left) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private String whitespace(int length) {
        int spaceWidth = MinecraftFontWidthCalculator.getStringWidth(" ");
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < length; i += spaceWidth) {
            ret.append(" ");
        }
        return ret.toString();
    }

    private boolean notAccessibleFromConsole(CommandSender sender) {
        sender.sendMessage("This method is not available from the console.");
        return true;
    }

    private boolean noPermissionForAction(CommandSender sender) {
        sender.sendMessage(ChatColor.DARK_RED + "You do not have permission to use this command.");
        return true;
    }

    private WarpLocation getPortal(Player player) {
        WarpLocation portal = this.plugin.getPortalStorage().getNearbyPortal(player.getTargetBlock(this.getTransparent(), 5).getLocation(), 1);
        if (portal == null) {
            portal = this.plugin.getPortalStorage().getNearbyPortal(player.getLocation(), 1);
        }
        return portal;
    }

    private Set<Material> getTransparent() {
        EnumSet<Material> set = EnumSet.noneOf(Material.class);
        set.addAll(this.plugin.doortypes);
        Collections.addAll(set, Material.AIR, Material.CAVE_AIR, Material.VOID_AIR);
        return set;
    }
}

