/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.General.uuidconverter;

import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.cpprograms.minecraft.General.PluginBase;
import net.cpprograms.minecraft.General.uuidconverter.EssentialsSource;
import net.cpprograms.minecraft.General.uuidconverter.UuidbSource;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class UuidConverter {
    private final PluginBase plugin;
    private static final String MOJANG_API = "https://api.mojang.com/profiles/minecraft";
    private List<Source> sources = new ArrayList<Source>();

    public UuidConverter(PluginBase plugin) {
        this.plugin = plugin;
        if (plugin.getServer().getPluginManager().isPluginEnabled("UUIDDB")) {
            this.sources.add(new UuidbSource(plugin));
        }
        if (plugin.getServer().getPluginManager().isPluginEnabled("Essentials")) {
            this.sources.add(new EssentialsSource(plugin));
        }
    }

    public Map<String, UUID> getUuidMap(Collection<String> usernames) {
        this.plugin.logInfo("Converting " + usernames.size() + " usernames to UUIDs...");
        HashMap<String, UUID> map = new HashMap<String, UUID>();
        ArrayList<String> manualConvert = new ArrayList<String>();
        if (this.sources.isEmpty()) {
            manualConvert.addAll(usernames);
        } else {
            int i = 0;
            for (String username : usernames) {
                Source source;
                if (++i % 100 == 0) {
                    this.plugin.logInfo(i + "...");
                }
                UUID uuid = null;
                Iterator<Source> iterator = this.sources.iterator();
                while (iterator.hasNext() && (uuid = (source = iterator.next()).getUUID(username)) == null) {
                }
                if (uuid != null) {
                    map.put(username, uuid);
                    continue;
                }
                manualConvert.add(username);
            }
        }
        if (!manualConvert.isEmpty()) {
            JSONParser jsonParser = new JSONParser();
            this.plugin.logInfo("Only " + map.size() + " of " + usernames.size() + " found. Contacting Mojang for the rest (" + manualConvert.size() + ")...");
            int i = 0;
            while ((double)i < Math.ceil((double)manualConvert.size() / 100.0)) {
                try {
                    if (i > 0) {
                        Thread.sleep(100L);
                        this.plugin.logInfo(i * 100 + "...");
                    }
                    HttpURLConnection connection = this.createConnection();
                    String body = JSONArray.toJSONString(manualConvert.subList(i * 100, Math.min(manualConvert.size(), (i + 1) * 100)));
                    this.writeBody(connection, body);
                    JSONArray profiles = (JSONArray)jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream()));
                    for (Object profile : profiles) {
                        JSONObject jsonProfile = (JSONObject)profile;
                        try {
                            map.put((String)jsonProfile.get((Object)"name"), this.parseUuid((String)jsonProfile.get((Object)"id")));
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.logWarning("Invalid UUID (" + jsonProfile.get((Object)"id") + ") for " + jsonProfile.get((Object)"name"));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        this.plugin.logInfo("Converted " + map.size() + "/" + usernames.size() + " usernames to UUIDs!");
        return map;
    }

    private void writeBody(HttpURLConnection connection, String body) throws Exception {
        OutputStream stream = connection.getOutputStream();
        stream.write(body.getBytes());
        stream.flush();
        stream.close();
    }

    private HttpURLConnection createConnection() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(MOJANG_API).openConnection();
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    private UUID parseUuid(String id) {
        return UUID.fromString(id.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }

    public static interface Source {
        public UUID getUUID(String var1);
    }
}

