/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.General;

import java.util.logging.Level;
import net.cpprograms.minecraft.General.CommandHandler;
import net.cpprograms.minecraft.General.PermissionsHandler;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginBase
extends JavaPlugin {
    String pluginName = "";
    String pluginVersion = "";
    boolean debugMode = false;
    boolean useConfig = true;
    public PermissionsHandler permissions;
    public CommandHandler commandHandler;

    public void onLoad() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.pluginName = pdfFile.getName();
        this.pluginVersion = pdfFile.getVersion();
        this.permissions = new PermissionsHandler();
        if (this.useConfig && !this.loadConfig()) {
            this.logSevere("Could not load configuration for " + this.getPluginName() + "! This may break the plugin!");
        }
    }

    public void onEnable() {
        this.commandHandler = new CommandHandler();
        this.showLoadedMessage();
    }

    public void onDisable() {
        this.showUnloadedMessage();
    }

    public void showLoadedMessage() {
        this.logInfo(this.pluginName + " version " + this.pluginVersion + " is enabled!");
        this.logDebug("Debugging mode is active.");
    }

    public void showUnloadedMessage() {
        this.logInfo(this.pluginName + " version " + this.pluginVersion + " has been disabled.");
    }

    public void logWarning(String message) {
        this.log(message, Level.WARNING);
    }

    public void logInfo(String message) {
        this.log(message, Level.INFO);
    }

    public void logSevere(String message) {
        this.log(message, Level.SEVERE);
    }

    public void logDebug(String message) {
        if (this.debugMode) {
            this.log(message, Level.INFO);
        }
    }

    public boolean isDebugging() {
        return this.debugMode;
    }

    public void log(String message, Level level) {
        this.getLogger().log(level, message);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.commandHandler.HandleCommand(sender, command, label, args);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getVersion() {
        return this.pluginVersion;
    }

    protected boolean loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        if (this.getConfig().contains("debug")) {
            this.debugMode = this.getConfig().getBoolean("debug");
        }
        return true;
    }

    public ChunkGenerator getDefaultWorldGenerator(String name, String id) {
        return super.getDefaultWorldGenerator(name, id);
    }
}

