/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.cpprograms.minecraft.General.uuidconverter.UuidConverter;
import net.cpprograms.minecraft.TravelPortals.TravelPortals;
import net.cpprograms.minecraft.TravelPortals.WarpLocation;
import net.cpprograms.minecraft.TravelPortals.storage.StorageType;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class PortalStorage {
    protected final TravelPortals plugin;
    private Map<String, WarpLocation> portals = new LinkedHashMap<String, WarpLocation>();
    private Map<String, String> portalNames = new LinkedHashMap<String, String>();
    private Map<String, String> portalLocations = new LinkedHashMap<String, String>();
    private Set<String> namesToConvert = new HashSet<String>();

    protected PortalStorage(TravelPortals plugin) {
        this.plugin = plugin;
    }

    public abstract boolean load();

    public abstract boolean save(WarpLocation var1);

    public abstract boolean save(String var1);

    public abstract boolean save();

    public abstract StorageType getType();

    public void update() {
        if (!this.plugin.shouldUseUuid() || this.namesToConvert.isEmpty()) {
            return;
        }
        Map<String, UUID> uuidMap = new UuidConverter(this.plugin).getUuidMap(this.namesToConvert);
        if (uuidMap.isEmpty()) {
            return;
        }
        int i = 0;
        for (WarpLocation portal : this.getPortals().values()) {
            UUID id;
            if (portal.hasOwnerId() || (id = uuidMap.get(portal.getOwnerName())) == null) continue;
            portal.setOwnerId(id);
            ++i;
        }
        this.plugin.logInfo(i + " portals updated! Found " + uuidMap.size() + " of " + this.namesToConvert.size() + " missing names.");
        this.save();
    }

    public Map<String, WarpLocation> getPortals() {
        return this.portals;
    }

    public void addPortal(WarpLocation portal) {
        WarpLocation previous = this.portals.put(portal.getIdentifierString(), portal);
        if (previous != null && !portal.hasName()) {
            portal.setName(previous.getName());
        }
        if (portal.hasName()) {
            this.portalNames.put(portal.getName().toLowerCase(), portal.getIdentifierString());
        }
        this.portalLocations.put(portal.getWorld() + "," + portal.getX() + "," + portal.getY() + "," + portal.getZ(), portal.getIdentifierString());
        this.portalLocations.put(portal.getWorld() + "," + portal.getX() + "," + portal.getY() + 1 + "," + portal.getZ(), portal.getIdentifierString());
        if (this.plugin.shouldUseUuid() && !portal.hasOwnerId()) {
            this.namesToConvert.add(portal.getOwnerName());
        }
    }

    public WarpLocation getPortal(String name) {
        String identifier = this.portalNames.get(name.toLowerCase());
        if (identifier == null) {
            return null;
        }
        return this.portals.get(identifier);
    }

    public WarpLocation getPortal(Location location) {
        String portalIdentifier = this.portalLocations.get(location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ());
        if (portalIdentifier == null) {
            portalIdentifier = this.portalLocations.get("," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ());
        }
        if (portalIdentifier != null) {
            if (this.portals.containsKey(portalIdentifier)) {
                return this.portals.get(portalIdentifier);
            }
            this.portalLocations.remove(portalIdentifier);
        }
        return null;
    }

    public Collection<WarpLocation> getNearbyPortals(Location location, int radius) {
        WarpLocation exact = this.getPortal(location);
        if (exact != null) {
            return Collections.singletonList(exact);
        }
        HashSet<WarpLocation> nearbyPortals = new HashSet<WarpLocation>();
        Location loopLocation = location.clone();
        loopLocation.subtract((double)radius, (double)radius, (double)radius);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    WarpLocation portal = this.getPortal(loopLocation);
                    if (portal != null) {
                        nearbyPortals.add(portal);
                    }
                    loopLocation.add(0.0, 1.0, 0.0);
                }
                loopLocation.subtract(0.0, (double)(2 * radius + 1), 0.0);
                loopLocation.add(0.0, 0.0, 1.0);
            }
            loopLocation.subtract(0.0, 0.0, (double)(2 * radius + 1));
            loopLocation.add(1.0, 0.0, 0.0);
        }
        return nearbyPortals;
    }

    public WarpLocation getNearbyPortal(Location location, int radius) {
        Collection<WarpLocation> nearbyPortals = this.getNearbyPortals(location, radius);
        if (nearbyPortals.size() == 1) {
            return nearbyPortals.iterator().next();
        }
        if (!nearbyPortals.isEmpty()) {
            WarpLocation closest = null;
            int closestDist = -1;
            for (WarpLocation portal : nearbyPortals) {
                int distance = Math.abs((location.getBlockX() - portal.getX()) * (location.getBlockY() - portal.getY()) * (location.getBlockZ() - portal.getZ()));
                if (closest != null && closestDist <= distance) continue;
                closest = portal;
                closestDist = distance;
            }
            return closest;
        }
        return null;
    }

    public Collection<WarpLocation> getPlayerPortals(Player player) {
        return this.getPlayerPortalsForWorld(player, null);
    }

    public Collection<WarpLocation> getPlayerPortalsForWorld(Player player, World world) {
        HashSet<WarpLocation> playerPortals = new HashSet<WarpLocation>();
        for (Map.Entry<String, WarpLocation> portal : this.portals.entrySet()) {
            if (!portal.getValue().isOwner(player) || world != null && !portal.getValue().getWorld().equals(world.getName())) continue;
            playerPortals.add(portal.getValue());
        }
        return playerPortals;
    }

    public void namePortal(WarpLocation portal, String name) {
        this.removePortal(portal);
        portal.setName(name);
        this.addPortal(portal);
        this.save(portal);
    }

    public void removePortal(WarpLocation portal) {
        this.portals.remove(portal.getIdentifierString());
        this.portalNames.remove(portal.getName().toLowerCase());
        this.portalLocations.remove(portal.getWorld() + "," + portal.getX() + "," + portal.getY() + "," + portal.getZ());
        this.portalLocations.remove(portal.getWorld() + "," + portal.getX() + "," + portal.getY() + 1 + "," + portal.getZ());
    }

    public boolean renameWorld(String oldWorld, String newWorld) {
        for (WarpLocation portal : this.portals.values()) {
            if (!oldWorld.equalsIgnoreCase(portal.getWorld())) continue;
            portal.setWorld(newWorld);
        }
        return this.save(newWorld);
    }

    public boolean deleteWorld(String world) {
        HashSet<WarpLocation> toDelete = new HashSet<WarpLocation>();
        for (WarpLocation portal : this.portals.values()) {
            if (!world.equalsIgnoreCase(portal.getWorld())) continue;
            toDelete.add(portal);
        }
        toDelete.forEach(this::removePortal);
        return this.save(world);
    }

    public void clearCache() {
        this.portals.clear();
        this.portalLocations.clear();
    }
}

