/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals;

import java.util.HashMap;
import java.util.Map;
import net.cpprograms.minecraft.TravelPortals.TravelPortals;
import net.cpprograms.minecraft.TravelPortals.WarpLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PortalUseTask
implements Runnable {
    int taskId = -1;
    TravelPortals plugin;
    Map<String, Location> lastDestinations = new HashMap<String, Location>();

    public PortalUseTask(TravelPortals plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        if (this.taskId == -1) {
            return;
        }
        Server server = Bukkit.getServer();
        int n = 0;
        for (Player player : server.getOnlinePlayers()) {
            WarpLocation portal = this.isInPortal(player);
            String playerName = player.getName();
            if (portal == null) {
                this.lastDestinations.remove(playerName);
                continue;
            }
            if (!portal.isUsable(this.plugin.cooldown)) {
                ++n;
                continue;
            }
            String destName = portal.getDestination();
            if (destName == null) {
                this.lastDestinations.remove(playerName);
            } else {
                Location lastTarget = this.lastDestinations.get(playerName);
                if (lastTarget != null && this.sameLoc(lastTarget, player.getLocation())) {
                    ++n;
                    continue;
                }
                WarpLocation targetW = this.plugin.getPortalStorage().getPortal(destName);
                if (targetW == null) {
                    this.lastDestinations.remove(playerName);
                } else {
                    World world = this.plugin.getServer().getWorld(targetW.getWorld());
                    if (world == null) continue;
                    this.lastDestinations.put(playerName, new Location(world, 0.5 + (double)targetW.getX(), (double)targetW.getY(), 0.5 + (double)targetW.getZ()));
                }
            }
            ++n;
            if (this.plugin.followTicks > 0) {
                server.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new FollowTask(this, playerName, portal));
                continue;
            }
            Location warpTo = this.plugin.getWarpLocationIfAllowed(player);
            if (warpTo == null) continue;
            this.plugin.teleportToWarp(player, warpTo);
        }
        if (n == 0) {
            this.lastDestinations.clear();
        }
    }

    private boolean sameLoc(Location l1, Location l2) {
        return l1.getWorld().equals((Object)l2.getWorld()) && l1.getBlockX() == l2.getBlockX() && l1.getBlockY() == l2.getBlockY() && l1.getBlockZ() == l2.getBlockZ();
    }

    private WarpLocation isInPortal(Player player) {
        if (!this.plugin.permissions.hasPermission((CommandSender)player, "travelportals.portal.use")) {
            return null;
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        Material blockType = world.getBlockAt(playerLoc).getType();
        if (blockType == this.plugin.portaltype || blockType == this.plugin.blocktype || this.plugin.doortypes.contains(blockType)) {
            return this.plugin.getPortalStorage().getPortal(playerLoc);
        }
        return null;
    }

    private void checkPlayer(String playerName, WarpLocation w) {
        Location loc;
        Player player = Bukkit.getServer().getPlayer(playerName);
        if (player == null) {
            return;
        }
        if (this.isInPortal(player) == w && w.isUsable(this.plugin.cooldown) && (loc = this.plugin.getWarpLocationIfAllowed(player)) != null) {
            this.plugin.teleportToWarp(player, loc);
        }
    }

    public boolean register() {
        if (this.taskId != -1) {
            this.cancel();
        }
        int mainTicks = this.plugin.mainTicks;
        int followTicks = this.plugin.followTicks;
        if (mainTicks <= 0) {
            mainTicks = 23;
        }
        if (mainTicks <= followTicks) {
            mainTicks = Math.max(23, followTicks + 3);
        }
        this.taskId = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, (long)mainTicks, (long)mainTicks);
        return this.taskId != -1;
    }

    public void cancel() {
        if (this.taskId != -1) {
            Bukkit.getServer().getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
        }
    }

    public int getTaskId() {
        return this.taskId;
    }

    class FollowTask
    implements Runnable {
        PortalUseTask useTask;
        String playerName;
        WarpLocation w;

        public FollowTask(PortalUseTask plugin, String playerName, WarpLocation w) {
            this.useTask = plugin;
            this.playerName = playerName;
            this.w = w;
        }

        @Override
        public void run() {
            this.useTask.checkPlayer(this.playerName, this.w);
        }
    }
}

