/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals.storage;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.cpprograms.minecraft.TravelPortals.TravelPortals;
import net.cpprograms.minecraft.TravelPortals.WarpLocation;
import net.cpprograms.minecraft.TravelPortals.storage.PortalStorage;
import net.cpprograms.minecraft.TravelPortals.storage.StorageType;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlStorage
extends PortalStorage {
    private final File worldsFolder;

    public YamlStorage(TravelPortals plugin) {
        super(plugin);
        this.worldsFolder = new File(plugin.getDataFolder(), "worlds");
    }

    @Override
    public boolean load() {
        try {
            if (!(this.worldsFolder.exists() && this.worldsFolder.isDirectory() || this.worldsFolder.mkdirs())) {
                this.plugin.logSevere("Could not create worlds folder!");
                return false;
            }
        }
        catch (SecurityException e) {
            this.plugin.logSevere("Could not read/write TravelPortals data folder!");
            return false;
        }
        for (File portalFile : this.worldsFolder.listFiles(file -> file.isFile())) {
            String worldName = Files.getNameWithoutExtension((String)portalFile.getName());
            if (this.plugin.getServer().getWorld(worldName) == null) {
                this.plugin.logWarning("A world with the name " + worldName + " does not exist? Loading the portals anyways!");
            }
            for (Map portalMap : YamlConfiguration.loadConfiguration((File)portalFile).getMapList("portals")) {
                try {
                    this.addPortal(WarpLocation.deserialize(portalMap));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.logSevere("Could not load portal at " + portalMap.get("x") + " " + portalMap.get("y") + " " + portalMap.get("z") + " " + portalMap.get("world") + ":  " + e.getMessage());
                }
            }
        }
        return true;
    }

    @Override
    public boolean save(WarpLocation portal) {
        return this.save(portal.getWorld());
    }

    @Override
    public boolean save() {
        boolean success = true;
        for (World world : this.plugin.getServer().getWorlds()) {
            success = this.save(world.getName()) && success;
        }
        return success;
    }

    @Override
    public StorageType getType() {
        return StorageType.YAML;
    }

    @Override
    public boolean save(String worldName) {
        ArrayList<Map<String, Object>> portalList = new ArrayList<Map<String, Object>>();
        for (WarpLocation portal : this.getPortals().values()) {
            if (!worldName.equalsIgnoreCase(portal.getWorld())) continue;
            portalList.add(portal.serialize());
        }
        if (portalList.isEmpty()) {
            return this.deleteWorldFile(worldName);
        }
        YamlConfiguration worldConfig = new YamlConfiguration();
        worldConfig.set("portals", portalList);
        try {
            worldConfig.save(new File(this.worldsFolder, worldName + ".yml"));
        }
        catch (IOException e) {
            this.plugin.logWarning("Could not save the portals of world " + worldName + " to the config file! " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean renameWorld(String oldWorld, String newWorld) {
        super.renameWorld(oldWorld, newWorld);
        this.deleteWorldFile(oldWorld);
        return false;
    }

    private boolean deleteWorldFile(String world) {
        File oldConfigFile = this.getIgnoreCaseFile(this.worldsFolder, world + ".yml");
        if (oldConfigFile == null) {
            this.plugin.logDebug("Could not remove " + world + ".yml as it doesn't seem to exist? ");
            return false;
        }
        return oldConfigFile.delete();
    }

    private File getIgnoreCaseFile(File path, String fileName) {
        File correctCase = new File(path, fileName);
        if (correctCase.exists()) {
            return correctCase;
        }
        for (File file : this.worldsFolder.listFiles(pathName -> pathName.isFile())) {
            if (!file.getName().equalsIgnoreCase(fileName)) continue;
            return file;
        }
        return null;
    }
}

