/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;

public class WarpLocation
implements ConfigurationSerializable {
    private int x;
    private int y;
    private int z;
    private String name;
    private String destination;
    private transient long lastused;
    private Privacy privacy = Privacy.PUBLIC;
    private String ownerName = "";
    private UUID ownerId = null;
    private int doorpos = 0;
    private String world = "";

    public WarpLocation() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.name = "";
        this.lastused = 0L;
        this.world = "";
    }

    public WarpLocation(int _x, int _y, int _z, String _world) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.name = "";
        this.destination = "";
        this.lastused = 0L;
        this.world = _world;
    }

    public WarpLocation(int _x, int _y, int _z, int _doorpos, String _world) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.name = "";
        this.destination = "";
        this.lastused = 0L;
        this.doorpos = _doorpos;
        this.world = _world;
    }

    public WarpLocation(int _x, int _y, int _z, int _doorpos, String _world, String _owner) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.name = "";
        this.destination = "";
        this.lastused = 0L;
        this.doorpos = _doorpos;
        this.world = _world;
        this.setOwner(_owner);
    }

    public WarpLocation(int _x, int _y, int _z, int _doorpos, String _world, Player _owner) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.name = "";
        this.destination = "";
        this.lastused = 0L;
        this.doorpos = _doorpos;
        this.world = _world;
        this.setOwner(_owner);
    }

    public boolean isValid() {
        return this.name == null || !this.name.isEmpty() || this.destination == null || !this.destination.isEmpty();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean isOwner(Player player) {
        return this.hasOwnerId() ? player.getUniqueId().equals(this.getOwnerId()) : player.getName().equals(this.getOwnerName());
    }

    @Deprecated
    public String getOwner() {
        return this.getOwnerName() + (this.hasOwnerId() ? "," + this.getOwnerId() : "");
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String _ownerName) {
        this.ownerName = _ownerName;
    }

    public void setOwner(Player player) {
        if (player == null) {
            this.ownerName = null;
            this.ownerId = null;
        } else {
            this.ownerName = player.getName();
            this.ownerId = player.getUniqueId();
        }
    }

    @Deprecated
    public void setOwner(String _owner) {
        if (_owner.contains(",")) {
            String[] parts = _owner.split(",");
            this.ownerName = parts[0];
            this.ownerId = parts.length > 1 ? UUID.fromString(parts[1]) : null;
        } else {
            this.ownerName = _owner;
            this.ownerId = null;
        }
    }

    public boolean hasOwner() {
        return this.ownerId != null || this.ownerName != null && !this.ownerName.isEmpty();
    }

    public boolean hasOwnerId() {
        return this.ownerId != null;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(UUID _ownerId) {
        this.ownerId = _ownerId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String n) {
        this.destination = n;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public long getLastUsed() {
        return this.lastused;
    }

    public void setLastUsed() {
        this.lastused = System.currentTimeMillis();
    }

    public void setLastUsed(long time) {
        this.lastused = time;
    }

    public int getDoorPosition() {
        return this.doorpos;
    }

    public void setDoorPosition(int dp) {
        this.doorpos = dp;
    }

    @Deprecated
    public void setHidden(boolean dp) {
        this.setPrivacy(dp ? Privacy.HIDDEN : Privacy.PUBLIC);
    }

    @Deprecated
    public boolean isHidden() {
        return this.getPrivacy() != Privacy.PUBLIC;
    }

    public void setPrivacy(Privacy p) {
        this.privacy = p;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String w) {
        this.world = w;
    }

    public String getIdentifierString() {
        return this.world + "," + this.x + "," + this.y + "," + this.z;
    }

    public boolean isUsable(int cooldown) {
        return this.lastused + (long)cooldown < System.currentTimeMillis();
    }

    public boolean canSee(CommandSender sender) {
        return this.getPrivacy() == Privacy.PUBLIC || this.canAccess(sender);
    }

    public boolean canAccess(CommandSender sender) {
        return !this.hasOwner() || !(sender instanceof Player) || this.isOwner((Player)sender);
    }

    public static WarpLocation deserialize(Map<?, ?> map) throws IllegalArgumentException {
        WarpLocation portal = new WarpLocation((Integer)map.get("x"), (Integer)map.get("y"), (Integer)map.get("z"), (String)map.get("world"));
        if (map.containsKey("name")) {
            portal.setName((String)map.get("name"));
        }
        if (map.containsKey("owner")) {
            portal.setOwner((String)map.get("owner"));
        }
        if (map.containsKey("owner-name")) {
            portal.setOwnerName((String)map.get("owner-name"));
        }
        if (map.containsKey("owner-id")) {
            portal.setOwnerId(UUID.fromString((String)map.get("owner-id")));
        }
        if (map.containsKey("destination")) {
            portal.setDestination((String)map.get("destination"));
        }
        if (map.containsKey("hidden")) {
            portal.setPrivacy(Privacy.HIDDEN);
        }
        if (map.containsKey("privacy")) {
            portal.setPrivacy(Privacy.valueOf(((String)map.get("privacy")).toUpperCase()));
        }
        if (map.containsKey("direction")) {
            portal.setDoorPosition((Integer)map.get("direction"));
        }
        return portal;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("x", this.getX());
        map.put("y", this.getY());
        map.put("z", this.getZ());
        map.put("world", this.getWorld());
        if (this.hasName()) {
            map.put("name", this.getName());
        }
        if (this.getOwnerName() != null) {
            map.put("owner-name", this.getOwnerName());
        }
        if (this.hasOwnerId()) {
            map.put("owner-id", this.getOwnerId().toString());
        }
        if (this.hasDestination()) {
            map.put("destination", this.getDestination());
        }
        if (this.getPrivacy() != Privacy.PUBLIC) {
            map.put("privacy", this.getPrivacy().name());
        }
        if (this.getDoorPosition() != 0) {
            map.put("direction", this.getDoorPosition());
        }
        return map;
    }

    public String toString() {
        return "WarpLocation{name=" + this.getName() + ",world=" + this.getWorld() + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",destination=" + this.getDestination() + ",ownerName=" + this.getOwnerName() + ",ownerId=" + this.getOwnerId() + ",privacy=" + (Object)((Object)this.getPrivacy()) + ",direction=" + this.getDoorPosition();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum Privacy {
        PUBLIC(ChatColor.DARK_AQUA),
        HIDDEN(ChatColor.BLUE),
        PRIVATE(ChatColor.AQUA);

        private final ChatColor color;

        private Privacy(ChatColor color) {
            this.color = color;
        }

        public ChatColor getColor() {
            return this.color;
        }
    }
}

