/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals;

import net.cpprograms.minecraft.TravelPortals.TravelPortals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class TravelPortalsDrownListener
implements Listener {
    private final TravelPortals plugin;

    public TravelPortalsDrownListener(TravelPortals instance) {
        this.plugin = instance;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerAirChange(EntityAirChangeEvent event) {
        if (!(event.getEntity() instanceof Player) || ((Player)event.getEntity()).getMaximumAir() != ((Player)event.getEntity()).getRemainingAir()) {
            return;
        }
        if (this.plugin.getPortalStorage().getNearbyPortals(event.getEntity().getLocation(), 1).isEmpty()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDrowning(EntityDamageEvent event) {
        if (event.getEntityType() != EntityType.PLAYER || event.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
            return;
        }
        if (this.plugin.getPortalStorage().getNearbyPortals(event.getEntity().getLocation(), 1).isEmpty()) {
            return;
        }
        event.setCancelled(true);
    }
}

