/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals;

import net.cpprograms.minecraft.TravelPortals.TravelPortals;
import net.cpprograms.minecraft.TravelPortals.WarpLocation;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class TravelPortalsBlockListener
implements Listener {
    private final TravelPortals plugin;

    public TravelPortalsBlockListener(TravelPortals plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getBlock().getType() == this.plugin.torchtype) {
            if (!this.plugin.permissions.hasPermission((CommandSender)event.getPlayer(), "travelportals.portal.create")) {
                return;
            }
            Player player = event.getPlayer();
            int numwalls = 0;
            int x = event.getBlock().getX();
            int y = event.getBlock().getY();
            int z = event.getBlock().getZ();
            int doordir = 0;
            int maxPortals = -1;
            int currPortalsNum = 0;
            if (!this.plugin.permissions.hasPermission((CommandSender)event.getPlayer(), "travelportals.portal.create.nolimit")) {
                maxPortals = this.plugin.permissions.getNumVal((CommandSender)event.getPlayer(), "travelportals.portal.create");
                int n = currPortalsNum = this.plugin.maxportalsperworld ? this.plugin.getPortalStorage().getPlayerPortalsForWorld(player, event.getBlock().getWorld()).size() : this.plugin.getPortalStorage().getPlayerPortals(player).size();
            }
            if (player.getWorld().getBlockAt(x + 1, y, z).getType() == this.plugin.blocktype && player.getWorld().getBlockAt(x + 1, y + 1, z).getType() == this.plugin.blocktype) {
                ++numwalls;
            } else if (this.plugin.doortypes.contains(player.getWorld().getBlockAt(x + 1, y, z).getType()) && this.plugin.doortypes.contains(player.getWorld().getBlockAt(x + 1, y + 1, z).getType())) {
                numwalls += 10;
                doordir = 1;
            }
            if (player.getWorld().getBlockAt(x - 1, y, z).getType() == this.plugin.blocktype && player.getWorld().getBlockAt(x - 1, y + 1, z).getType() == this.plugin.blocktype) {
                ++numwalls;
            } else if (this.plugin.doortypes.contains(player.getWorld().getBlockAt(x - 1, y, z).getType()) && this.plugin.doortypes.contains(player.getWorld().getBlockAt(x - 1, y + 1, z).getType())) {
                numwalls += 10;
                doordir = 3;
            }
            if (player.getWorld().getBlockAt(x, y, z + 1).getType() == this.plugin.blocktype && player.getWorld().getBlockAt(x, y + 1, z + 1).getType() == this.plugin.blocktype) {
                ++numwalls;
            } else if (this.plugin.doortypes.contains(player.getWorld().getBlockAt(x, y, z + 1).getType()) && this.plugin.doortypes.contains(player.getWorld().getBlockAt(x, y + 1, z + 1).getType())) {
                numwalls += 10;
                doordir = 2;
            }
            if (player.getWorld().getBlockAt(x, y, z - 1).getType() == this.plugin.blocktype && player.getWorld().getBlockAt(x, y + 1, z - 1).getType() == this.plugin.blocktype) {
                ++numwalls;
            } else if (this.plugin.doortypes.contains(player.getWorld().getBlockAt(x, y, z - 1).getType()) && this.plugin.doortypes.contains(player.getWorld().getBlockAt(x, y + 1, z - 1).getType())) {
                numwalls += 10;
                doordir = 4;
            }
            if (numwalls == 13 && player.getWorld().getBlockAt(x, y + 1, z).getType() == Material.AIR) {
                if (maxPortals >= 0 && currPortalsNum >= maxPortals) {
                    player.sendMessage(ChatColor.DARK_RED + "You've reached your portal limit and can't create new portals.");
                    return;
                }
                player.getWorld().getBlockAt(x, y, z).setType(this.plugin.portaltype);
                player.getWorld().getBlockAt(x, y + 1, z).setType(this.plugin.portaltype);
                if (this.plugin.portalCreateSound != null) {
                    event.getBlock().getWorld().playSound(event.getBlock().getLocation(), this.plugin.portalCreateSound, SoundCategory.BLOCKS, (float)this.plugin.portalCreateSoundVolume, 1.0f);
                }
                player.sendMessage(ChatColor.DARK_RED + "You have created a portal! Type /portal help for help using it.");
                if (maxPortals >= 0) {
                    player.sendMessage(ChatColor.DARK_RED + "You can build " + (maxPortals - ++currPortalsNum) + " more portals");
                }
                WarpLocation portal = new WarpLocation(x, y, z, doordir, player.getWorld().getName(), player);
                portal.setPrivacy(this.plugin.defaultPrivacy);
                this.plugin.getPortalStorage().addPortal(portal);
                if (!this.plugin.getPortalStorage().save(portal)) {
                    player.sendMessage(ChatColor.RED + "Error while saving your portal! Please contact an admin!");
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().getType() == this.plugin.blocktype || this.plugin.doortypes.contains(event.getBlock().getType())) {
            Player player = event.getPlayer();
            Block block = event.getBlock();
            for (WarpLocation w : this.plugin.getPortalStorage().getNearbyPortals(event.getBlock().getLocation(), 2)) {
                if ((Math.abs(w.getX() - block.getX()) >= 2 || Math.abs(w.getZ() - block.getZ()) >= 1) && (Math.abs(w.getZ() - block.getZ()) >= 2 || Math.abs(w.getX() - block.getX()) >= 1) || block.getY() - w.getY() >= 2 || block.getY() - w.getY() < 0) continue;
                if (this.plugin.usepermissions) {
                    if (!this.plugin.permissions.hasPermission((CommandSender)event.getPlayer(), "travelportals.portal.destroy")) {
                        event.setCancelled(true);
                        return;
                    }
                    if (!w.isOwner(player) && !this.plugin.permissions.hasPermission((CommandSender)event.getPlayer(), "travelportals.admin.portal.destroy")) {
                        event.setCancelled(true);
                        return;
                    }
                }
                player.getWorld().getBlockAt(w.getX(), w.getY(), w.getZ()).setType(Material.AIR);
                player.getWorld().getBlockAt(w.getX(), w.getY() + 1, w.getZ()).setType(Material.AIR);
                this.plugin.getPortalStorage().removePortal(w);
                this.plugin.getPortalStorage().save(w);
                player.sendMessage(ChatColor.DARK_RED + "You just broke a portal.");
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (event.getFace() != BlockFace.DOWN) {
            return;
        }
        if (event.getBlock().getType() != this.plugin.portaltype) {
            return;
        }
        if (this.plugin.getPortalStorage().getPortal(event.getBlock().getLocation()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        if (event.getBlock().getType() != this.plugin.portaltype) {
            return;
        }
        if (this.plugin.getPortalStorage().getPortal(event.getBlock().getLocation()) != null) {
            event.setCancelled(true);
        }
    }
}

