/*
 * Decompiled with CFR 0.152.
 */
package net.cpprograms.minecraft.TravelPortals;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.cpprograms.minecraft.General.CommandHandler;
import net.cpprograms.minecraft.General.PermissionsHandler;
import net.cpprograms.minecraft.General.PluginBase;
import net.cpprograms.minecraft.TravelPortals.PortalCommandSet;
import net.cpprograms.minecraft.TravelPortals.PortalUseTask;
import net.cpprograms.minecraft.TravelPortals.TravelPortalsBlockListener;
import net.cpprograms.minecraft.TravelPortals.TravelPortalsDrownListener;
import net.cpprograms.minecraft.TravelPortals.TravelPortalsPlayerListener;
import net.cpprograms.minecraft.TravelPortals.WarpLocation;
import net.cpprograms.minecraft.TravelPortals.paperlib.PaperLib;
import net.cpprograms.minecraft.TravelPortals.storage.PortalStorage;
import net.cpprograms.minecraft.TravelPortals.storage.StorageType;
import net.cpprograms.minecraft.TravelPortals.storage.YamlStorage;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TravelPortals
extends PluginBase {
    private TravelPortalsPlayerListener playerListener = null;
    private final TravelPortalsBlockListener blockListener = new TravelPortalsBlockListener(this);
    private final TravelPortalsDrownListener drownListener = new TravelPortalsDrownListener(this);
    private boolean useUuid = false;
    protected PortalStorage portalStorage;
    protected WarpLocation.Privacy defaultPrivacy = WarpLocation.Privacy.PUBLIC;
    protected Material blocktype = Material.OBSIDIAN;
    protected String strBlocktype = "obsidian";
    private boolean autoExport = false;
    public static Server server;
    protected Material portaltype = Material.WATER;
    protected Set<Material> doortypes = EnumSet.of(Material.OAK_DOOR, new Material[]{Material.IRON_DOOR, Material.ACACIA_DOOR, Material.BIRCH_DOOR, Material.DARK_OAK_DOOR, Material.JUNGLE_DOOR, Material.SPRUCE_DOOR});
    protected String strDoortype = "door";
    protected String strTorchtype = "redstone torch";
    protected Material torchtype = Material.REDSTONE_TORCH;
    protected Sound portalCreateSound = Sound.BLOCK_PORTAL_TRIGGER;
    protected double portalCreateSoundVolume = 1.0;
    protected Sound portalAmbientSound = Sound.BLOCK_PORTAL_AMBIENT;
    protected double portalAmbientSoundVolume = 1.0;
    protected Sound portalTravelSound = Sound.BLOCK_PORTAL_TRAVEL;
    protected double portalTravelSoundVolume = 0.5;
    protected boolean usepermissions = false;
    protected boolean crossWorldPortals = true;
    protected int cooldown = 5000;
    private int numsaves = 3;
    protected int mainTicks = 17;
    protected int followTicks = 7;
    protected boolean usePlayerMove = true;
    private PortalUseTask useTask = null;
    protected boolean maxportalsperworld = false;

    @Override
    public void onEnable() {
        server = this.getServer();
        if (!this.load()) {
            this.logSevere("Aborting plugin load");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.portalStorage.update();
        this.getServer().getPluginManager().registerEvents((Listener)this.blockListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.drownListener, (Plugin)this);
        super.onEnable();
        this.permissions = new PermissionsHandler(this.usepermissions);
        this.commandHandler = new CommandHandler(this, PortalCommandSet.class);
    }

    public boolean load() {
        try {
            StorageType storageType;
            FileConfiguration conf = this.getConfig();
            if (conf.get("storagetype", null) != null) {
                try {
                    storageType = StorageType.valueOf(conf.getString("storagetype").toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    if (conf.getString("storagetype").equalsIgnoreCase("LEGACY")) {
                        this.logSevere("The legacy storage format is no longer supported! Please downgrade to 2.4 and convert your storage to YAML!");
                    } else {
                        this.logSevere(conf.getString("storagetype") + " is not a valid storage type? Valid types are " + Arrays.toString((Object[])StorageType.values()) + ".");
                    }
                    return false;
                }
            } else {
                this.logSevere("The legacy storage format is no longer supported! Please downgrade to 2.4 and convert your storage to YAML!");
                return false;
            }
            this.logDebug("Storage type is " + (Object)((Object)storageType));
            this.useUuid = conf.getBoolean("use-uuids", false);
            try {
                this.portalStorage = this.createStorage(storageType);
            }
            catch (IllegalArgumentException e) {
                this.logSevere(e.getMessage());
            }
            try {
                this.defaultPrivacy = WarpLocation.Privacy.valueOf(conf.getString("default-privacy").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.logSevere(e.getMessage());
            }
            if (conf.get("frame", null) != null) {
                this.blocktype = Material.valueOf((String)conf.getString("frame").toUpperCase());
            }
            if (conf.get("framename", null) != null) {
                this.strBlocktype = conf.getString("framename");
            }
            if (conf.get("fill", null) != null) {
                this.portaltype = Material.valueOf((String)conf.getString("fill").toUpperCase());
            }
            if (conf.get("doorlist", null) != null) {
                ArrayList<Material> doorList = new ArrayList<Material>();
                for (String doorType : conf.getStringList("doorlist")) {
                    Material door = Material.matchMaterial((String)doorType);
                    if (door != null) {
                        doorList.add(door);
                        continue;
                    }
                    this.logWarning("Unknown door type in 'doorlist' config: " + doorType);
                }
                if (!doorList.isEmpty()) {
                    this.doortypes = EnumSet.copyOf(doorList);
                }
            } else {
                if (conf.get("door", null) != null) {
                    this.doortypes.add(Material.valueOf((String)conf.getString("door").toUpperCase()));
                }
                if (conf.get("door2", null) != null) {
                    this.doortypes.add(Material.valueOf((String)conf.getString("door2").toUpperCase()));
                }
                this.logWarning("Old style door configuration found. Config loaded correctly, but you may want to update it.");
                this.logWarning("The plugin now supports a list \"doorlist\", to allow use of the new wooden door types.");
                this.logWarning("Example configuration here: https://gh.nes.science/TravelPortals/blob/master/config.yml");
            }
            if (conf.get("doorname", null) != null) {
                this.strDoortype = conf.getString("doorname");
            }
            if (conf.get("torch", null) != null) {
                this.torchtype = Material.valueOf((String)conf.getString("torch").toUpperCase());
            }
            if (conf.get("torchname", null) != null) {
                this.strTorchtype = conf.getString("torchname");
            }
            if (conf.isConfigurationSection("sounds")) {
                this.portalCreateSound = this.getSound(conf.getString("sounds.create"));
                this.portalCreateSoundVolume = conf.getDouble("sounds.create-volume");
                this.portalAmbientSound = this.getSound(conf.getString("sounds.ambient"));
                this.portalAmbientSoundVolume = conf.getDouble("sounds.ambient-volume");
                this.portalTravelSound = this.getSound(conf.getString("sounds.travel"));
                this.portalTravelSoundVolume = conf.getDouble("sounds.travel-volume");
            }
            if (conf.get("permissions", null) != null) {
                this.usepermissions = conf.getBoolean("permissions");
            }
            if (conf.get("cross-world-portals", null) != null) {
                this.crossWorldPortals = conf.getBoolean("cross-world-portals");
            }
            if (conf.get("autoexport", null) != null) {
                this.autoExport = conf.getBoolean("autoexport");
            }
            if (conf.get("cooldown", null) != null) {
                this.cooldown = 1000 * conf.getInt("cooldown");
            }
            if (conf.get("numsaves", null) != null) {
                this.numsaves = conf.getInt("numsaves");
            }
            if (conf.get("useplayermove", null) != null) {
                this.usePlayerMove = conf.getBoolean("useplayermove");
            }
            if (conf.get("polling-mainticks", null) != null) {
                this.mainTicks = conf.getInt("polling-mainticks");
            }
            if (conf.get("polling-followticks", null) != null) {
                this.followTicks = conf.getInt("polling-followticks");
            }
            if (conf.get("maxportalsperworld", null) != null) {
                this.maxportalsperworld = conf.getBoolean("maxportalsperworld");
            }
        }
        catch (NumberFormatException i) {
            this.logSevere("An exception occurred when trying to read your config file. " + i.getMessage());
            this.logSevere("Check your config.yml!");
        }
        catch (IllegalArgumentException e) {
            this.logSevere("An exception occurred when trying to read a block type from your config file. " + e.getMessage());
            this.logSevere("Check your config.yml!");
        }
        if (!this.portalStorage.load()) {
            return false;
        }
        this.logInfo("Loaded " + this.portalStorage.getPortals().size() + " portals!");
        if (this.playerListener != null) {
            this.playerListener.unregister();
            this.playerListener = null;
        }
        if (this.useTask != null) {
            this.useTask.cancel();
            this.useTask = null;
        }
        if (this.usePlayerMove) {
            this.logDebug("Using player move event listener");
            this.playerListener = new TravelPortalsPlayerListener(this);
            this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        } else {
            this.logDebug("Using portal use task");
            this.useTask = new PortalUseTask(this);
            if (!this.useTask.register()) {
                this.logSevere("Failed to register portal use task. Falling back to old PlayerMove style.");
                this.playerListener = new TravelPortalsPlayerListener(this);
                this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
                this.useTask = null;
            }
        }
        this.permissions = new PermissionsHandler(this.usepermissions);
        return true;
    }

    private Sound getSound(String name) {
        try {
            return Sound.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            if (!name.isEmpty()) {
                this.logWarning(name + " is not a valid sound!");
            }
            return null;
        }
    }

    @Override
    public void onDisable() {
        this.getPortalStorage().save();
        super.onDisable();
    }

    @Deprecated
    public void savedata() {
        this.portalStorage.save();
    }

    @Deprecated
    public WarpLocation getWarp(String name) {
        return this.portalStorage.getPortal(name);
    }

    @Deprecated
    public WarpLocation getWarpFromLocation(Location location) {
        return this.portalStorage.getNearbyPortal(location, 1);
    }

    @Deprecated
    public void renameWorld(String oldWorld, String newWorld) {
        this.portalStorage.renameWorld(oldWorld, newWorld);
    }

    @Deprecated
    public void deleteWorld(String oldWorld) {
        this.portalStorage.deleteWorld(oldWorld);
    }

    public void dumpPortalList() {
        try {
            FileOutputStream fOut = new FileOutputStream(new File(this.getDataFolder(), "travelportals.txt"));
            PrintStream pOut = new PrintStream(fOut);
            for (WarpLocation w : this.portalStorage.getPortals().values()) {
                pOut.println(w.getX() + "," + w.getY() + "," + w.getZ() + "," + w.getName() + "," + w.getDestination() + "," + w.getPrivacy().name() + "," + w.getWorld() + "," + w.getOwnerName() + "," + w.getOwnerId());
            }
            pOut.close();
            fOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void importPortalList(File file) {
        try {
            String line;
            this.portalStorage.clearCache();
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String[] data = line.split(",", 8);
                if (data.length != 8) continue;
                WarpLocation warp = new WarpLocation(Integer.parseInt(data[0]), Integer.parseInt(data[1]), Integer.parseInt(data[2]), 0, data[6], data[7]);
                if ("1".equals(data[5]) || "true".equals(data[5])) {
                    warp.setPrivacy(WarpLocation.Privacy.HIDDEN);
                } else if ("0".equals(data[5]) || "false".equals(data[5])) {
                    warp.setPrivacy(WarpLocation.Privacy.PUBLIC);
                } else {
                    try {
                        warp.setPrivacy(WarpLocation.Privacy.valueOf(data[5]));
                    }
                    catch (IllegalArgumentException e) {
                        this.logSevere(e.getMessage());
                    }
                }
                warp.setDestination(data[4]);
                warp.setName(data[3]);
                this.portalStorage.addPortal(warp);
            }
            this.portalStorage.save();
            br.close();
        }
        catch (Exception e) {
            this.logSevere("Unable to load portal list from " + file.getName() + "!");
            this.logDebug(e.getMessage());
        }
    }

    public boolean convertStorage(PortalStorage from, PortalStorage to) {
        if (from.load()) {
            for (WarpLocation portal : from.getPortals().values()) {
                to.addPortal(portal);
            }
            return to.save();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Location getWarpLocationIfAllowed(Player player, Location location, boolean disablePortal) {
        if (!this.permissions.hasPermission((CommandSender)player, "travelportals.portal.use")) {
            return null;
        }
        Material blockType = player.getWorld().getBlockAt(location).getType();
        if (blockType != this.portaltype && blockType != this.blocktype && !this.doortypes.contains(blockType)) {
            return null;
        }
        WarpLocation portal = this.portalStorage.getPortal(location);
        if (portal == null) {
            return null;
        }
        if (!portal.isUsable(this.cooldown)) {
            return null;
        }
        if (this.usepermissions) {
            if (!this.permissions.hasPermission((CommandSender)player, "travelportals.portal.use")) {
                player.sendMessage(ChatColor.DARK_RED + "You do not have permission to use portals.");
                return null;
            }
            if (!portal.isOwner(player) && !this.permissions.hasPermission((CommandSender)player, "travelportals.admin.portal.use")) {
                player.sendMessage(ChatColor.DARK_RED + "You do not own this portal, so you cannot use it.");
                return null;
            }
        }
        if (!portal.hasDestination()) {
            if (!this.permissions.hasPermission((CommandSender)player, "travelportals.command.warp") || !portal.isOwner(player)) {
                player.sendMessage(ChatColor.DARK_RED + "This portal has no destination.");
            } else {
                player.sendMessage(ChatColor.DARK_RED + "You need to set this portal's destination first!");
                player.sendMessage(ChatColor.DARK_GREEN + "See /portal help for more information.");
            }
            portal.setLastUsed();
            return null;
        }
        WarpLocation destination = this.portalStorage.getPortal(portal.getDestination());
        if (destination == null) {
            player.sendMessage(ChatColor.DARK_RED + "This portal's destination (" + portal.getDestination() + ") does not exist.");
            if (!this.permissions.hasPermission((CommandSender)player, "travelportals.command.warp")) {
                player.sendMessage(ChatColor.DARK_GREEN + "See /portal help for more information.");
            }
            portal.setLastUsed();
            return null;
        }
        if (!(this.crossWorldPortals || destination.getWorld().isEmpty() || player.getWorld().getName().equals(destination.getWorld()) || this.permissions.hasPermission((CommandSender)player, "travelportals.portal.use.crossworld", false))) {
            player.sendMessage(ChatColor.DARK_RED + "You cannot travel between worlds.");
            return null;
        }
        if (!this.permissions.hasPermission((CommandSender)player, "travelportals.admin.portal.use") && !destination.isOwner(player)) {
            player.sendMessage(ChatColor.DARK_RED + "You do not own the destination portal, and do not have permission to use it.");
            return null;
        }
        int x = destination.getX();
        int y = destination.getY();
        int z = destination.getZ();
        float rotation = 180.0f;
        int d = destination.getDoorPosition();
        if (d > 0) {
            rotation = d == 1 ? 270.0f : (d == 2 ? 0.0f : (d == 3 ? 90.0f : 180.0f));
        } else if (this.doortypes.contains(location.getWorld().getBlockAt(x + 1, y, z).getType())) {
            rotation = 270.0f;
            destination.setDoorPosition(1);
        } else if (this.doortypes.contains(location.getWorld().getBlockAt(x, y, z + 1).getType())) {
            rotation = 0.0f;
            destination.setDoorPosition(2);
        } else if (this.doortypes.contains(location.getWorld().getBlockAt(x - 1, y, z).getType())) {
            rotation = 90.0f;
            destination.setDoorPosition(3);
        } else if (this.doortypes.contains(location.getWorld().getBlockAt(x, y, z - 1).getType())) {
            rotation = 180.0f;
            destination.setDoorPosition(4);
        }
        Location locy = new Location(location.getWorld(), (double)x + 0.5, (double)y + 0.1, (double)z + 0.5, rotation, 0.0f);
        if (destination.getWorld() != null && !destination.getWorld().equals("")) {
            World wo = this.getServer().getWorld(destination.getWorld());
            if (wo == null) {
                this.logWarning("World " + destination.getWorld() + " for portal " + destination.getName() + " was not found! - consider running the following command from the console:");
                this.logWarning("portal fixworld " + ((World)server.getWorlds().get(0)).getName());
                this.logWarning("Replacing the world name with the world this portal should link to, if it is incorrect.");
                return null;
            }
            locy.setWorld(wo);
        } else {
            this.logWarning("World name not set for portal " + destination.getName() + " - consider running the following command from the console:");
            this.logWarning("portal fixworld " + ((World)server.getWorlds().get(0)).getName());
            this.logWarning("Replacing the world name with the world this portal should link to, if it is incorrect.");
            locy.setWorld((World)server.getWorlds().get(0));
        }
        if (disablePortal) {
            destination.setLastUsed();
            portal.setLastUsed();
        }
        this.logDebug(player.getName() + " entered portal " + portal.getName() + " at " + portal.getIdentifierString() + " which warps to " + destination.getName() + " at " + destination.getIdentifierString());
        return locy;
    }

    public void teleportToWarp(Player player, Location warp) {
        if (warp.getWorld() == null) {
            player.sendMessage(ChatColor.RED + "Target portal does not have a world set!");
            return;
        }
        if (!warp.getWorld().getWorldBorder().isInside(warp)) {
            player.sendMessage(ChatColor.RED + "Target portal is outside of the world border!");
            return;
        }
        if (this.portalAmbientSound != null) {
            player.getWorld().playSound(player.getLocation(), this.portalAmbientSound, SoundCategory.AMBIENT, (float)this.portalAmbientSoundVolume, 1.0f);
        }
        Location to = warp.clone();
        ((CompletableFuture)PaperLib.getChunkAtAsync(warp, false).thenAccept(chunk -> {
            Block block = to.getBlock();
            if (block.getType().isSolid() || block.getRelative(BlockFace.UP).getType().isSolid()) {
                player.sendMessage(ChatColor.RED + "Target portal is obstructed!");
                return;
            }
            if (this.portalAmbientSound != null) {
                to.getWorld().playSound(to, this.portalAmbientSound, SoundCategory.AMBIENT, (float)this.portalAmbientSoundVolume, 1.0f);
            }
            Block below = block.getRelative(BlockFace.DOWN);
            player.sendBlockChange(below.getLocation(), below.getType().isSolid() ? below.getBlockData() : Material.BEDROCK.createBlockData());
            PaperLib.teleportAsync((Entity)player, to).thenAccept(success -> {
                if (success.booleanValue()) {
                    if (this.portalTravelSound != null) {
                        player.playSound(to, this.portalTravelSound, SoundCategory.BLOCKS, (float)this.portalTravelSoundVolume, 1.0f);
                    }
                    this.logDebug("Teleported " + player.getName() + " to " + to);
                } else {
                    player.sendMessage(ChatColor.RED + "Error while teleporting!");
                    this.getLogger().log(Level.SEVERE, "Unable to teleport " + player.getName() + " to " + to);
                }
            });
        })).exceptionally(ex -> {
            player.sendMessage(ChatColor.RED + "Error while teleporting: " + ex.getMessage());
            this.getLogger().log(Level.SEVERE, "Error while loading chunk to teleport " + player.getName() + " to " + to, (Throwable)ex);
            return null;
        });
    }

    public Location getWarpLocationIfAllowed(Player player) {
        return this.getWarpLocationIfAllowed(player, true);
    }

    public Location getWarpLocationIfAllowed(Player player, boolean disablePortal) {
        return this.getWarpLocationIfAllowed(player, player.getLocation(), disablePortal);
    }

    public Location getWarpLocationIfAllowed(Player player, Location location) {
        return this.getWarpLocationIfAllowed(player, location, true);
    }

    public boolean isAutoExport() {
        return this.autoExport;
    }

    public boolean shouldUseUuid() {
        return this.useUuid;
    }

    public int getNumSaves() {
        return this.numsaves;
    }

    public PortalStorage getPortalStorage() {
        return this.portalStorage;
    }

    public PortalStorage createStorage(StorageType type) throws IllegalArgumentException {
        switch (type) {
            case YAML: {
                return new YamlStorage(this);
            }
        }
        throw new IllegalArgumentException("The storage type " + (Object)((Object)type) + " is not properly supported yet! Please choose a different one!");
    }
}

