/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lucko.spark.paper.proto.SparkSamplerProtos;

public interface ThreadGrouper {
    public static final ThreadGrouper BY_NAME = new ThreadGrouper(){

        @Override
        public String getGroup(long threadId, String threadName) {
            return threadName;
        }

        @Override
        public String getLabel(String group) {
            return group;
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto() {
            return SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_NAME;
        }
    };
    public static final ThreadGrouper BY_POOL = new ThreadGrouper(){
        private final Pattern pattern = Pattern.compile("^(.*?)[-# ]+\\d+$");
        private final Map<Long, String> cache = new ConcurrentHashMap<Long, String>();
        private final Map<String, Set<Long>> seen = new ConcurrentHashMap<String, Set<Long>>();

        @Override
        public String getGroup(long threadId, String threadName) {
            String cached = this.cache.get(threadId);
            if (cached != null) {
                return cached;
            }
            Matcher matcher = this.pattern.matcher(threadName);
            if (!matcher.matches()) {
                return threadName;
            }
            String group = matcher.group(1).trim();
            this.cache.put(threadId, group);
            this.seen.computeIfAbsent(group, g -> ConcurrentHashMap.newKeySet()).add(threadId);
            return group;
        }

        @Override
        public String getLabel(String group) {
            int count = this.seen.getOrDefault(group, Collections.emptySet()).size();
            if (count == 0) {
                return group;
            }
            return group + " (x" + count + ")";
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto() {
            return SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_POOL;
        }
    };
    public static final ThreadGrouper AS_ONE = new ThreadGrouper(){
        private final Set<Long> seen = ConcurrentHashMap.newKeySet();

        @Override
        public String getGroup(long threadId, String threadName) {
            this.seen.add(threadId);
            return "root";
        }

        @Override
        public String getLabel(String group) {
            return "All (x" + this.seen.size() + ")";
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto() {
            return SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.AS_ONE;
        }
    };

    public String getGroup(long var1, String var3);

    public String getLabel(String var1);

    public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto();

    public static ThreadGrouper parseConfigSetting(String setting) {
        switch (setting) {
            case "as-one": {
                return AS_ONE;
            }
            case "by-name": {
                return BY_NAME;
            }
        }
        return BY_POOL;
    }
}

