/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.heapdump;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.command.sender.CommandSender;
import me.lucko.spark.paper.lib.asm.Type;
import me.lucko.spark.paper.proto.SparkHeapProtos;

public final class HeapDumpSummary {
    private static final String DIAGNOSTIC_BEAN = "com.sun.management:type=DiagnosticCommand";
    private static final Pattern OUTPUT_FORMAT = Pattern.compile("^\\s*(\\d+):\\s*(\\d+)\\s*(\\d+)\\s*([^\\s]+).*$");
    private final List<Entry> entries;

    private static String getRawHeapData() throws Exception {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName diagnosticBeanName = ObjectName.getInstance(DIAGNOSTIC_BEAN);
        DiagnosticCommandMXBean proxy = JMX.newMXBeanProxy(beanServer, diagnosticBeanName, DiagnosticCommandMXBean.class);
        return proxy.gcClassHistogram(new String[0]);
    }

    private static String typeToClassName(String type) {
        try {
            return Type.getType(type).getClassName();
        }
        catch (IllegalArgumentException e) {
            return type;
        }
    }

    public static HeapDumpSummary createNew() {
        String rawOutput;
        try {
            rawOutput = HeapDumpSummary.getRawHeapData();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get heap dump", e);
        }
        return new HeapDumpSummary(Arrays.stream(rawOutput.split("\n")).map(line -> {
            Matcher matcher = OUTPUT_FORMAT.matcher((CharSequence)line);
            if (!matcher.matches()) {
                return null;
            }
            try {
                return new Entry(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Long.parseLong(matcher.group(3)), HeapDumpSummary.typeToClassName(matcher.group(4)));
            }
            catch (Exception e) {
                new IllegalArgumentException("Exception parsing line: " + line, e).printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private HeapDumpSummary(List<Entry> entries) {
        this.entries = entries;
    }

    public SparkHeapProtos.HeapData toProto(SparkPlatform platform, CommandSender.Data creator) {
        SparkHeapProtos.HeapMetadata.Builder metadata = SparkHeapProtos.HeapMetadata.newBuilder().setPlatformMetadata(platform.getPlugin().getPlatformInfo().toData().toProto()).setCreator(creator.toProto());
        try {
            metadata.setPlatformStatistics(platform.getStatisticsProvider().getPlatformStatistics(null, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            metadata.setSystemStatistics(platform.getStatisticsProvider().getSystemStatistics());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SparkHeapProtos.HeapData.Builder proto = SparkHeapProtos.HeapData.newBuilder();
        proto.setMetadata(metadata);
        for (Entry entry : this.entries) {
            proto.addEntries(entry.toProto());
        }
        return (SparkHeapProtos.HeapData)proto.build();
    }

    public static interface DiagnosticCommandMXBean {
        public String gcClassHistogram(String[] var1);
    }

    public static final class Entry {
        private final int order;
        private final int instances;
        private final long bytes;
        private final String type;

        Entry(int order, int instances, long bytes, String type) {
            this.order = order;
            this.instances = instances;
            this.bytes = bytes;
            this.type = type;
        }

        public int getOrder() {
            return this.order;
        }

        public int getInstances() {
            return this.instances;
        }

        public long getBytes() {
            return this.bytes;
        }

        public String getType() {
            return this.type;
        }

        public SparkHeapProtos.HeapEntry toProto() {
            return (SparkHeapProtos.HeapEntry)SparkHeapProtos.HeapEntry.newBuilder().setOrder(this.order).setInstances(this.instances).setSize(this.bytes).setType(this.type).build();
        }
    }
}

