/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.lucko.spark.paper.common.SparkPlugin;
import me.lucko.spark.paper.common.activitylog.ActivityLog;
import me.lucko.spark.paper.common.api.SparkApi;
import me.lucko.spark.paper.common.command.Arguments;
import me.lucko.spark.paper.common.command.Command;
import me.lucko.spark.paper.common.command.CommandModule;
import me.lucko.spark.paper.common.command.CommandResponseHandler;
import me.lucko.spark.paper.common.command.modules.ActivityLogModule;
import me.lucko.spark.paper.common.command.modules.GcMonitoringModule;
import me.lucko.spark.paper.common.command.modules.HealthModule;
import me.lucko.spark.paper.common.command.modules.HeapAnalysisModule;
import me.lucko.spark.paper.common.command.modules.SamplerModule;
import me.lucko.spark.paper.common.command.modules.TickMonitoringModule;
import me.lucko.spark.paper.common.command.sender.CommandSender;
import me.lucko.spark.paper.common.command.tabcomplete.CompletionSupplier;
import me.lucko.spark.paper.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.paper.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.paper.common.monitor.memory.GarbageCollectorStatistics;
import me.lucko.spark.paper.common.monitor.net.NetworkMonitor;
import me.lucko.spark.paper.common.monitor.ping.PingStatistics;
import me.lucko.spark.paper.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.paper.common.monitor.tick.SparkTickStatistics;
import me.lucko.spark.paper.common.monitor.tick.TickStatistics;
import me.lucko.spark.paper.common.platform.PlatformStatisticsProvider;
import me.lucko.spark.paper.common.sampler.BackgroundSamplerManager;
import me.lucko.spark.paper.common.sampler.SamplerContainer;
import me.lucko.spark.paper.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.paper.common.tick.TickHook;
import me.lucko.spark.paper.common.tick.TickReporter;
import me.lucko.spark.paper.common.util.BytebinClient;
import me.lucko.spark.paper.common.util.Configuration;
import me.lucko.spark.paper.common.util.SparkStaticLogger;
import me.lucko.spark.paper.common.util.TemporaryFiles;
import me.lucko.spark.paper.common.util.classfinder.ClassFinder;
import me.lucko.spark.paper.common.ws.TrustedKeyStore;
import me.lucko.spark.paper.lib.bytesocks.BytesocksClient;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class SparkPlatform {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");
    private final SparkPlugin plugin;
    private final TemporaryFiles temporaryFiles;
    private final Configuration configuration;
    private final String viewerUrl;
    private final BytebinClient bytebinClient;
    private final BytesocksClient bytesocksClient;
    private final TrustedKeyStore trustedKeyStore;
    private final boolean disableResponseBroadcast;
    private final List<CommandModule> commandModules;
    private final List<Command> commands;
    private final ReentrantLock commandExecuteLock = new ReentrantLock(true);
    private final ActivityLog activityLog;
    private final SamplerContainer samplerContainer;
    private final BackgroundSamplerManager backgroundSamplerManager;
    private final TickHook tickHook;
    private final TickReporter tickReporter;
    private final TickStatistics tickStatistics;
    private final PingStatistics pingStatistics;
    private final PlatformStatisticsProvider statisticsProvider;
    private Map<String, GarbageCollectorStatistics> startupGcStatistics = ImmutableMap.of();
    private long serverNormalOperationStartTime;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public SparkPlatform(SparkPlugin plugin) {
        this.plugin = plugin;
        SparkStaticLogger.setLogger(plugin::log);
        this.temporaryFiles = new TemporaryFiles(this.plugin.getPluginDirectory().resolve("tmp"));
        this.configuration = new Configuration(this.plugin.getPluginDirectory().resolve("config.json"));
        this.viewerUrl = this.configuration.getString("viewerUrl", "https://spark.lucko.me/");
        String bytebinUrl = this.configuration.getString("bytebinUrl", "https://spark-usercontent.lucko.me/");
        String bytesocksHost = this.configuration.getString("bytesocksHost", "spark-usersockets.lucko.me");
        this.bytebinClient = new BytebinClient(bytebinUrl, "spark-plugin");
        this.bytesocksClient = BytesocksClient.create(bytesocksHost, "spark-plugin");
        this.trustedKeyStore = new TrustedKeyStore(this.configuration);
        this.disableResponseBroadcast = this.configuration.getBoolean("disableResponseBroadcast", false);
        this.commandModules = ImmutableList.of((Object)new SamplerModule(), (Object)new HealthModule(), (Object)new TickMonitoringModule(), (Object)new GcMonitoringModule(), (Object)new HeapAnalysisModule(), (Object)new ActivityLogModule());
        ImmutableList.Builder commandsBuilder = ImmutableList.builder();
        for (CommandModule module : this.commandModules) {
            module.registerCommands(arg_0 -> ((ImmutableList.Builder)commandsBuilder).add(arg_0));
        }
        this.commands = commandsBuilder.build();
        this.activityLog = new ActivityLog(plugin.getPluginDirectory().resolve("activity.json"));
        this.activityLog.load();
        this.samplerContainer = new SamplerContainer();
        this.backgroundSamplerManager = new BackgroundSamplerManager(this, this.configuration);
        TickStatistics tickStatistics = plugin.createTickStatistics();
        this.tickHook = plugin.createTickHook();
        this.tickReporter = plugin.createTickReporter();
        if (tickStatistics == null && (this.tickHook != null || this.tickReporter != null)) {
            tickStatistics = new SparkTickStatistics();
        }
        this.tickStatistics = tickStatistics;
        PlayerPingProvider pingProvider = plugin.createPlayerPingProvider();
        this.pingStatistics = pingProvider != null ? new PingStatistics(pingProvider) : null;
        this.statisticsProvider = new PlatformStatisticsProvider(this);
    }

    public void enable() {
        if (!this.enabled.compareAndSet(false, true)) {
            throw new RuntimeException("Platform has already been enabled!");
        }
        if (this.tickHook != null && this.tickStatistics instanceof SparkTickStatistics) {
            this.tickHook.addCallback((TickHook.Callback)((Object)this.tickStatistics));
            this.tickHook.start();
        }
        if (this.tickReporter != null && this.tickStatistics instanceof SparkTickStatistics) {
            this.tickReporter.addCallback((TickReporter.Callback)((Object)this.tickStatistics));
            this.tickReporter.start();
        }
        if (this.pingStatistics != null) {
            this.pingStatistics.start();
        }
        CpuMonitor.ensureMonitoring();
        NetworkMonitor.ensureMonitoring();
        this.plugin.executeAsync(() -> {
            this.startupGcStatistics = GarbageCollectorStatistics.pollStats();
            this.serverNormalOperationStartTime = System.currentTimeMillis();
        });
        SparkApi api = new SparkApi(this);
        this.plugin.registerApi(api);
        SparkApi.register(api);
        this.backgroundSamplerManager.initialise();
    }

    public void disable() {
        if (this.tickHook != null) {
            this.tickHook.close();
        }
        if (this.tickReporter != null) {
            this.tickReporter.close();
        }
        if (this.pingStatistics != null) {
            this.pingStatistics.close();
        }
        for (CommandModule module : this.commandModules) {
            module.close();
        }
        this.samplerContainer.close();
        SparkApi.unregister();
        this.temporaryFiles.deleteTemporaryFiles();
    }

    public SparkPlugin getPlugin() {
        return this.plugin;
    }

    public TemporaryFiles getTemporaryFiles() {
        return this.temporaryFiles;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getViewerUrl() {
        return this.viewerUrl;
    }

    public BytebinClient getBytebinClient() {
        return this.bytebinClient;
    }

    public BytesocksClient getBytesocksClient() {
        return this.bytesocksClient;
    }

    public TrustedKeyStore getTrustedKeyStore() {
        return this.trustedKeyStore;
    }

    public boolean shouldBroadcastResponse() {
        return !this.disableResponseBroadcast;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public ActivityLog getActivityLog() {
        return this.activityLog;
    }

    public SamplerContainer getSamplerContainer() {
        return this.samplerContainer;
    }

    public BackgroundSamplerManager getBackgroundSamplerManager() {
        return this.backgroundSamplerManager;
    }

    public TickHook getTickHook() {
        return this.tickHook;
    }

    public TickReporter getTickReporter() {
        return this.tickReporter;
    }

    public PlatformStatisticsProvider getStatisticsProvider() {
        return this.statisticsProvider;
    }

    public ClassSourceLookup createClassSourceLookup() {
        return this.plugin.createClassSourceLookup();
    }

    public ClassFinder createClassFinder() {
        return this.plugin.createClassFinder();
    }

    public TickStatistics getTickStatistics() {
        return this.tickStatistics;
    }

    public PingStatistics getPingStatistics() {
        return this.pingStatistics;
    }

    public Map<String, GarbageCollectorStatistics> getStartupGcStatistics() {
        return this.startupGcStatistics;
    }

    public long getServerNormalOperationStartTime() {
        return this.serverNormalOperationStartTime;
    }

    public Path resolveSaveFile(String prefix, String extension) {
        Path pluginFolder = this.plugin.getPluginDirectory();
        try {
            Files.createDirectories(pluginFolder, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pluginFolder.resolve(prefix + "-" + DATE_TIME_FORMATTER.format(LocalDateTime.now()) + "." + extension);
    }

    private List<Command> getAvailableCommands(CommandSender sender) {
        if (sender.hasPermission("spark")) {
            return this.commands;
        }
        return this.commands.stream().filter(c -> sender.hasPermission("spark." + c.primaryAlias())).collect(Collectors.toList());
    }

    public boolean hasPermissionForAnyCommand(CommandSender sender) {
        return !this.getAvailableCommands(sender).isEmpty();
    }

    public void executeCommand(CommandSender sender, String[] args) {
        AtomicReference executorThread = new AtomicReference();
        AtomicReference timeoutThread = new AtomicReference();
        AtomicBoolean completed = new AtomicBoolean(false);
        this.plugin.executeAsync(() -> {
            executorThread.set(Thread.currentThread());
            this.commandExecuteLock.lock();
            try {
                this.executeCommand0(sender, args);
            }
            catch (Exception e) {
                this.plugin.log(Level.SEVERE, "Exception occurred whilst executing a spark command");
                e.printStackTrace();
            }
            finally {
                this.commandExecuteLock.unlock();
                executorThread.set(null);
                completed.set(true);
                Thread timeout = (Thread)timeoutThread.get();
                if (timeout != null) {
                    timeout.interrupt();
                }
            }
        });
        this.plugin.executeAsync(() -> {
            timeoutThread.set(Thread.currentThread());
            int warningIntervalSeconds = 5;
            try {
                for (int i = 1; i <= 3; ++i) {
                    try {
                        Thread.sleep(warningIntervalSeconds * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (completed.get()) {
                        return;
                    }
                    Thread executor = (Thread)executorThread.get();
                    if (executor == null) {
                        this.getPlugin().log(Level.WARNING, "A command execution has not completed after " + i * warningIntervalSeconds + " seconds but there is no executor present. Perhaps the executor shutdown?");
                        this.getPlugin().log(Level.WARNING, "If the command subsequently completes without any errors, this warning should be ignored. :)");
                        continue;
                    }
                    String stackTrace = Arrays.stream(executor.getStackTrace()).map(el -> "  " + el.toString()).collect(Collectors.joining("\n"));
                    this.getPlugin().log(Level.WARNING, "A command execution has not completed after " + i * warningIntervalSeconds + " seconds, it *might* be stuck. Trace: \n" + stackTrace);
                    this.getPlugin().log(Level.WARNING, "If the command subsequently completes without any errors, this warning should be ignored. :)");
                }
            }
            finally {
                timeoutThread.set(null);
            }
        });
    }

    private void executeCommand0(CommandSender sender, String[] args) {
        CommandResponseHandler resp = new CommandResponseHandler(this, sender);
        List<Command> commands = this.getAvailableCommands(sender);
        if (commands.isEmpty()) {
            resp.replyPrefixed((Component)Component.text((String)"You do not have permission to use this command.", (TextColor)NamedTextColor.RED));
            return;
        }
        if (args.length == 0) {
            resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"spark", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text((String)("v" + this.getPlugin().getVersion()), (TextColor)NamedTextColor.GRAY))).build());
            String helpCmd = "/" + this.getPlugin().getCommandName() + " help";
            resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"Run "))).append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(helpCmd).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand((String)helpCmd))).build())).append((Component)Component.text((String)" to view usage information."))).build());
            return;
        }
        ArrayList<String> rawArgs = new ArrayList<String>(Arrays.asList(args));
        String alias = rawArgs.remove(0).toLowerCase();
        for (Command command : commands) {
            if (!command.aliases().contains(alias)) continue;
            resp.setCommandPrimaryAlias(command.primaryAlias());
            try {
                command.executor().execute(this, sender, resp, new Arguments(rawArgs, command.allowSubCommand()));
            }
            catch (Arguments.ParseException e) {
                resp.replyPrefixed((Component)Component.text((String)e.getMessage(), (TextColor)NamedTextColor.RED));
            }
            return;
        }
        this.sendUsage(commands, resp);
    }

    public List<String> tabCompleteCommand(CommandSender sender, String[] args) {
        List<Command> commands = this.getAvailableCommands(sender);
        if (commands.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        if (args.length <= 1) {
            List<String> mainCommands = commands.stream().map(Command::primaryAlias).collect(Collectors.toList());
            return TabCompleter.create().at(0, CompletionSupplier.startsWith(mainCommands)).complete(arguments);
        }
        String alias = (String)arguments.remove(0);
        for (Command command : commands) {
            if (!command.aliases().contains(alias)) continue;
            return command.tabCompleter().completions(this, sender, arguments);
        }
        return Collections.emptyList();
    }

    private void sendUsage(List<Command> commands, CommandResponseHandler sender) {
        sender.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"spark", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text((String)("v" + this.getPlugin().getVersion()), (TextColor)NamedTextColor.GRAY))).build());
        for (Command command : commands) {
            String usage = "/" + this.getPlugin().getCommandName() + " " + command.primaryAlias();
            if (command.allowSubCommand()) {
                Map argumentsBySubCommand = command.arguments().stream().collect(Collectors.groupingBy(Command.ArgumentInfo::subCommandName, LinkedHashMap::new, Collectors.toList()));
                argumentsBySubCommand.forEach((subCommand, arguments) -> {
                    String subCommandUsage = usage + " " + subCommand;
                    sender.reply((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)">", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(subCommandUsage).color((TextColor)NamedTextColor.GRAY)).clickEvent(ClickEvent.suggestCommand((String)subCommandUsage))).build())).build());
                    for (Command.ArgumentInfo arg : arguments) {
                        if (arg.argumentName().isEmpty()) continue;
                        sender.reply(arg.toComponent("      "));
                    }
                });
                continue;
            }
            sender.reply((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)">", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(usage).color((TextColor)NamedTextColor.GRAY)).clickEvent(ClickEvent.suggestCommand((String)usage))).build())).build());
            for (Command.ArgumentInfo arg : command.arguments()) {
                sender.reply(arg.toComponent("    "));
            }
        }
        sender.reply((Component)Component.empty());
        sender.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"For full usage information, please go to: "))).append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("https://spark.lucko.me/docs/Command-Usage").color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.openUrl((String)"https://spark.lucko.me/docs/Command-Usage"))).build())).build());
    }
}

