/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.monitor.cpu;

import java.util.regex.Pattern;
import me.lucko.spark.paper.common.monitor.LinuxProc;
import me.lucko.spark.paper.common.monitor.MacosSysctl;
import me.lucko.spark.paper.common.monitor.WindowsWmic;

public final class CpuInfo
extends Enum<CpuInfo> {
    private static final Pattern SPACE_COLON_SPACE_PATTERN;
    private static final /* synthetic */ CpuInfo[] $VALUES;

    public static CpuInfo[] values() {
        return (CpuInfo[])$VALUES.clone();
    }

    public static CpuInfo valueOf(String name) {
        return Enum.valueOf(CpuInfo.class, name);
    }

    public static String queryCpuModel() {
        for (String line : LinuxProc.CPUINFO.read()) {
            String[] splitLine = SPACE_COLON_SPACE_PATTERN.split(line);
            if (!splitLine[0].equals("model name") && !splitLine[0].equals("Processor")) continue;
            return splitLine[1];
        }
        for (String line : WindowsWmic.CPU_GET_NAME.read()) {
            if (!line.startsWith("Name")) continue;
            return line.substring(5).trim();
        }
        for (String line : MacosSysctl.SYSCTL.read()) {
            if (!line.startsWith("machdep.cpu.brand_string:")) continue;
            return line.substring("machdep.cpu.brand_string:".length()).trim();
        }
        return "";
    }

    private static /* synthetic */ CpuInfo[] $values() {
        return new CpuInfo[0];
    }

    static {
        $VALUES = CpuInfo.$values();
        SPACE_COLON_SPACE_PATTERN = Pattern.compile("\\s+:\\s");
    }
}

