/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import me.lucko.spark.paper.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.paper.common.platform.world.CountMap;
import me.lucko.spark.paper.common.platform.world.WorldInfoProvider;
import org.bukkit.Chunk;
import org.bukkit.GameRule;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class PaperWorldInfoProvider
implements WorldInfoProvider {
    private final Server server;

    public PaperWorldInfoProvider(Server server) {
        this.server = server;
    }

    @Override
    public WorldInfoProvider.CountsResult pollCounts() {
        int players = this.server.getOnlinePlayers().size();
        int entities = 0;
        int tileEntities = 0;
        int chunks = 0;
        for (World world : this.server.getWorlds()) {
            entities += world.getEntityCount();
            tileEntities += world.getTileEntityCount();
            chunks += world.getChunkCount();
        }
        return new WorldInfoProvider.CountsResult(players, entities, tileEntities, chunks);
    }

    public WorldInfoProvider.ChunksResult<PaperChunkInfo> pollChunks() {
        WorldInfoProvider.ChunksResult<PaperChunkInfo> data = new WorldInfoProvider.ChunksResult<PaperChunkInfo>();
        for (World world : this.server.getWorlds()) {
            Chunk[] chunks = world.getLoadedChunks();
            ArrayList<PaperChunkInfo> list = new ArrayList<PaperChunkInfo>(chunks.length);
            for (Chunk chunk : chunks) {
                if (chunk == null) continue;
                list.add(new PaperChunkInfo(chunk));
            }
            data.put(world.getName(), list);
        }
        return data;
    }

    @Override
    public WorldInfoProvider.GameRulesResult pollGameRules() {
        WorldInfoProvider.GameRulesResult data = new WorldInfoProvider.GameRulesResult();
        boolean addDefaults = true;
        for (World world : this.server.getWorlds()) {
            for (String gameRule : world.getGameRules()) {
                GameRule ruleObj = GameRule.getByName((String)gameRule);
                if (ruleObj == null) continue;
                if (addDefaults) {
                    Object defaultValue = world.getGameRuleDefault(ruleObj);
                    data.putDefault(gameRule, Objects.toString(defaultValue));
                }
                Object value = world.getGameRuleValue(ruleObj);
                data.put(gameRule, world.getName(), Objects.toString(value));
            }
            addDefaults = false;
        }
        return data;
    }

    @Override
    public Collection<WorldInfoProvider.DataPackInfo> pollDataPacks() {
        return this.server.getDataPackManager().getDataPacks().stream().map(pack -> new WorldInfoProvider.DataPackInfo(pack.getTitle(), pack.getDescription(), pack.getSource().name().toLowerCase(Locale.ROOT).replace("_", ""))).collect(Collectors.toList());
    }

    static final class PaperChunkInfo
    extends AbstractChunkInfo<EntityType> {
        private final CountMap<EntityType> entityCounts = new CountMap.EnumKeyed<EntityType>(EntityType.class);

        PaperChunkInfo(Chunk chunk) {
            super(chunk.getX(), chunk.getZ());
            for (Entity entity : chunk.getEntities()) {
                if (entity == null) continue;
                this.entityCounts.increment(entity.getType());
            }
        }

        @Override
        public CountMap<EntityType> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(EntityType type) {
            return type.getName();
        }
    }
}

