/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.api.FullySatisfiedContexts;
import me.lucko.luckperms.api.LookupSetting;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Contexts {
    public static final String SERVER_KEY = "server";
    public static final String WORLD_KEY = "world";
    private static final byte DEFAULT_SETTINGS_FLAG = LookupSetting.createFlag(LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER, LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD, LookupSetting.RESOLVE_INHERITANCE, LookupSetting.APPLY_PARENTS_SET_WITHOUT_SERVER, LookupSetting.APPLY_PARENTS_SET_WITHOUT_WORLD);
    private static final Contexts GLOBAL = new Contexts(ImmutableContextSet.empty(), DEFAULT_SETTINGS_FLAG);
    private final ImmutableContextSet contextSet;
    private final byte settingsFlag;
    private final int hashCode;

    public static @NonNull Contexts allowAll() {
        return FullySatisfiedContexts.getInstance();
    }

    public static @NonNull Contexts global() {
        return GLOBAL;
    }

    public static @NonNull Contexts of(@NonNull ContextSet contextSet, boolean includeNodesSetWithoutServer, boolean includeNodesSetWithoutWorld, boolean resolveInheritance, boolean applyParentsWithoutServer, boolean applyParentsWithoutWorld, boolean isOp) {
        Objects.requireNonNull(contextSet, "contextSet");
        byte settingsFlag = LookupSetting.createFlag(includeNodesSetWithoutServer, includeNodesSetWithoutWorld, resolveInheritance, applyParentsWithoutServer, applyParentsWithoutWorld, isOp);
        if (contextSet.isEmpty() && DEFAULT_SETTINGS_FLAG == settingsFlag) {
            return GLOBAL;
        }
        return new Contexts(contextSet.makeImmutable(), settingsFlag);
    }

    public static Contexts of(@NonNull ContextSet contextSet, @NonNull Set<LookupSetting> settings) {
        Objects.requireNonNull(contextSet, "contextSet");
        Objects.requireNonNull(settings, "settings");
        byte settingsFlag = LookupSetting.createFlag(settings);
        if (contextSet.isEmpty() && DEFAULT_SETTINGS_FLAG == settingsFlag) {
            return GLOBAL;
        }
        return new Contexts(contextSet.makeImmutable(), settingsFlag);
    }

    @Deprecated
    public Contexts(@NonNull ContextSet contextSet, boolean includeNodesSetWithoutServer, boolean includeNodesSetWithoutWorld, boolean resolveInheritance, boolean applyParentsWithoutServer, boolean applyParentsWithoutWorld, boolean isOp) {
        this.contextSet = Objects.requireNonNull(contextSet, "contextSet").makeImmutable();
        this.settingsFlag = LookupSetting.createFlag(includeNodesSetWithoutServer, includeNodesSetWithoutWorld, resolveInheritance, applyParentsWithoutServer, applyParentsWithoutWorld, isOp);
        this.hashCode = this.calculateHashCode();
    }

    protected Contexts(@NonNull ImmutableContextSet contextSet, byte settingsFlag) {
        this.contextSet = contextSet;
        this.settingsFlag = settingsFlag;
        this.hashCode = this.calculateHashCode();
    }

    public @NonNull ContextSet getContexts() {
        return this.contextSet;
    }

    public @NonNull Set<LookupSetting> getSettings() {
        return LookupSetting.createSetFromFlag(this.settingsFlag);
    }

    public @NonNull Contexts setContexts(@NonNull ContextSet contextSet) {
        ImmutableContextSet cs = Objects.requireNonNull(contextSet, "contextSet").makeImmutable();
        if (this.contextSet.equals(cs)) {
            return this;
        }
        return new Contexts(cs, this.settingsFlag);
    }

    public @NonNull Contexts setSettings(@NonNull Set<LookupSetting> settings) {
        Objects.requireNonNull(settings, "settings");
        byte settingsFlag = LookupSetting.createFlag(settings);
        if (this.settingsFlag == settingsFlag) {
            return this;
        }
        if (DEFAULT_SETTINGS_FLAG == settingsFlag && this.contextSet.isEmpty()) {
            return GLOBAL;
        }
        return new Contexts(this.contextSet, settingsFlag);
    }

    public boolean hasSetting(@NonNull LookupSetting setting) {
        return LookupSetting.isSet(this.settingsFlag, setting);
    }

    @Deprecated
    public boolean isOp() {
        return this.hasSetting(LookupSetting.IS_OP);
    }

    @Deprecated
    public boolean isIncludeGlobal() {
        return this.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_SERVER);
    }

    @Deprecated
    public boolean isIncludeGlobalWorld() {
        return this.hasSetting(LookupSetting.INCLUDE_NODES_SET_WITHOUT_WORLD);
    }

    @Deprecated
    public boolean isApplyGroups() {
        return this.hasSetting(LookupSetting.RESOLVE_INHERITANCE);
    }

    @Deprecated
    public boolean isApplyGlobalGroups() {
        return this.hasSetting(LookupSetting.APPLY_PARENTS_SET_WITHOUT_SERVER);
    }

    @Deprecated
    public boolean isApplyGlobalWorldGroups() {
        return this.hasSetting(LookupSetting.APPLY_PARENTS_SET_WITHOUT_WORLD);
    }

    public @NonNull String toString() {
        return "Contexts(contextSet=" + this.contextSet + ", settings=" + LookupSetting.createSetFromFlag(this.settingsFlag) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == Contexts.allowAll()) {
            return false;
        }
        if (!(o instanceof Contexts)) {
            return false;
        }
        Contexts that = (Contexts)o;
        return this.contextSet.equals(that.contextSet) && this.settingsFlag == that.settingsFlag;
    }

    private int calculateHashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.contextSet.hashCode();
        result = result * 59 + this.settingsFlag;
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

