/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.luckperms.api.ActionLogger;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.LPConfiguration;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.MessagingService;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.NodeFactory;
import me.lucko.luckperms.api.Storage;
import me.lucko.luckperms.api.Track;
import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.UuidCache;
import me.lucko.luckperms.api.context.ContextCalculator;
import me.lucko.luckperms.api.context.ContextManager;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.event.EventBus;
import me.lucko.luckperms.api.manager.GroupManager;
import me.lucko.luckperms.api.manager.TrackManager;
import me.lucko.luckperms.api.manager.UserManager;
import me.lucko.luckperms.api.messenger.MessengerProvider;
import me.lucko.luckperms.api.metastacking.MetaStackFactory;
import me.lucko.luckperms.api.platform.PlatformInfo;

public interface LuckPermsApi {
    @Nonnull
    public PlatformInfo getPlatformInfo();

    @Nonnull
    public UserManager getUserManager();

    @Nonnull
    public GroupManager getGroupManager();

    @Nonnull
    public TrackManager getTrackManager();

    @Nonnull
    public CompletableFuture<Void> runUpdateTask();

    @Nonnull
    public EventBus getEventBus();

    @Nonnull
    public LPConfiguration getConfiguration();

    @Nonnull
    public Storage getStorage();

    @Nonnull
    public Optional<MessagingService> getMessagingService();

    public void registerMessengerProvider(@Nonnull MessengerProvider var1);

    public ActionLogger getActionLogger();

    @Nonnull
    @Deprecated
    public UuidCache getUuidCache();

    public ContextManager getContextManager();

    @Nonnull
    public NodeFactory getNodeFactory();

    @Nonnull
    public MetaStackFactory getMetaStackFactory();

    @Nullable
    default public User getUser(@Nonnull UUID uuid) {
        return this.getUserManager().getUser(uuid);
    }

    @Nonnull
    default public Optional<User> getUserSafe(@Nonnull UUID uuid) {
        return this.getUserManager().getUserOpt(uuid);
    }

    @Nullable
    default public User getUser(@Nonnull String name) {
        return this.getUserManager().getUser(name);
    }

    @Nonnull
    default public Optional<User> getUserSafe(@Nonnull String name) {
        return this.getUserManager().getUserOpt(name);
    }

    @Nonnull
    default public Set<User> getUsers() {
        return this.getUserManager().getLoadedUsers();
    }

    default public boolean isUserLoaded(@Nonnull UUID uuid) {
        return this.getUserManager().isLoaded(uuid);
    }

    default public void cleanupUser(@Nonnull User user) {
        this.getUserManager().cleanupUser(user);
    }

    @Nullable
    default public Group getGroup(@Nonnull String name) {
        return this.getGroupManager().getGroup(name);
    }

    @Nonnull
    default public Optional<Group> getGroupSafe(@Nonnull String name) {
        return this.getGroupManager().getGroupOpt(name);
    }

    @Nonnull
    default public Set<Group> getGroups() {
        return this.getGroupManager().getLoadedGroups();
    }

    default public boolean isGroupLoaded(@Nonnull String name) {
        return this.getGroupManager().isLoaded(name);
    }

    @Nullable
    default public Track getTrack(@Nonnull String name) {
        return this.getTrackManager().getTrack(name);
    }

    @Nonnull
    default public Optional<Track> getTrackSafe(@Nonnull String name) {
        return this.getTrackManager().getTrackOpt(name);
    }

    @Nonnull
    default public Set<Track> getTracks() {
        return this.getTrackManager().getLoadedTracks();
    }

    default public boolean isTrackLoaded(@Nonnull String name) {
        return this.getTrackManager().isLoaded(name);
    }

    @Nonnull
    default public LogEntry.Builder newLogEntryBuilder() {
        return this.getActionLogger().newEntryBuilder();
    }

    @Nonnull
    default public Node.Builder buildNode(@Nonnull String permission) throws IllegalArgumentException {
        return this.getNodeFactory().newBuilder(permission);
    }

    default public void registerContextCalculator(@Nonnull ContextCalculator<?> calculator) {
        this.getContextManager().registerCalculator(calculator);
    }

    @Nonnull
    default public Optional<Contexts> getContextForUser(@Nonnull User user) {
        return this.getContextManager().lookupApplicableContexts(user);
    }

    @Nonnull
    default public ContextSet getContextForPlayer(@Nonnull Object player) {
        return this.getContextManager().getApplicableContext(player);
    }

    @Nonnull
    default public Contexts getContextsForPlayer(@Nonnull Object player) {
        return this.getContextManager().getApplicableContexts(player);
    }
}

