/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.Node;

public enum ChatMetaType {
    PREFIX("prefix"){

        @Override
        public boolean matches(@Nonnull Node node) {
            return Objects.requireNonNull(node, "node").isPrefix();
        }

        @Override
        @Nonnull
        public Map.Entry<Integer, String> getEntry(@Nonnull Node node) {
            return Objects.requireNonNull(node, "node").getPrefix();
        }
    }
    ,
    SUFFIX("suffix"){

        @Override
        public boolean matches(@Nonnull Node node) {
            return Objects.requireNonNull(node, "node").isSuffix();
        }

        @Override
        @Nonnull
        public Map.Entry<Integer, String> getEntry(@Nonnull Node node) {
            return Objects.requireNonNull(node, "node").getSuffix();
        }
    };

    private final String str;

    private ChatMetaType(String str) {
        this.str = str;
    }

    public abstract boolean matches(@Nonnull Node var1);

    public boolean shouldIgnore(@Nonnull Node node) {
        return !this.matches(node);
    }

    @Nonnull
    public abstract Map.Entry<Integer, String> getEntry(@Nonnull Node var1);

    public String toString() {
        return this.str;
    }

    @Nonnull
    public static Optional<ChatMetaType> ofNode(@Nonnull Node node) {
        if (node.isPrefix()) {
            return Optional.of(PREFIX);
        }
        if (node.isSuffix()) {
            return Optional.of(SUFFIX);
        }
        return Optional.empty();
    }
}

