/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.context.AbstractContextSet;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

public final class MutableContextSet
extends AbstractContextSet
implements ContextSet {
    private final SetMultimap<String, String> map;

    @Nonnull
    public static MutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        MutableContextSet set = MutableContextSet.create();
        set.add(key, value);
        return set;
    }

    @Nonnull
    public static MutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        Objects.requireNonNull(key1, "key1");
        Objects.requireNonNull(value1, "value1");
        Objects.requireNonNull(key2, "key2");
        Objects.requireNonNull(value2, "value2");
        MutableContextSet set = MutableContextSet.create();
        set.add(key1, value1);
        set.add(key2, value2);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        Objects.requireNonNull(iterable, "iterable");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(iterable);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromMap(@Nonnull Map<String, String> map) {
        Objects.requireNonNull(map, "map");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(map);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        Objects.requireNonNull(multimap, "multimap");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(multimap);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        Objects.requireNonNull(contextSet, "contextSet");
        MutableContextSet set = MutableContextSet.create();
        set.addAll(contextSet);
        return set;
    }

    @Nonnull
    public static MutableContextSet create() {
        return new MutableContextSet();
    }

    public MutableContextSet() {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    private MutableContextSet(MutableContextSet other) {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(other.map));
    }

    @Override
    protected Multimap<String, String> backing() {
        return this.map;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    @Nonnull
    public ImmutableContextSet makeImmutable() {
        if (this.map.isEmpty()) {
            return ImmutableContextSet.empty();
        }
        return new ImmutableContextSet((ImmutableSetMultimap<String, String>)ImmutableSetMultimap.copyOf(this.map));
    }

    @Override
    @Nonnull
    public MutableContextSet mutableCopy() {
        return new MutableContextSet(this);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> toSet() {
        return ImmutableSet.copyOf((Collection)this.map.entries());
    }

    @Override
    @Nonnull
    public Multimap<String, String> toMultimap() {
        return ImmutableSetMultimap.copyOf(this.map);
    }

    public void add(@Nonnull String key, @Nonnull String value) {
        this.map.put((Object)MutableContextSet.sanitizeKey(key), (Object)MutableContextSet.sanitizeValue(value));
    }

    public void add(@Nonnull Map.Entry<String, String> entry) {
        Objects.requireNonNull(entry, "entry");
        this.add(entry.getKey(), entry.getValue());
    }

    public void addAll(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        for (Map.Entry<String, String> entry : Objects.requireNonNull(iterable, "iterable")) {
            this.add(entry);
        }
    }

    public void addAll(@Nonnull Map<String, String> map) {
        this.addAll(Objects.requireNonNull(map, "map").entrySet());
    }

    public void addAll(@Nonnull Multimap<String, String> multimap) {
        this.addAll(Objects.requireNonNull(multimap, "multimap").entries());
    }

    public void addAll(@Nonnull ContextSet contextSet) {
        Objects.requireNonNull(contextSet, "contextSet");
        if (contextSet instanceof AbstractContextSet) {
            AbstractContextSet other = (AbstractContextSet)contextSet;
            this.map.putAll(other.backing());
        } else {
            this.addAll(contextSet.toMultimap());
        }
    }

    public void remove(@Nonnull String key, @Nonnull String value) {
        this.map.remove((Object)MutableContextSet.sanitizeKey(key), (Object)MutableContextSet.sanitizeValue(value));
    }

    public void removeIgnoreCase(@Nonnull String key, @Nonnull String value) {
        String v = MutableContextSet.sanitizeValue(value);
        Collection strings = (Collection)this.map.asMap().get(MutableContextSet.sanitizeKey(key));
        if (strings != null) {
            strings.removeIf(e -> e.equalsIgnoreCase(v));
        }
    }

    public void removeAll(@Nonnull String key) {
        this.map.removeAll((Object)MutableContextSet.sanitizeKey(key));
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return "MutableContextSet(contexts=" + this.map + ")";
    }
}

