/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import me.lucko.luckperms.api.FullySatisfiedContexts;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

@Immutable
public class Contexts {
    public static final String SERVER_KEY = "server";
    public static final String WORLD_KEY = "world";
    private static final Contexts GLOBAL = new Contexts(ContextSet.empty(), true, true, true, true, true, false);
    private final ImmutableContextSet context;
    private final boolean op;
    private final boolean includeGlobal;
    private final boolean includeGlobalWorld;
    private final boolean applyGroups;
    private final boolean applyGlobalGroups;
    private final boolean applyGlobalWorldGroups;
    private final int hashCode;

    @Nonnull
    public static Contexts allowAll() {
        return FullySatisfiedContexts.getInstance();
    }

    @Nonnull
    public static Contexts global() {
        return GLOBAL;
    }

    @Nonnull
    public static Contexts of(@Nonnull ContextSet context, boolean includeGlobal, boolean includeGlobalWorld, boolean applyGroups, boolean applyGlobalGroups, boolean applyGlobalWorldGroups, boolean op) {
        return new Contexts(context, includeGlobal, includeGlobalWorld, applyGroups, applyGlobalGroups, applyGlobalWorldGroups, op);
    }

    public Contexts(@Nonnull ContextSet context, boolean includeGlobal, boolean includeGlobalWorld, boolean applyGroups, boolean applyGlobalGroups, boolean applyGlobalWorldGroups, boolean op) {
        this.context = Objects.requireNonNull(context, "context").makeImmutable();
        this.includeGlobal = includeGlobal;
        this.includeGlobalWorld = includeGlobalWorld;
        this.applyGroups = applyGroups;
        this.applyGlobalGroups = applyGlobalGroups;
        this.applyGlobalWorldGroups = applyGlobalWorldGroups;
        this.op = op;
        this.hashCode = this.calculateHashCode();
    }

    @Nonnull
    public ContextSet getContexts() {
        return this.context;
    }

    public boolean isOp() {
        return this.op;
    }

    public boolean isIncludeGlobal() {
        return this.includeGlobal;
    }

    public boolean isIncludeGlobalWorld() {
        return this.includeGlobalWorld;
    }

    public boolean isApplyGroups() {
        return this.applyGroups;
    }

    public boolean isApplyGlobalGroups() {
        return this.applyGlobalGroups;
    }

    public boolean isApplyGlobalWorldGroups() {
        return this.applyGlobalWorldGroups;
    }

    @Nonnull
    public String toString() {
        return "Contexts(context=" + this.context + ", op=" + this.op + ", includeGlobal=" + this.includeGlobal + ", includeGlobalWorld=" + this.includeGlobalWorld + ", applyGroups=" + this.applyGroups + ", applyGlobalGroups=" + this.applyGlobalGroups + ", applyGlobalWorldGroups=" + this.applyGlobalWorldGroups + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == Contexts.allowAll()) {
            return false;
        }
        if (!(o instanceof Contexts)) {
            return false;
        }
        Contexts that = (Contexts)o;
        return this.context.equals(that.context) && this.op == that.op && this.includeGlobal == that.includeGlobal && this.includeGlobalWorld == that.includeGlobalWorld && this.applyGroups == that.applyGroups && this.applyGlobalGroups == that.applyGlobalGroups && this.applyGlobalWorldGroups == that.applyGlobalWorldGroups;
    }

    private int calculateHashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.context.hashCode();
        result = result * 59 + (this.op ? 79 : 97);
        result = result * 59 + (this.includeGlobal ? 79 : 97);
        result = result * 59 + (this.includeGlobalWorld ? 79 : 97);
        result = result * 59 + (this.applyGroups ? 79 : 97);
        result = result * 59 + (this.applyGlobalGroups ? 79 : 97);
        result = result * 59 + (this.applyGlobalWorldGroups ? 79 : 97);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

