/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

public final class MutableContextSet
implements ContextSet {
    private final SetMultimap<String, String> map;

    @Nonnull
    public static MutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        MutableContextSet set = new MutableContextSet();
        set.add(key, value);
        return set;
    }

    @Nonnull
    public static MutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        Preconditions.checkNotNull((Object)key1, (Object)"key1");
        Preconditions.checkNotNull((Object)value1, (Object)"value1");
        Preconditions.checkNotNull((Object)key2, (Object)"key2");
        Preconditions.checkNotNull((Object)value2, (Object)"value2");
        MutableContextSet ret = MutableContextSet.singleton(key1, value1);
        ret.add(key2, value2);
        return ret;
    }

    @Nonnull
    public static MutableContextSet fromMap(@Nonnull Map<String, String> map) {
        Preconditions.checkNotNull(map, (Object)"map");
        MutableContextSet set = new MutableContextSet();
        set.addAll(map);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        Preconditions.checkNotNull(iterable, (Object)"iterable");
        MutableContextSet set = new MutableContextSet();
        set.addAll(iterable);
        return set;
    }

    @Nonnull
    public static MutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        Preconditions.checkNotNull(multimap, (Object)"multimap");
        return MutableContextSet.fromEntries(multimap.entries());
    }

    @Nonnull
    public static MutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        Preconditions.checkNotNull((Object)contextSet, (Object)"contextSet");
        MutableContextSet set = new MutableContextSet();
        set.addAll(contextSet.toSet());
        return set;
    }

    @Nonnull
    public static MutableContextSet create() {
        return new MutableContextSet();
    }

    public MutableContextSet() {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    private MutableContextSet(Multimap<String, String> contexts) {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(contexts));
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public ImmutableContextSet makeImmutable() {
        return new ImmutableContextSet((Multimap<String, String>)this.map);
    }

    @Override
    public MutableContextSet mutableCopy() {
        return new MutableContextSet((Multimap<String, String>)this.map);
    }

    @Override
    public Set<Map.Entry<String, String>> toSet() {
        return ImmutableSet.copyOf((Collection)this.map.entries());
    }

    @Override
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    public Multimap<String, String> toMultimap() {
        return ImmutableSetMultimap.copyOf(this.map);
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.map.containsKey((Object)key);
    }

    @Override
    public Set<String> getValues(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Set c = this.map.get((Object)key);
        return c != null && !c.isEmpty() ? ImmutableSet.copyOf((Collection)c) : ImmutableSet.of();
    }

    @Override
    public boolean has(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.map.containsEntry((Object)key, (Object)value);
    }

    @Override
    public boolean hasIgnoreCase(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Set c = this.map.get((Object)key);
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String val : c) {
            if (!val.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public void add(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.map.put((Object)key.toLowerCase(), (Object)value);
    }

    public void add(Map.Entry<String, String> entry) {
        if (entry == null) {
            throw new NullPointerException("context");
        }
        this.map.put((Object)entry.getKey().toLowerCase(), (Object)entry.getValue());
    }

    public void addAll(Iterable<? extends Map.Entry<String, String>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        for (Map.Entry<String, String> entry : iterable) {
            this.map.put((Object)entry.getKey().toLowerCase(), (Object)entry.getValue());
        }
    }

    public void addAll(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        this.addAll(map.entrySet());
    }

    public void addAll(ContextSet contextSet) {
        if (contextSet == null) {
            throw new NullPointerException("contextSet");
        }
        this.map.putAll(contextSet.toMultimap());
    }

    public void remove(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.map.entries().removeIf(entry -> ((String)entry.getKey()).equals(key) && ((String)entry.getValue()).equals(value));
    }

    public void removeIgnoreCase(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.map.entries().removeIf(e -> ((String)e.getKey()).equalsIgnoreCase(key) && ((String)e.getValue()).equalsIgnoreCase(value));
    }

    public void removeAll(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.map.removeAll((Object)key.toLowerCase());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        Multimap<String, String> thisContexts = this.toMultimap();
        Multimap<String, String> otherContexts = other.toMultimap();
        return thisContexts == null ? otherContexts == null : thisContexts.equals(otherContexts);
    }

    public int hashCode() {
        return 59 + (this.map == null ? 43 : this.map.hashCode());
    }

    public String toString() {
        return "MutableContextSet(contexts=" + this.map + ")";
    }
}

