/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;

public final class ImmutableContextSet
implements ContextSet {
    private static final ImmutableContextSet EMPTY = new ImmutableContextSet((Multimap<String, String>)ImmutableSetMultimap.of());
    private final SetMultimap<String, String> map;

    @Nonnull
    public static ImmutableContextSet singleton(@Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        return new ImmutableContextSet((Multimap<String, String>)ImmutableSetMultimap.of((Object)key.toLowerCase(), (Object)value));
    }

    @Nonnull
    public static ImmutableContextSet of(@Nonnull String key1, @Nonnull String value1, @Nonnull String key2, @Nonnull String value2) {
        Preconditions.checkNotNull((Object)key1, (Object)"key1");
        Preconditions.checkNotNull((Object)value1, (Object)"value1");
        Preconditions.checkNotNull((Object)key2, (Object)"key2");
        Preconditions.checkNotNull((Object)value2, (Object)"value2");
        return new ImmutableContextSet((Multimap<String, String>)ImmutableSetMultimap.of((Object)key1.toLowerCase(), (Object)value1, (Object)key2.toLowerCase(), (Object)value2));
    }

    @Nonnull
    public static ImmutableContextSet fromMap(@Nonnull Map<String, String> map) {
        Preconditions.checkNotNull(map, (Object)"map");
        ImmutableSetMultimap.Builder b = ImmutableSetMultimap.builder();
        for (Map.Entry<String, String> e : map.entrySet()) {
            b.put((Object)e.getKey().toLowerCase(), (Object)e.getValue());
        }
        return new ImmutableContextSet((Multimap<String, String>)b.build());
    }

    @Nonnull
    public static ImmutableContextSet fromEntries(@Nonnull Iterable<? extends Map.Entry<String, String>> iterable) {
        Preconditions.checkNotNull(iterable, (Object)"iterable");
        return MutableContextSet.fromEntries(iterable).makeImmutable();
    }

    @Nonnull
    public static ImmutableContextSet fromMultimap(@Nonnull Multimap<String, String> multimap) {
        Preconditions.checkNotNull(multimap, (Object)"multimap");
        return MutableContextSet.fromMultimap(multimap).makeImmutable();
    }

    @Nonnull
    public static ImmutableContextSet fromSet(@Nonnull ContextSet contextSet) {
        return ((ContextSet)Preconditions.checkNotNull((Object)contextSet, (Object)"contextSet")).makeImmutable();
    }

    @Nonnull
    public static ImmutableContextSet empty() {
        return EMPTY;
    }

    ImmutableContextSet(Multimap<String, String> contexts) {
        this.map = ImmutableSetMultimap.copyOf(contexts);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    @Deprecated
    @Nonnull
    public ImmutableContextSet makeImmutable() {
        return this;
    }

    @Override
    @Nonnull
    public MutableContextSet mutableCopy() {
        return MutableContextSet.fromSet(this);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, String>> toSet() {
        return ImmutableSet.copyOf((Collection)this.map.entries());
    }

    @Override
    @Nonnull
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    @Nonnull
    public Multimap<String, String> toMultimap() {
        return this.map;
    }

    @Override
    public boolean containsKey(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        return this.map.containsKey((Object)key);
    }

    @Override
    public Set<String> getValues(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Set c = this.map.get((Object)key);
        return c != null && !c.isEmpty() ? ImmutableSet.copyOf((Collection)c) : ImmutableSet.of();
    }

    @Override
    public boolean has(@Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        return this.map.containsEntry((Object)key, (Object)value);
    }

    @Override
    public boolean hasIgnoreCase(@Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        Set c = this.map.get((Object)key);
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String val : c) {
            if (!val.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        Multimap<String, String> thisContexts = this.toMultimap();
        Multimap<String, String> otherContexts = other.toMultimap();
        return thisContexts.equals(otherContexts);
    }

    public int hashCode() {
        return 59 + (this.map == null ? 43 : this.map.hashCode());
    }

    public String toString() {
        return "ImmutableContextSet(contexts=" + this.map + ")";
    }
}

