/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.HashSet;
import java.util.Map;
import me.lucko.luckperms.LuckPerms;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.PermissionHolder;
import me.lucko.luckperms.exceptions.ObjectAlreadyHasException;
import me.lucko.luckperms.exceptions.ObjectLacksException;

@Deprecated
public class MetaUtils {
    private static String escapeDelimiters(String s, String ... delims) {
        for (String delim : delims) {
            s = s.replace(delim, "\\" + delim);
        }
        return s;
    }

    private static String unescapeDelimiters(String s, String ... delims) {
        for (String delim : delims) {
            s = s.replace("\\" + delim, delim);
        }
        return s;
    }

    public static String escapeCharacters(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        return MetaUtils.escapeDelimiters(s, ".", "/", "-", "$");
    }

    public static String unescapeCharacters(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        s = s.replace("{SEP}", ".");
        s = s.replace("{FSEP}", "/");
        s = s.replace("{DSEP}", "$");
        s = MetaUtils.unescapeDelimiters(s, ".", "/", "-", "$");
        return s;
    }

    public static void setMeta(PermissionHolder holder, String server, String world, String key, String value) {
        if (holder == null) {
            throw new NullPointerException("holder");
        }
        if (key == null) {
            throw new NullPointerException("node");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("node is empty");
        }
        if (value.equals("")) {
            throw new IllegalArgumentException("value is empty");
        }
        key = MetaUtils.escapeCharacters(key);
        value = MetaUtils.escapeCharacters(value);
        HashSet<Node> toRemove = new HashSet<Node>();
        for (Node node : holder.getEnduringPermissions()) {
            if (!node.isMeta() || !node.getMeta().getKey().equals(key)) continue;
            toRemove.add(node);
        }
        for (Node node : toRemove) {
            try {
                holder.unsetPermission(node);
            }
            catch (ObjectLacksException objectLacksException) {}
        }
        Node.Builder metaNode = LuckPerms.getApi().buildNode("meta." + key + "." + value).setValue(true);
        if (server != null) {
            metaNode.setServer(server);
        }
        if (world != null) {
            metaNode.setWorld(world);
        }
        try {
            holder.setPermission(metaNode.build());
        }
        catch (ObjectAlreadyHasException objectAlreadyHasException) {
            // empty catch block
        }
    }

    public static String getMeta(PermissionHolder holder, String server, String world, String node, String defaultValue, boolean includeGlobal) {
        if (holder == null) {
            throw new NullPointerException("holder");
        }
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.equals("")) {
            throw new IllegalArgumentException("node is empty");
        }
        node = MetaUtils.escapeCharacters(node);
        for (Node node2 : holder.getPermissions()) {
            Map.Entry<String, String> meta;
            if (!node2.getValue().booleanValue() || !node2.isMeta() || !node2.shouldApplyOnServer(server, includeGlobal, false) || !node2.shouldApplyOnWorld(world, includeGlobal, false) || !(meta = node2.getMeta()).getKey().equalsIgnoreCase(node)) continue;
            return MetaUtils.unescapeCharacters(meta.getValue());
        }
        return defaultValue;
    }

    private static void setChatMeta(boolean prefix, PermissionHolder holder, String value, int priority, String server, String world) {
        if (holder == null) {
            throw new NullPointerException("holder");
        }
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException("value is null/empty");
        }
        Node.Builder node = LuckPerms.getApi().buildNode(prefix ? "prefix" : "suffix." + priority + "." + MetaUtils.escapeCharacters(value));
        node.setValue(true);
        if (server != null) {
            node.setServer(server);
        }
        if (world != null) {
            node.setWorld(world);
        }
        try {
            holder.setPermission(node.build());
        }
        catch (ObjectAlreadyHasException objectAlreadyHasException) {
            // empty catch block
        }
    }

    public static void setPrefix(PermissionHolder holder, String prefix, int priority, String server, String world) {
        MetaUtils.setChatMeta(true, holder, prefix, priority, server, world);
    }

    public static void setSuffix(PermissionHolder holder, String suffix, int priority, String server, String world) {
        MetaUtils.setChatMeta(false, holder, suffix, priority, server, world);
    }

    private static String getChatMeta(boolean prefix, PermissionHolder holder, String server, String world, boolean includeGlobal) {
        if (holder == null) {
            throw new NullPointerException("holder");
        }
        int priority = Integer.MIN_VALUE;
        String meta = null;
        for (Node node : holder.getAllNodes(Contexts.allowAll())) {
            Map.Entry<Integer, String> value;
            if (!node.getValue().booleanValue() || !node.shouldApplyOnServer(server, includeGlobal, false) || !node.shouldApplyOnWorld(world, includeGlobal, false) || (!prefix ? !node.isSuffix() : !node.isPrefix()) || (value = prefix ? node.getPrefix() : node.getSuffix()).getKey() <= priority) continue;
            meta = value.getValue();
            priority = value.getKey();
        }
        return meta == null ? "" : MetaUtils.unescapeCharacters(meta);
    }

    public static String getPrefix(PermissionHolder holder, String server, String world, boolean includeGlobal) {
        return MetaUtils.getChatMeta(true, holder, server, world, includeGlobal);
    }

    public static String getSuffix(PermissionHolder holder, String server, String world, boolean includeGlobal) {
        return MetaUtils.getChatMeta(false, holder, server, world, includeGlobal);
    }

    private MetaUtils() {
    }
}

