/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LogEntry
implements Comparable<LogEntry> {
    private static final String FORMAT = "&8(&e%s&8) [&a%s&8] (&b%s&8) &7--> &f%s";
    private long timestamp;
    private UUID actor;
    private String actorName;
    private char type;
    private UUID acted;
    private String actedName;
    private String action;

    @Nonnull
    public static LogEntryBuilder builder() {
        return new LogEntryBuilder();
    }

    public LogEntry(long timestamp, @Nonnull UUID actor, @Nonnull String actorName, char type, @Nullable UUID acted, @Nonnull String actedName, @Nonnull String action) {
        if (actor == null) {
            throw new NullPointerException("actor");
        }
        if (actorName == null) {
            throw new NullPointerException("actorName");
        }
        if (actedName == null) {
            throw new NullPointerException("actedName");
        }
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.timestamp = timestamp;
        this.actor = actor;
        this.actorName = actorName;
        this.type = type;
        this.acted = acted;
        this.actedName = actedName;
        this.action = action;
    }

    protected LogEntry() {
        this.timestamp = 0L;
        this.actor = null;
        this.actorName = null;
        this.type = '\u0000';
        this.acted = null;
        this.actedName = null;
        this.action = null;
    }

    @Override
    public int compareTo(LogEntry o) {
        return this.equals(o) ? 0 : (Long.compare(this.timestamp, o.getTimestamp()) == 0 ? 1 : Long.compare(this.timestamp, o.getTimestamp()));
    }

    public boolean matchesSearch(@Nonnull String query) {
        query = query.toLowerCase();
        return this.actorName.toLowerCase().contains(query) || this.actedName.toLowerCase().contains(query) || this.action.toLowerCase().contains(query);
    }

    @Nonnull
    public String getFormatted() {
        return String.format(FORMAT, String.valueOf(this.actorName).equals("null") ? this.actor.toString() : this.actorName, Character.toString(this.type), String.valueOf(this.actedName).equals("null") && this.acted != null ? this.acted.toString() : this.actedName, this.action);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Nonnull
    public UUID getActor() {
        return this.actor;
    }

    void setActor(@Nonnull UUID actor) {
        this.actor = actor;
    }

    @Nonnull
    public String getActorName() {
        return this.actorName;
    }

    void setActorName(@Nonnull String actorName) {
        this.actorName = actorName;
    }

    public char getType() {
        return this.type;
    }

    void setType(char type) {
        this.type = type;
    }

    @Nullable
    public UUID getActed() {
        return this.acted;
    }

    void setActed(@Nullable UUID acted) {
        this.acted = acted;
    }

    @Nonnull
    public String getActedName() {
        return this.actedName;
    }

    void setActedName(@Nonnull String actedName) {
        this.actedName = actedName;
    }

    @Nonnull
    public String getAction() {
        return this.action;
    }

    void setAction(@Nonnull String action) {
        this.action = action;
    }

    public String toString() {
        return "LogEntry(timestamp=" + this.getTimestamp() + ", actor=" + this.getActor() + ", actorName=" + this.getActorName() + ", type=" + this.getType() + ", acted=" + this.getActed() + ", actedName=" + this.getActedName() + ", action=" + this.getAction() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEntry)) {
            return false;
        }
        LogEntry other = (LogEntry)o;
        return this.getTimestamp() == other.getTimestamp() && (this.getActor() == null ? other.getActor() == null : this.getActor().equals(other.getActor())) && (this.getActorName() == null ? other.getActorName() == null : this.getActorName().equals(other.getActorName())) && this.getType() == other.getType() && (this.getActed() == null ? other.getActed() == null : this.getActed().equals(other.getActed())) && (this.getActedName() == null ? other.getActedName() == null : this.getActedName().equals(other.getActedName())) && (this.getAction() == null ? other.getAction() == null : this.getAction().equals(other.getAction()));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (int)(this.getTimestamp() >>> 32 ^ this.getTimestamp());
        result = result * 59 + (this.getActor() == null ? 43 : this.getActor().hashCode());
        result = result * 59 + (this.getActorName() == null ? 43 : this.getActorName().hashCode());
        result = result * 59 + this.getType();
        result = result * 59 + (this.getActed() == null ? 43 : this.getActed().hashCode());
        result = result * 59 + (this.getActedName() == null ? 43 : this.getActedName().hashCode());
        result = result * 59 + (this.getAction() == null ? 43 : this.getAction().hashCode());
        return result;
    }

    public static abstract class AbstractLogEntryBuilder<T extends LogEntry, B extends AbstractLogEntryBuilder<T, B>> {
        private T obj = this.createObj();
        private B thisObj = this.getThis();

        protected abstract T createObj();

        protected abstract B getThis();

        public long getTimestamp() {
            return ((LogEntry)this.obj).getTimestamp();
        }

        public UUID getActor() {
            return ((LogEntry)this.obj).getActor();
        }

        public String getActorName() {
            return ((LogEntry)this.obj).getActorName();
        }

        public char getType() {
            return ((LogEntry)this.obj).getType();
        }

        public UUID getActed() {
            return ((LogEntry)this.obj).getActed();
        }

        public String getActedName() {
            return ((LogEntry)this.obj).getActedName();
        }

        public String getAction() {
            return ((LogEntry)this.obj).getAction();
        }

        public B timestamp(long timestamp) {
            ((LogEntry)this.obj).setTimestamp(timestamp);
            return this.thisObj;
        }

        public B actor(UUID actor) {
            ((LogEntry)this.obj).setActor(actor);
            return this.thisObj;
        }

        public B actorName(String actorName) {
            ((LogEntry)this.obj).setActorName(actorName);
            return this.thisObj;
        }

        public B type(char type) {
            ((LogEntry)this.obj).setType(type);
            return this.thisObj;
        }

        public B acted(UUID acted) {
            ((LogEntry)this.obj).setActed(acted);
            return this.thisObj;
        }

        public B actedName(String actedName) {
            ((LogEntry)this.obj).setActedName(actedName);
            return this.thisObj;
        }

        public B action(String action) {
            ((LogEntry)this.obj).setAction(action);
            return this.thisObj;
        }

        public T build() {
            if (this.getActor() == null) {
                throw new NullPointerException("actor");
            }
            if (this.getActorName() == null) {
                throw new NullPointerException("actorName");
            }
            if (this.getActedName() == null) {
                throw new NullPointerException("actedName");
            }
            if (this.getAction() == null) {
                throw new NullPointerException("action");
            }
            return this.obj;
        }

        public String toString() {
            return "LogEntry.LogEntryBuilder(timestamp=" + this.getTimestamp() + ", actor=" + this.getActor() + ", actorName=" + this.getActorName() + ", type=" + this.getType() + ", acted=" + this.getActed() + ", actedName=" + this.getActedName() + ", action=" + this.getAction() + ")";
        }
    }

    public static class LogEntryBuilder
    extends AbstractLogEntryBuilder<LogEntry, LogEntryBuilder> {
        @Override
        protected LogEntry createObj() {
            return new LogEntry();
        }

        @Override
        protected LogEntryBuilder getThis() {
            return this;
        }
    }
}

